/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.fakes.BiomeArrayInterface;
import carpet.fakes.ChunkGeneratorInterface;
import carpet.fakes.ChunkTicketManagerInterface;
import carpet.fakes.ServerChunkManagerInterface;
import carpet.fakes.SpawnHelperInnerInterface;
import carpet.fakes.ThreadedAnvilChunkStorageInterface;
import carpet.helpers.FeatureGenerator;
import carpet.mixins.PointOfInterest_scarpetMixin;
import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.utils.BiomeInfo;
import carpet.script.utils.WorldTools;
import carpet.script.value.BlockValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import carpet.utils.BlockInfo;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_10;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2288;
import net.minecraft.class_2290;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2515;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_3341;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_3494;
import net.minecraft.class_3748;
import net.minecraft.class_3829;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_4538;
import net.minecraft.class_4706;
import net.minecraft.class_5312;
import net.minecraft.class_5415;

public class WorldAccess {
    private static final Map<String, class_2350> DIRECTION_MAP = Arrays.stream(class_2350.values()).collect(Collectors.toMap(class_2350::method_10151, direction -> direction));
    private static final Map<String, class_3230<?>> ticketTypes = new HashMap<String, class_3230<?>>(){
        {
            this.put("portal", class_3230.field_19280);
            this.put("teleport", class_3230.field_19347);
            this.put("unknown", class_3230.field_14032);
        }
    };
    private static class_1540 DUMMY_ENTITY = new class_1540(class_1299.field_6089, null);

    private static LazyValue booleanStateTest(Context c, String name, List<LazyValue> params, BiFunction<class_2680, class_2338, Boolean> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.size() == 0) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value v0 = params.get(0).evalValue(c);
        if (v0 instanceof BlockValue) {
            Value retval = test.apply(((BlockValue)v0).getBlockState(), ((BlockValue)v0).getPos()) != false ? Value.TRUE : Value.FALSE;
            return (c_, t_) -> retval;
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        Value retval = test.apply(block.getBlockState(), block.getPos()) != false ? Value.TRUE : Value.FALSE;
        return (c_, t_) -> retval;
    }

    private static LazyValue stateStringQuery(Context c, String name, List<LazyValue> params, BiFunction<class_2680, class_2338, String> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.size() == 0) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value v0 = params.get(0).evalValue(c);
        if (v0 instanceof BlockValue) {
            String strVal = test.apply(((BlockValue)v0).getBlockState(), ((BlockValue)v0).getPos());
            Value retval = strVal != null ? new StringValue(strVal) : Value.NULL;
            return (c_, t_) -> retval;
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        String strVal = test.apply(block.getBlockState(), block.getPos());
        Value retval = strVal != null ? new StringValue(strVal) : Value.NULL;
        return (c_, t_) -> retval;
    }

    private static LazyValue genericStateTest(Context c, String name, List<LazyValue> params, Fluff.TriFunction<class_2680, class_2338, class_1937, Value> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.size() == 0) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value v0 = params.get(0).evalValue(c);
        if (v0 instanceof BlockValue) {
            try {
                Value retval = test.apply(((BlockValue)v0).getBlockState(), ((BlockValue)v0).getPos(), (class_1937)cc.s.method_9225());
                return (_c, _t) -> retval;
            }
            catch (NullPointerException ignored) {
                throw new InternalExpressionException("'" + name + "' function requires a block that is positioned in the world");
            }
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        Value retval = test.apply(block.getBlockState(), block.getPos(), (class_1937)cc.s.method_9225());
        return (c_, t_) -> retval;
    }

    private static <T extends Comparable<T>> class_2680 setProperty(class_2769<T> property, String name, String value, class_2680 bs) {
        Optional optional = property.method_11900(value);
        if (!optional.isPresent()) {
            throw new InternalExpressionException(value + " is not a valid value for property " + name);
        }
        bs = (class_2680)bs.method_11657(property, (Comparable)optional.get());
        return bs;
    }

    private static boolean tryBreakBlock_copy_from_ServerPlayerInteractionManager(class_3222 player, class_2338 blockPos_1) {
        class_2680 blockState_1 = player.field_6002.method_8320(blockPos_1);
        if (!player.method_6047().method_7909().method_7885(blockState_1, player.field_6002, blockPos_1, (class_1657)player)) {
            return false;
        }
        class_2586 blockEntity_1 = player.field_6002.method_8321(blockPos_1);
        class_2248 block_1 = blockState_1.method_26204();
        if ((block_1 instanceof class_2288 || block_1 instanceof class_2515 || block_1 instanceof class_3748) && !player.method_7338()) {
            player.field_6002.method_8413(blockPos_1, blockState_1, blockState_1, 3);
            return false;
        }
        if (player.method_21701(player.field_6002, blockPos_1, player.field_13974.method_14257())) {
            return false;
        }
        block_1.method_9576(player.field_6002, blockPos_1, blockState_1, (class_1657)player);
        boolean boolean_1 = player.field_6002.method_8650(blockPos_1, false);
        if (boolean_1) {
            block_1.method_9585((class_1936)player.field_6002, blockPos_1, blockState_1);
        }
        if (player.method_7337()) {
            return true;
        }
        class_1799 itemStack_1 = player.method_6047();
        boolean boolean_2 = player.method_7305(blockState_1);
        itemStack_1.method_7952(player.field_6002, blockState_1, blockPos_1, (class_1657)player);
        if (boolean_1 && boolean_2) {
            class_1799 itemStack_2 = itemStack_1.method_7960() ? class_1799.field_8037 : itemStack_1.method_7972();
            block_1.method_9556(player.field_6002, (class_1657)player, blockPos_1, blockState_1, blockEntity_1, itemStack_2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void BooYah(class_2794 generator) {
        class_2794 class_27942 = generator;
        synchronized (class_27942) {
            ((ChunkGeneratorInterface)generator).initStrongholds();
        }
    }

    public static void apply(Expression expression) {
        expression.addLazyFunction("block", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() == 0) {
                throw new InternalExpressionException("Block requires at least one parameter");
            }
            BlockValue retval = BlockArgument.findIn((CarpetContext)cc, (List<LazyValue>)lv, (int)0, (boolean)true).block;
            retval.getBlockState();
            retval.getData();
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("block_data", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() == 0) {
                throw new InternalExpressionException("Block requires at least one parameter");
            }
            class_2487 tag = BlockArgument.findIn((CarpetContext)cc, (List<LazyValue>)lv, (int)0, (boolean)true).block.getData();
            if (tag == null) {
                return (c_, t_) -> Value.NULL;
            }
            NBTSerializableValue retval = new NBTSerializableValue((class_2520)tag);
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("poi", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'poi' requires at least one parameter");
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false);
            class_2338 pos = locator.block.getPos();
            class_4153 store = cc.s.method_9225().method_19494();
            if (lv.size() == locator.offset) {
                class_4158 poiType = store.method_19132(pos).orElse(null);
                if (poiType == null) {
                    return LazyValue.NULL;
                }
                class_4156 poi = store.method_19125(poiType.method_19164(), pos, 1, class_4153.class_4155.field_18489).filter(p -> p.method_19141().equals((Object)pos)).findFirst().orElse(null);
                if (poi == null) {
                    return LazyValue.NULL;
                }
                ListValue ret = ListValue.of(new StringValue(poi.method_19142().toString()), new NumericValue(poiType.method_19161() - ((PointOfInterest_scarpetMixin)poi).getFreeTickets()));
                return (_c, _t) -> ret;
            }
            int radius = NumericValue.asNumber(((LazyValue)lv.get(locator.offset + 0)).evalValue((Context)c)).getInt();
            if (radius < 0) {
                return ListValue.lazyEmpty();
            }
            Predicate<class_4158> condition = class_4158.field_18501;
            class_4153.class_4155 status = class_4153.class_4155.field_18489;
            boolean inColumn = false;
            if (locator.offset + 1 < lv.size()) {
                String poiType = ((LazyValue)lv.get(locator.offset + 1)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT);
                if (!"any".equals(poiType)) {
                    class_4158 type = (class_4158)class_2378.field_18792.method_10223(new class_2960(poiType));
                    if (type == class_4158.field_18502 && !"unemployed".equals(poiType)) {
                        return LazyValue.NULL;
                    }
                    condition = tt -> tt == type;
                }
                if (locator.offset + 2 < lv.size()) {
                    String statusString = ((LazyValue)lv.get(locator.offset + 2)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT);
                    if ("occupied".equals(statusString)) {
                        status = class_4153.class_4155.field_18488;
                    } else if ("available".equals(statusString)) {
                        status = class_4153.class_4155.field_18487;
                    } else if (!"any".equals(statusString)) {
                        throw new InternalExpressionException("Incorrect POI occupation status " + status + " use `any`, `occupied` or `available`");
                    }
                    if (locator.offset + 3 < lv.size()) {
                        inColumn = ((LazyValue)lv.get(locator.offset + 3)).evalValue((Context)c, 2).getBoolean();
                    }
                }
            }
            Stream pois = inColumn ? store.method_22383((Predicate)condition, pos, radius, status) : store.method_19125((Predicate)condition, pos, radius, status);
            ListValue ret = ListValue.wrap(pois.sorted(Comparator.comparingDouble(p -> p.method_19141().method_10262((class_2382)pos))).map(p -> ListValue.of(new StringValue(p.method_19142().toString()), new NumericValue(p.method_19142().method_19161() - ((PointOfInterest_scarpetMixin)p).getFreeTickets()), ListValue.of(new NumericValue(p.method_19141().method_10263()), new NumericValue(p.method_19141().method_10264()), new NumericValue(p.method_19141().method_10260())))).collect(Collectors.toList()));
            return (c_, t_) -> ret;
        });
        expression.addLazyFunction("set_poi", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'set_poi' requires at least one parameter");
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false);
            class_2338 pos = locator.block.getPos();
            if (lv.size() < locator.offset) {
                throw new InternalExpressionException("'set_poi' requires the new poi type or null, after position argument");
            }
            Value poi = ((LazyValue)lv.get(locator.offset + 0)).evalValue((Context)c);
            class_4153 store = cc.s.method_9225().method_19494();
            if (poi.isNull()) {
                if (store.method_19132(pos).isPresent()) {
                    store.method_19112(pos);
                    return LazyValue.TRUE;
                }
                return LazyValue.FALSE;
            }
            String poiTypeString = poi.getString().toLowerCase(Locale.ROOT);
            class_4158 type = (class_4158)class_2378.field_18792.method_10223(new class_2960(poiTypeString));
            if (type == class_4158.field_18502 && !"unemployed".equals(poiTypeString)) {
                throw new InternalExpressionException("Unknown POI type: " + poiTypeString);
            }
            int occupancy = 0;
            if (locator.offset + 1 < lv.size() && (occupancy = (int)NumericValue.asNumber(((LazyValue)lv.get(locator.offset + 1)).evalValue((Context)c)).getLong()) < 0) {
                throw new InternalExpressionException("Occupancy cannot be negative");
            }
            if (store.method_19132(pos).isPresent()) {
                store.method_19112(pos);
            }
            store.method_19115(pos, type);
            if (occupancy > 0) {
                int finalO = occupancy;
                store.method_22383(tt -> tt == type, pos, 1, class_4153.class_4155.field_18489).filter(p -> p.method_19141().equals((Object)pos)).findFirst().ifPresent(p -> {
                    for (int i = 0; i < finalO; ++i) {
                        ((PointOfInterest_scarpetMixin)p).callReserveTicket();
                    }
                });
            }
            return LazyValue.TRUE;
        });
        expression.addLazyFunction("pos", 1, (c, t, lv) -> {
            Value arg = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (arg instanceof BlockValue) {
                class_2338 pos = ((BlockValue)arg).getPos();
                if (pos == null) {
                    throw new InternalExpressionException("Cannot fetch position of an unrealized block");
                }
                ListValue retval = ListValue.of(new NumericValue(pos.method_10263()), new NumericValue(pos.method_10264()), new NumericValue(pos.method_10260()));
                return (c_, t_) -> retval;
            }
            if (arg instanceof EntityValue) {
                class_1297 e = ((EntityValue)arg).getEntity();
                if (e == null) {
                    throw new InternalExpressionException("Null entity");
                }
                ListValue retval = ListValue.of(new NumericValue(e.method_23317()), new NumericValue(e.method_23318()), new NumericValue(e.method_23321()));
                return (c_, t_) -> retval;
            }
            throw new InternalExpressionException("'pos' works only with a block or an entity type");
        });
        expression.addLazyFunction("pos_offset", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2338 pos = locator.block.getPos();
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'pos_offset' needs at least position, and direction");
            }
            String directionString = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString();
            class_2350 dir = DIRECTION_MAP.get(directionString);
            if (dir == null) {
                throw new InternalExpressionException("Unknown direction: " + directionString);
            }
            int howMuch = 1;
            if (lv.size() > locator.offset + 1) {
                howMuch = (int)NumericValue.asNumber(((LazyValue)lv.get(locator.offset + 1)).evalValue((Context)c)).getLong();
            }
            class_2338 retpos = pos.method_10079(dir, howMuch);
            ListValue ret = ListValue.of(new NumericValue(retpos.method_10263()), new NumericValue(retpos.method_10264()), new NumericValue(retpos.method_10260()));
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("solid", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "solid", lv, (s, p, w) -> new NumericValue(s.method_26212((class_1922)w, p))));
        expression.addLazyFunction("air", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "air", lv, (s, p) -> s.method_26215()));
        expression.addLazyFunction("liquid", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "liquid", lv, (s, p) -> !s.method_26227().method_15769()));
        expression.addLazyFunction("flammable", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "flammable", lv, (s, p) -> s.method_26207().method_15802()));
        expression.addLazyFunction("transparent", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "transparent", lv, (s, p) -> !s.method_26207().method_15799()));
        expression.addLazyFunction("emitted_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "emitted_light", lv, (s, p, w) -> new NumericValue(s.method_26213())));
        expression.addLazyFunction("light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "light", lv, (s, p, w) -> new NumericValue(Math.max(w.method_8314(class_1944.field_9282, p), w.method_8314(class_1944.field_9284, p)))));
        expression.addLazyFunction("block_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "block_light", lv, (s, p, w) -> new NumericValue(w.method_8314(class_1944.field_9282, p))));
        expression.addLazyFunction("sky_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "sky_light", lv, (s, p, w) -> new NumericValue(w.method_8314(class_1944.field_9284, p))));
        expression.addLazyFunction("see_sky", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "see_sky", lv, (s, p, w) -> new NumericValue(w.method_8311(p))));
        expression.addLazyFunction("brightness", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "brightness", lv, (s, p, w) -> new NumericValue(w.method_22349(p))));
        expression.addLazyFunction("hardness", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "hardness", lv, (s, p, w) -> new NumericValue(s.method_26214((class_1922)w, p))));
        expression.addLazyFunction("blast_resistance", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "blast_resistance", lv, (s, p, w) -> new NumericValue(s.method_26204().method_9520())));
        expression.addLazyFunction("in_slime_chunk", -1, (c, t, lv) -> {
            class_2338 pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<LazyValue>)lv, (int)0).block.getPos();
            class_1923 chunkPos = new class_1923(pos);
            NumericValue ret = new NumericValue(class_2919.method_12662((int)chunkPos.field_9181, (int)chunkPos.field_9180, (long)((CarpetContext)c).s.method_9225().method_8412(), (long)987234911L).nextInt(10) == 0);
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("top", -1, (c, t, lv) -> {
            class_2902.class_2903 htype;
            String type;
            switch (type = ((LazyValue)lv.get(0)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT)) {
                case "motion": {
                    htype = class_2902.class_2903.field_13197;
                    break;
                }
                case "terrain": {
                    htype = class_2902.class_2903.field_13203;
                    break;
                }
                case "ocean_floor": {
                    htype = class_2902.class_2903.field_13200;
                    break;
                }
                case "surface": {
                    htype = class_2902.class_2903.field_13202;
                    break;
                }
                default: {
                    throw new InternalExpressionException("Unknown heightmap type: " + type);
                }
            }
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 1);
            class_2338 pos = locator.block.getPos();
            int x = pos.method_10263();
            int z = pos.method_10260();
            NumericValue retval = new NumericValue(((CarpetContext)c).s.method_9225().method_8497(x >> 4, z >> 4).method_12005(htype, x & 0xF, z & 0xF) + 1);
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("loaded", -1, (c, t, lv) -> {
            Value retval = ((CarpetContext)c).s.method_9225().method_22340(BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<LazyValue>)lv, (int)0).block.getPos()) ? Value.TRUE : Value.FALSE;
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("loaded_ep", -1, (c, t, lv) -> {
            c.host.issueDeprecation("loaded_ep(...)");
            class_2338 pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<LazyValue>)lv, (int)0).block.getPos();
            Value retval = ((CarpetContext)c).s.method_9225().method_14178().method_20591(new class_1923(pos)) ? Value.TRUE : Value.FALSE;
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("loaded_status", -1, (c, t, lv) -> {
            class_2338 pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<LazyValue>)lv, (int)0).block.getPos();
            class_2818 chunk = ((CarpetContext)c).s.method_9225().method_14178().method_12126(pos.method_10263() >> 4, pos.method_10260() >> 4, false);
            if (chunk == null) {
                return LazyValue.ZERO;
            }
            NumericValue retval = new NumericValue(chunk.method_12225().ordinal());
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("is_chunk_generated", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2338 pos = locator.block.getPos();
            boolean force = false;
            if (lv.size() > locator.offset) {
                force = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c, 2).getBoolean();
            }
            NumericValue retval = new NumericValue(WorldTools.canHasChunk(((CarpetContext)c).s.method_9225(), new class_1923(pos), null, force));
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("generation_status", -1, (c, t, lv) -> {
            class_2791 chunk;
            BlockArgument blockArgument = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2338 pos = blockArgument.block.getPos();
            boolean forceLoad = false;
            if (lv.size() > blockArgument.offset) {
                forceLoad = ((LazyValue)lv.get(blockArgument.offset)).evalValue((Context)c, 2).getBoolean();
            }
            if ((chunk = ((CarpetContext)c).s.method_9225().method_8402(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_12798, forceLoad)) == null) {
                return LazyValue.NULL;
            }
            StringValue retval = new StringValue(chunk.method_12009().method_12172());
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("chunk_tickets", -1, (c, t, lv) -> {
            class_3218 world = ((CarpetContext)c).s.method_9225();
            Long2ObjectOpenHashMap<class_4706<class_3228<?>>> levelTickets = ((ChunkTicketManagerInterface)((ServerChunkManagerInterface)world.method_14178()).getCMTicketManager()).getTicketsByPosition();
            ArrayList<Value> res = new ArrayList<Value>();
            if (lv.size() == 0) {
                LongIterator longIterator = levelTickets.keySet().iterator();
                while (longIterator.hasNext()) {
                    long key = (Long)longIterator.next();
                    class_1923 chpos = new class_1923(key);
                    for (class_3228 ticket : (class_4706)levelTickets.get(key)) {
                        res.add(ListValue.of(new StringValue(ticket.method_14281().toString()), new NumericValue(33 - ticket.method_14283()), new NumericValue(chpos.field_9181), new NumericValue(chpos.field_9180)));
                    }
                }
            } else {
                BlockArgument blockArgument = BlockArgument.findIn((CarpetContext)c, lv, 0);
                class_2338 pos = blockArgument.block.getPos();
                class_4706 tickets = (class_4706)levelTickets.get(new class_1923(pos).method_8324());
                if (tickets != null) {
                    for (class_3228 ticket : tickets) {
                        res.add(ListValue.of(new StringValue(ticket.method_14281().toString()), new NumericValue(33 - ticket.method_14283())));
                    }
                }
            }
            res.sort(Comparator.comparing(e -> ((ListValue)e).getItems().get(1)).reversed());
            ListValue returnValue = ListValue.wrap(res);
            return (_c, _t) -> returnValue;
        });
        expression.addLazyFunction("suffocates", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "suffocates", lv, (s, p, w) -> new NumericValue(s.method_26228((class_1922)w, p))));
        expression.addLazyFunction("power", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "power", lv, (s, p, w) -> new NumericValue(w.method_8482(p))));
        expression.addLazyFunction("ticks_randomly", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "ticks_randomly", lv, (s, p) -> s.method_26229()));
        expression.addLazyFunction("update", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "update", lv, (s, p) -> {
            ((CarpetContext)c).s.method_9225().method_8492(p, s.method_26204(), p);
            return true;
        }));
        expression.addLazyFunction("block_tick", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "block_tick", lv, (s, p) -> {
            class_3218 w = ((CarpetContext)c).s.method_9225();
            s.method_26199(w, p, w.field_9229);
            return true;
        }));
        expression.addLazyFunction("random_tick", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "random_tick", lv, (s, p) -> {
            class_3218 w = ((CarpetContext)c).s.method_9225();
            if (s.method_26229() || s.method_26227().method_15773()) {
                s.method_26199(w, p, w.field_9229);
            }
            return true;
        }));
        expression.addLazyFunction("without_updates", 1, (c, t, lv) -> {
            boolean previous = CarpetSettings.impendingFillSkipUpdates;
            if (previous) {
                return (LazyValue)lv.get(0);
            }
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).s.method_9211().method_19537(() -> {
                try {
                    CarpetSettings.impendingFillSkipUpdates = true;
                    result[0] = ((LazyValue)lv.get(0)).evalValue((Context)c, (Integer)t);
                }
                finally {
                    CarpetSettings.impendingFillSkipUpdates = previous;
                }
            });
            return (cc, tt) -> result[0];
        });
        expression.addLazyFunction("set", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            BlockArgument targetLocator = BlockArgument.findIn(cc, lv, 0);
            BlockArgument sourceLocator = BlockArgument.findIn(cc, lv, targetLocator.offset, true);
            class_2680 sourceBlockState = sourceLocator.block.getBlockState();
            class_2680 targetBlockState = world.method_8320(targetLocator.block.getPos());
            class_2487 data = null;
            if (lv.size() > sourceLocator.offset) {
                Value dataValue;
                List<Object> args = new ArrayList<Value>();
                int m = lv.size();
                for (int i = sourceLocator.offset; i < m; ++i) {
                    args.add(((LazyValue)lv.get(i)).evalValue((Context)c));
                }
                if (args.get(0) instanceof ListValue) {
                    Value dataValue2;
                    if (args.size() == 2 && (dataValue2 = NBTSerializableValue.fromValue((Value)args.get(1))) instanceof NBTSerializableValue) {
                        data = ((NBTSerializableValue)dataValue2).getCompoundTag();
                    }
                    args = ((ListValue)args.get(0)).getItems();
                } else if ((args.size() & 1) == 1 && (dataValue = NBTSerializableValue.fromValue((Value)args.get(args.size() - 1))) instanceof NBTSerializableValue) {
                    data = ((NBTSerializableValue)dataValue).getCompoundTag();
                }
                class_2689 states = sourceBlockState.method_26204().method_9595();
                for (int i = 0; i < args.size() - 1; i += 2) {
                    String paramString = ((Value)args.get(i)).getString();
                    class_2769 property = states.method_11663(paramString);
                    if (property == null) {
                        throw new InternalExpressionException("Property " + paramString + " doesn't apply to " + sourceLocator.block.getString());
                    }
                    String paramValue = ((Value)args.get(i + 1)).getString();
                    sourceBlockState = WorldAccess.setProperty(property, paramString, paramValue, sourceBlockState);
                }
            }
            if (data == null) {
                data = sourceLocator.block.getData();
            }
            class_2487 finalData = data;
            if (sourceBlockState == targetBlockState && data == null) {
                return (c_, t_) -> Value.FALSE;
            }
            class_2680 finalSourceBlockState = sourceBlockState;
            class_2338 targetPos = targetLocator.block.getPos();
            Boolean[] result = new Boolean[]{true};
            cc.s.method_9211().method_19537(() -> {
                class_2586 be;
                class_3829.method_16825((Object)world.method_8321(targetPos));
                boolean success = world.method_8652(targetPos, finalSourceBlockState, 2);
                if (success && finalData != null && (be = world.method_8321(targetPos)) != null) {
                    class_2487 destTag = finalData.method_10553();
                    destTag.method_10569("x", targetPos.method_10263());
                    destTag.method_10569("y", targetPos.method_10264());
                    destTag.method_10569("z", targetPos.method_10260());
                    be.method_11014(finalSourceBlockState, destTag);
                    be.method_5431();
                }
                result[0] = success;
            });
            if (!result[0].booleanValue()) {
                return LazyValue.FALSE;
            }
            BlockValue retval = new BlockValue(finalSourceBlockState, world, targetLocator.block.getPos());
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("destroy", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2680 state = locator.block.getBlockState();
            if (state.method_26215()) {
                return (c_, t_) -> Value.FALSE;
            }
            class_2338 where = locator.block.getPos();
            class_2586 be = world.method_8321(where);
            long how = 0L;
            class_1792 item = class_1802.field_8377;
            boolean playerBreak = false;
            if (lv.size() > locator.offset) {
                Value val = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c);
                if (val instanceof NumericValue) {
                    how = ((NumericValue)val).getLong();
                } else {
                    playerBreak = true;
                    String itemString = val.getString();
                    item = (class_1792)class_2378.field_11142.method_10223(new class_2960(itemString));
                    if (item == class_1802.field_8162 && !itemString.equals("air")) {
                        throw new InternalExpressionException("Incorrect item: " + itemString);
                    }
                }
            }
            class_2487 tag = null;
            if (lv.size() > locator.offset + 1) {
                if (!playerBreak) {
                    throw new InternalExpressionException("tag is not necessary with 'destroy' with no item");
                }
                Value tagValue = ((LazyValue)lv.get(locator.offset + 1)).evalValue((Context)c);
                if (tagValue instanceof NullValue) {
                    tag = null;
                } else if (tagValue instanceof NBTSerializableValue) {
                    tag = ((NBTSerializableValue)tagValue).getCompoundTag();
                } else {
                    NBTSerializableValue readTag = NBTSerializableValue.parseString(tagValue.getString(), true);
                    tag = readTag.getCompoundTag();
                }
            }
            class_1799 tool = new class_1799((class_1935)item, 1);
            if (tag != null) {
                tool.method_7980(tag);
            }
            if (playerBreak && (double)state.method_26214((class_1922)world, where) < 0.0) {
                return LazyValue.FALSE;
            }
            boolean removed = world.method_8650(where, false);
            if (!removed) {
                return LazyValue.FALSE;
            }
            world.method_8444(null, 2001, where, class_2248.method_9507((class_2680)state));
            boolean toolBroke = false;
            boolean dropLoot = true;
            if (playerBreak) {
                boolean isUsingEffectiveTool = !state.method_29291() || tool.method_7951(state);
                float hardness = state.method_26214((class_1922)world, where);
                int damageAmount = 0;
                if (item instanceof class_1766 && (double)hardness > 0.0 || item instanceof class_1820) {
                    damageAmount = 1;
                } else if (item instanceof class_1835 || item instanceof class_1829) {
                    damageAmount = 2;
                }
                boolean bl = toolBroke = damageAmount > 0 && tool.method_7970(damageAmount, world.method_8409(), null);
                if (!isUsingEffectiveTool) {
                    dropLoot = false;
                }
            }
            if (dropLoot) {
                if (how < 0L || tag != null && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)tool) > 0) {
                    class_2248.method_9577((class_1937)world, (class_2338)where, (class_1799)new class_1799((class_1935)state.method_26204()));
                } else {
                    if (how > 0L) {
                        tool.method_7978(class_1893.field_9130, (int)how);
                    }
                    class_2248.method_9511((class_2680)state, (class_1937)world, (class_2338)where, (class_2586)be, (class_1297)DUMMY_ENTITY, (class_1799)tool);
                }
            }
            if (!playerBreak) {
                return (c_, t_) -> Value.TRUE;
            }
            if (toolBroke) {
                return LazyValue.NULL;
            }
            class_2487 outtag = tool.method_7969();
            if (outtag == null) {
                return LazyValue.TRUE;
            }
            NBTSerializableValue ret = new NBTSerializableValue(() -> WorldAccess.lambda$null$92((class_2520)outtag));
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("harvest", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'harvest' takes at least 2 parameters: entity and block, or position, to harvest");
            }
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            Value entityValue = ((LazyValue)lv.get(0)).evalValue(cc);
            if (!(entityValue instanceof EntityValue)) {
                return (c_, t_) -> Value.FALSE;
            }
            class_1297 e = ((EntityValue)entityValue).getEntity();
            if (!(e instanceof class_3222)) {
                return (c_, t_) -> Value.FALSE;
            }
            class_3222 player = (class_3222)e;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 1);
            class_2338 where = locator.block.getPos();
            class_2680 state = locator.block.getBlockState();
            class_2248 block = state.method_26204();
            boolean success = false;
            if (block != class_2246.field_9987 && block != class_2246.field_10499 || !player.field_13974.method_14267()) {
                success = WorldAccess.tryBreakBlock_copy_from_ServerPlayerInteractionManager(player, where);
            }
            if (success) {
                world.method_8444(null, 2001, where, class_2248.method_9507((class_2680)state));
            }
            return success ? LazyValue.TRUE : LazyValue.FALSE;
        });
        expression.addLazyFunction("place_item", -1, (c, t, lv) -> {
            BlockValue.PlacementContext ctx;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'place_item' takes at least 2 parameters: item and block, or position, to place onto");
            }
            CarpetContext cc = (CarpetContext)c;
            String itemString = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            Vector3Argument locator = Vector3Argument.findIn(cc, lv, 1);
            class_2290 stackArg = NBTSerializableValue.parseItem(itemString);
            class_2338 where = new class_2338(locator.vec);
            String facing = "up";
            if (lv.size() > locator.offset) {
                facing = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString();
            }
            boolean sneakPlace = false;
            if (lv.size() > locator.offset + 1) {
                sneakPlace = ((LazyValue)lv.get(locator.offset + 1)).evalValue((Context)c).getBoolean();
            }
            try {
                ctx = BlockValue.PlacementContext.from((class_1937)cc.s.method_9225(), where, facing, sneakPlace, stackArg.method_9781(1, false));
            }
            catch (CommandSyntaxException e) {
                throw new InternalExpressionException(e.getMessage());
            }
            if (!(stackArg.method_9785() instanceof class_1747)) {
                class_1269 useResult = ctx.method_8041().method_7981((class_1838)ctx);
                if (useResult == class_1269.field_21466 || useResult == class_1269.field_5812) {
                    return LazyValue.TRUE;
                }
            } else {
                class_1747 blockItem = (class_1747)stackArg.method_9785();
                if (!ctx.method_7716()) {
                    return (_c, _t) -> Value.FALSE;
                }
                class_2680 placementState = blockItem.method_7711().method_9605((class_1750)ctx);
                if (placementState != null && placementState.method_26184((class_4538)cc.s.method_9225(), where)) {
                    cc.s.method_9225().method_8652(where, placementState, 2);
                    class_2498 blockSoundGroup = placementState.method_26231();
                    cc.s.method_9225().method_8396(null, where, blockSoundGroup.method_10598(), class_3419.field_15245, (blockSoundGroup.method_10597() + 1.0f) / 2.0f, blockSoundGroup.method_10599() * 0.8f);
                    return (_c, _t) -> Value.TRUE;
                }
            }
            return (_c, _t) -> Value.FALSE;
        });
        expression.addLazyFunction("blocks_movement", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "blocks_movement", lv, (s, p) -> !s.method_26171((class_1922)((CarpetContext)c).s.method_9225(), p, class_10.field_50)));
        expression.addLazyFunction("block_sound", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "block_sound", lv, (s, p) -> BlockInfo.soundName.get(s.method_26231())));
        expression.addLazyFunction("material", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "material", lv, (s, p) -> BlockInfo.materialName.get(s.method_26207())));
        expression.addLazyFunction("map_colour", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "map_colour", lv, (s, p) -> BlockInfo.mapColourName.get(s.method_26205((class_1922)((CarpetContext)c).s.method_9225(), p))));
        expression.addLazyFunction("property", -1, (c, t, lv) -> {
            c.host.issueDeprecation("property(...)");
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2680 state = locator.block.getBlockState();
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'property' requires to specify a property to query");
            }
            String tag = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString();
            class_2689 states = state.method_26204().method_9595();
            class_2769 property = states.method_11663(tag);
            if (property == null) {
                return LazyValue.NULL;
            }
            StringValue retval = new StringValue(state.method_11654(property).toString().toLowerCase(Locale.ROOT));
            return (_c, _t) -> retval;
        });
        expression.addLazyFunction("block_properties", -1, (c, t, lv) -> {
            c.host.issueDeprecation("block_properties(...)");
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2680 state = locator.block.getBlockState();
            class_2689 states = state.method_26204().method_9595();
            ListValue res = ListValue.wrap(states.method_11659().stream().map(p -> new StringValue(p.method_11899())).collect(Collectors.toList()));
            return (_c, _t) -> res;
        });
        expression.addLazyFunction("block_state", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0, true);
            class_2680 state = locator.block.getBlockState();
            class_2689 states = state.method_26204().method_9595();
            if (locator.offset == lv.size()) {
                HashMap<Value, Value> properties = new HashMap<Value, Value>();
                for (class_2769 p : states.method_11659()) {
                    properties.put(StringValue.of(p.method_11899()), ValueConversions.fromProperty(state, p));
                }
                MapValue ret = MapValue.wrap(properties);
                return (_c, _t) -> ret;
            }
            String tag = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString();
            class_2769 property = states.method_11663(tag);
            if (property == null) {
                return LazyValue.NULL;
            }
            Value retval = ValueConversions.fromProperty(state, property);
            return (_c, _t) -> retval;
        });
        expression.addLazyFunction("block_list", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                ListValue ret = ListValue.wrap(class_2378.field_11146.method_10235().stream().map(ValueConversions::of).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            CarpetContext cc = (CarpetContext)c;
            class_5415 tagManager = cc.s.method_9211().method_3801();
            String tag = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            class_3494 blockTag = tagManager.method_30215().method_30210(new class_2960(tag));
            if (blockTag == null) {
                return LazyValue.NULL;
            }
            ListValue ret = ListValue.wrap(blockTag.method_15138().stream().map(b -> ValueConversions.of(class_2378.field_11146.method_10221(b))).collect(Collectors.toList()));
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("block_tags", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_5415 tagManager = cc.s.method_9211().method_3801();
            if (lv.size() == 0) {
                ListValue ret = ListValue.wrap(tagManager.method_30215().method_30211().stream().map(ValueConversions::of).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            BlockArgument blockLocator = BlockArgument.findIn(cc, lv, 0, true);
            if (blockLocator.offset == lv.size()) {
                ListValue ret = ListValue.wrap(tagManager.method_30215().method_30206((Object)blockLocator.block.getBlockState().method_26204()).stream().map(ValueConversions::of).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            String tag = ((LazyValue)lv.get(blockLocator.offset)).evalValue((Context)c).getString();
            class_3494 blockTag = tagManager.method_30215().method_30210(new class_2960(tag));
            if (blockTag == null) {
                return LazyValue.NULL;
            }
            return blockLocator.block.getBlockState().method_26164(blockTag) ? LazyValue.TRUE : LazyValue.FALSE;
        });
        expression.addLazyFunction("biome", -1, (c, t, lv) -> {
            class_1959 biome;
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            if (lv.size() == 0) {
                ListValue ret = ListValue.wrap(world.method_30349().method_30530(class_2378.field_25114).method_10235().stream().map(ValueConversions::of));
                return (_c, _t) -> ret;
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false, false, true);
            if (locator.replacement != null) {
                biome = (class_1959)world.method_30349().method_30530(class_2378.field_25114).method_10223(new class_2960(locator.replacement));
                if (biome == null) {
                    return LazyValue.NULL;
                }
            } else {
                class_2338 pos = locator.block.getPos();
                biome = world.method_23753(pos);
            }
            if (locator.offset == lv.size()) {
                class_2960 biomeId = cc.s.method_9211().method_30611().method_30530(class_2378.field_25114).method_10221((Object)biome);
                StringValue res = new StringValue(NBTSerializableValue.nameFromRegistryId(biomeId));
                return (_c, _t) -> res;
            }
            String biomeFeature = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString();
            BiFunction<class_3218, class_1959, Value> featureProvider = BiomeInfo.biomeFeatures.get(biomeFeature);
            if (featureProvider == null) {
                throw new InternalExpressionException("Unknown biome feature: " + biomeFeature);
            }
            Value ret = featureProvider.apply(world, biome);
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("set_biome", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            if (lv.size() == locator.offset) {
                throw new InternalExpressionException("'set_biome' needs a biome name as an argument");
            }
            String biomeName = ((LazyValue)lv.get(locator.offset + 0)).evalValue((Context)c).getString();
            class_1959 biome = (class_1959)cc.s.method_9211().method_30611().method_30530(class_2378.field_25114).method_10223(new class_2960(biomeName));
            if (biome == null) {
                throw new InternalExpressionException("Unknown biome: " + biomeName);
            }
            boolean doImmediateUpdate = true;
            if (lv.size() > locator.offset + 1) {
                doImmediateUpdate = ((LazyValue)lv.get(locator.offset + 1)).evalValue((Context)c).getBoolean();
            }
            class_3218 world = cc.s.method_9225();
            class_2338 pos = locator.block.getPos();
            class_2791 chunk = world.method_22342(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_12794);
            ((BiomeArrayInterface)chunk.method_12036()).setBiomeAtIndex(pos, (class_1937)world, biome);
            if (doImmediateUpdate) {
                WorldTools.forceChunkUpdate(pos, world);
            }
            return LazyValue.TRUE;
        });
        expression.addLazyFunction("reload_chunk", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2338 pos = BlockArgument.findIn((CarpetContext)cc, (List<LazyValue>)lv, (int)0).block.getPos();
            class_3218 world = cc.s.method_9225();
            cc.s.method_9211().method_19537(() -> WorldTools.forceChunkUpdate(pos, world));
            return LazyValue.TRUE;
        });
        expression.addLazyFunction("structure_references", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_3218 world = cc.s.method_9225();
            class_2338 pos = locator.block.getPos();
            Map references = world.method_22342(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_16422).method_12179();
            if (lv.size() == locator.offset) {
                List referenceList = references.entrySet().stream().filter(e -> e.getValue() != null && !((LongSet)e.getValue()).isEmpty()).map(e -> new StringValue(NBTSerializableValue.nameFromRegistryId(class_2378.field_16644.method_10221(e.getKey())))).collect(Collectors.toList());
                return (_c, _t) -> ListValue.wrap(referenceList);
            }
            String simpleStructureName = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT);
            class_3195 structureName = (class_3195)class_2378.field_16644.method_10223(new class_2960(simpleStructureName));
            if (structureName == null) {
                return LazyValue.NULL;
            }
            LongSet structureReferences = (LongSet)references.get(structureName);
            if (structureReferences == null || structureReferences.isEmpty()) {
                return ListValue.lazyEmpty();
            }
            ListValue ret = ListValue.wrap(structureReferences.stream().map(l -> ListValue.of(new NumericValue(16 * class_1923.method_8325((long)l)), Value.ZERO, new NumericValue(16 * class_1923.method_8332((long)l)))).collect(Collectors.toList()));
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("structure_eligibility", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_3218 world = cc.s.method_9225();
            WorldAccess.BooYah(world.method_14178().method_12129());
            class_2338 pos = locator.block.getPos();
            class_3195 structure = null;
            boolean needSize = false;
            if (lv.size() > locator.offset) {
                String reqString;
                Value requested = ((LazyValue)lv.get(locator.offset + 0)).evalValue((Context)c);
                if (!(requested instanceof NullValue) && (structure = (class_3195)class_2378.field_16644.method_10223(new class_2960(reqString = requested.getString()))) == null) {
                    throw new InternalExpressionException("Unknown structure: " + reqString);
                }
                if (lv.size() > locator.offset + 1) {
                    needSize = ((LazyValue)lv.get(locator.offset + 1)).evalValue((Context)c).getBoolean();
                }
            }
            if (structure != null) {
                class_3449 start = FeatureGenerator.shouldStructureStartAt(world, pos, structure, needSize);
                if (start == null) {
                    return LazyValue.NULL;
                }
                if (!needSize) {
                    return LazyValue.TRUE;
                }
                Value ret = ValueConversions.of(start);
                return (_c, _t) -> ret;
            }
            HashMap<Value, Value> ret = new HashMap<Value, Value>();
            for (class_3195 str : class_3195.field_24842.values()) {
                class_3449 start;
                try {
                    start = FeatureGenerator.shouldStructureStartAt(world, pos, str, needSize);
                }
                catch (NullPointerException npe) {
                    CarpetSettings.LOG.error("Failed to detect structure: " + str.method_14019());
                    start = null;
                }
                if (start == null) continue;
                StringValue key = new StringValue(NBTSerializableValue.nameFromRegistryId(class_2378.field_16644.method_10221((Object)str)));
                ret.put(key, !needSize ? Value.NULL : ValueConversions.of(start));
            }
            MapValue retMap = MapValue.wrap(ret);
            return (_c, _t) -> retMap;
        });
        expression.addLazyFunction("structures", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_3218 world = cc.s.method_9225();
            class_2338 pos = locator.block.getPos();
            Map structures = world.method_22342(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_16423).method_12016();
            if (lv.size() == locator.offset) {
                HashMap<Value, Value> structureList = new HashMap<Value, Value>();
                for (Map.Entry entry : structures.entrySet()) {
                    class_3449 start = (class_3449)entry.getValue();
                    if (start == class_3449.field_16713) continue;
                    class_3341 box = start.method_14968();
                    structureList.put(new StringValue(NBTSerializableValue.nameFromRegistryId(class_2378.field_16644.method_10221(entry.getKey()))), ListValue.of(ListValue.fromTriple(box.field_14381, box.field_14380, box.field_14379), ListValue.fromTriple(box.field_14378, box.field_14377, box.field_14376)));
                }
                MapValue ret = MapValue.wrap(structureList);
                return (_c, _t) -> ret;
            }
            String structureName = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT);
            class_3449 start = (class_3449)structures.get(class_2378.field_16644.method_10223(new class_2960(structureName)));
            Value ret = ValueConversions.of(start);
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("set_structure", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_3218 world = cc.s.method_9225();
            class_2338 pos = locator.block.getPos();
            if (lv.size() == locator.offset) {
                throw new InternalExpressionException("'set_structure requires at least position and a structure name");
            }
            String structureName = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT);
            class_5312<?, ?> configuredStructure = FeatureGenerator.resolveConfiguredStructure(structureName, world, pos);
            if (configuredStructure == null) {
                throw new InternalExpressionException("Unknown structure: " + structureName);
            }
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).s.method_9211().method_19537(() -> {
                Map structures = world.method_22350(pos).method_12016();
                if (lv.size() == locator.offset + 1) {
                    Boolean res = FeatureGenerator.plopGrid(configuredStructure, ((CarpetContext)c).s.method_9225(), locator.block.getPos());
                    if (res == null) {
                        return;
                    }
                    result[0] = res != false ? Value.TRUE : Value.FALSE;
                    return;
                }
                Value newValue = ((LazyValue)lv.get(locator.offset + 1)).evalValue((Context)c);
                if (newValue instanceof NullValue) {
                    class_3195 structure = configuredStructure.field_24835;
                    if (!structures.containsKey(structure)) {
                        return;
                    }
                    class_3449 start = (class_3449)structures.get(structure);
                    class_1923 structureChunkPos = new class_1923(start.method_14967(), start.method_14966());
                    class_3341 box = start.method_14968();
                    for (int chx = box.field_14381 / 16; chx <= box.field_14378 / 16; ++chx) {
                        for (int chz = box.field_14379 / 16; chz <= box.field_14376 / 16; ++chz) {
                            class_1923 chpos = new class_1923(chx, chz);
                            Map references = world.method_22350(chpos.method_8323()).method_12179();
                            if (!references.containsKey(structure) || references.get(structure) == null) continue;
                            ((LongSet)references.get(structure)).remove(structureChunkPos.method_8324());
                        }
                    }
                    structures.remove(structure);
                    result[0] = Value.TRUE;
                }
            });
            Value ret = result[0];
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("custom_dimension", -1, (c, t, lv) -> {
            boolean success;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'custom_dimension' requires at least one argument");
            }
            CarpetContext cc = (CarpetContext)c;
            String worldKey = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            Long seed = null;
            if (lv.size() > 1) {
                String seedKey = ((LazyValue)lv.get(1)).evalValue((Context)c).getString();
                try {
                    seed = Long.parseLong(seedKey);
                }
                catch (NumberFormatException ignored) {
                    throw new InternalExpressionException("Incorrect number format for seed: " + seedKey);
                }
            }
            if (!(success = WorldTools.createWorld(cc.s.method_9211(), worldKey, seed))) {
                return LazyValue.FALSE;
            }
            CarpetServer.settingsManager.notifyPlayersCommandsChanged();
            return LazyValue.TRUE;
        });
        expression.addLazyFunction("reset_chunk", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            ArrayList<class_1923> requestedChunks = new ArrayList<class_1923>();
            if (lv.size() == 1) {
                Value first = ((LazyValue)lv.get(0)).evalValue((Context)c);
                if (first instanceof ListValue) {
                    List<Value> listVal = ((ListValue)first).getItems();
                    boolean offset = false;
                    BlockArgument locator = BlockArgument.findInValues(cc, listVal, 0, false, false);
                    requestedChunks.add(new class_1923(locator.block.getPos()));
                    while (listVal.size() > locator.offset) {
                        locator = BlockArgument.findInValues(cc, listVal, locator.offset, false, false);
                        requestedChunks.add(new class_1923(locator.block.getPos()));
                    }
                } else {
                    BlockArgument locator = BlockArgument.findInValues(cc, Collections.singletonList(first), 0, false, false);
                    requestedChunks.add(new class_1923(locator.block.getPos()));
                }
            } else {
                BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
                class_1923 from = new class_1923(locator.block.getPos());
                if (lv.size() > locator.offset) {
                    locator = BlockArgument.findIn(cc, lv, locator.offset);
                    class_1923 to = new class_1923(locator.block.getPos());
                    int xmax = Math.max(from.field_9181, to.field_9181);
                    int zmax = Math.max(from.field_9180, to.field_9180);
                    for (int x = Math.min(from.field_9181, to.field_9181); x <= xmax; ++x) {
                        for (int z = Math.min(from.field_9180, to.field_9180); z <= zmax; ++z) {
                            requestedChunks.add(new class_1923(x, z));
                        }
                    }
                } else {
                    requestedChunks.add(from);
                }
            }
            class_3218 world = cc.s.method_9225();
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).s.method_9211().method_19537(() -> {
                Map<String, Integer> report = ((ThreadedAnvilChunkStorageInterface)world.method_14178().field_17254).regenerateChunkRegion(requestedChunks);
                for (class_1923 chpos : requestedChunks) {
                    if (world.method_8402(chpos.field_9181, chpos.field_9180, class_2806.field_12803, false) == null) continue;
                    WorldTools.forceChunkUpdate(chpos.method_8323(), world);
                }
                result[0] = MapValue.wrap(report.entrySet().stream().collect(Collectors.toMap(e -> new StringValue((String)e.getKey()), e -> new NumericValue(((Integer)e.getValue()).intValue()))));
            });
            return (_c, _t) -> result[0];
        });
        expression.addLazyFunction("inhabited_time", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2338 pos = locator.block.getPos();
            NumericValue ret = new NumericValue(cc.s.method_9225().method_22350(pos).method_12033());
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("spawn_potential", -1, (c, t, lv) -> {
            class_1948.class_5262 charger;
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2338 pos = locator.block.getPos();
            double required_charge = 1.0;
            if (lv.size() > locator.offset) {
                required_charge = NumericValue.asNumber(((LazyValue)lv.get(locator.offset)).evalValue((Context)c)).getDouble();
            }
            if ((charger = cc.s.method_9225().method_14178().method_27908()) == null) {
                return LazyValue.NULL;
            }
            NumericValue ret = new NumericValue(((SpawnHelperInnerInterface)charger).getPotentialCalculator().method_27832(pos, required_charge));
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("add_chunk_ticket", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2338 pos = locator.block.getPos();
            if (lv.size() != locator.offset + 2) {
                throw new InternalExpressionException("'add_chunk_ticket' requires block position, ticket type and radius");
            }
            String type = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString();
            class_3230<?> ticket = ticketTypes.get(type.toLowerCase(Locale.ROOT));
            if (ticket == null) {
                throw new InternalExpressionException("Unknown ticket type: " + type);
            }
            int radius = NumericValue.asNumber(((LazyValue)lv.get(locator.offset + 1)).evalValue((Context)c)).getInt();
            if (radius < 1 || radius > 32) {
                throw new InternalExpressionException("Ticket radius should be between 1 and 32 chunks");
            }
            class_1923 target = new class_1923(pos);
            if (ticket == class_3230.field_19280) {
                cc.s.method_9225().method_14178().method_17297(class_3230.field_19280, target, radius, (Object)pos);
            } else if (ticket == class_3230.field_19347) {
                cc.s.method_9225().method_14178().method_17297(class_3230.field_19347, target, radius, (Object)1);
            } else {
                cc.s.method_9225().method_14178().method_17297(class_3230.field_14032, target, radius, (Object)target);
            }
            NumericValue ret = new NumericValue(ticket.method_20629());
            return (_c, _t) -> ret;
        });
    }

    private static /* synthetic */ class_2520 lambda$null$92(class_2520 outtag) {
        return outtag;
    }
}

