/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.argument;

import carpet.script.CarpetContext;
import carpet.script.LazyValue;
import carpet.script.argument.Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BlockValue;
import carpet.script.value.ListValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.List;
import net.minecraft.class_2338;

public class BlockArgument
extends Argument {
    public final BlockValue block;
    public final String replacement;

    private BlockArgument(BlockValue b, int o) {
        super(o);
        this.block = b;
        this.replacement = null;
    }

    private BlockArgument(BlockValue b, int o, String replacement) {
        super(o);
        this.block = b;
        this.replacement = replacement;
    }

    public static BlockArgument findIn(CarpetContext c, List<LazyValue> params, int offset) {
        return BlockArgument.findIn(c, params, offset, false, false, false);
    }

    public static BlockArgument findIn(CarpetContext c, List<LazyValue> params, int offset, boolean acceptString) {
        return BlockArgument.findIn(c, params, offset, acceptString, false, false);
    }

    public static BlockArgument findIn(CarpetContext c, List<LazyValue> params, int offset, boolean acceptString, boolean optional, boolean anyString) {
        try {
            Value v1 = params.get(0 + offset).evalValue(c);
            if (optional && v1 instanceof NullValue) {
                return new BlockArgument(null, 1 + offset);
            }
            if (anyString && v1 instanceof StringValue) {
                return new BlockArgument(null, 1 + offset, v1.getString());
            }
            if (acceptString && v1 instanceof StringValue) {
                return new BlockArgument(BlockValue.fromString(v1.getString()), 1 + offset);
            }
            if (v1 instanceof BlockValue) {
                return new BlockArgument((BlockValue)v1, 1 + offset);
            }
            if (v1 instanceof ListValue) {
                List<Value> args = ((ListValue)v1).getItems();
                int xpos = (int)NumericValue.asNumber(args.get(0)).getLong();
                int ypos = (int)NumericValue.asNumber(args.get(1)).getLong();
                int zpos = (int)NumericValue.asNumber(args.get(2)).getLong();
                return new BlockArgument(new BlockValue(null, c.s.method_9225(), new class_2338(c.origin.method_10263() + xpos, c.origin.method_10264() + ypos, c.origin.method_10260() + zpos)), 1 + offset);
            }
            int xpos = (int)NumericValue.asNumber(v1).getLong();
            int ypos = (int)NumericValue.asNumber(params.get(1 + offset).evalValue(c)).getLong();
            int zpos = (int)NumericValue.asNumber(params.get(2 + offset).evalValue(c)).getLong();
            return new BlockArgument(new BlockValue(null, c.s.method_9225(), new class_2338(c.origin.method_10263() + xpos, c.origin.method_10264() + ypos, c.origin.method_10260() + zpos)), 3 + offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw BlockArgument.handleError(optional, acceptString);
        }
    }

    public static BlockArgument findInValues(CarpetContext c, List<Value> params, int offset, boolean acceptString, boolean optional) {
        try {
            Value v1 = params.get(0 + offset);
            if (optional && v1 instanceof NullValue) {
                return new BlockArgument(null, 1 + offset);
            }
            if (acceptString && v1 instanceof StringValue) {
                return new BlockArgument(BlockValue.fromString(v1.getString()), 1 + offset);
            }
            if (v1 instanceof BlockValue) {
                return new BlockArgument((BlockValue)v1, 1 + offset);
            }
            if (v1 instanceof ListValue) {
                List<Value> args = ((ListValue)v1).getItems();
                int xpos = (int)NumericValue.asNumber(args.get(0)).getLong();
                int ypos = (int)NumericValue.asNumber(args.get(1)).getLong();
                int zpos = (int)NumericValue.asNumber(args.get(2)).getLong();
                return new BlockArgument(new BlockValue(null, c.s.method_9225(), new class_2338(c.origin.method_10263() + xpos, c.origin.method_10264() + ypos, c.origin.method_10260() + zpos)), 1 + offset);
            }
            int xpos = (int)NumericValue.asNumber(v1).getLong();
            int ypos = (int)NumericValue.asNumber(params.get(1 + offset)).getLong();
            int zpos = (int)NumericValue.asNumber(params.get(2 + offset)).getLong();
            return new BlockArgument(new BlockValue(null, c.s.method_9225(), new class_2338(c.origin.method_10263() + xpos, c.origin.method_10264() + ypos, c.origin.method_10260() + zpos)), 3 + offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw BlockArgument.handleError(optional, acceptString);
        }
    }

    private static InternalExpressionException handleError(boolean optional, boolean acceptString) {
        String message = "Block-type argument should be defined either by three coordinates (a triple or by three arguments), or a block value";
        if (acceptString) {
            message = message + ", or a string with block description";
        }
        if (optional) {
            message = message + ", or null";
        }
        return new InternalExpressionException(message);
    }
}

