/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.argument;

import carpet.script.Context;
import carpet.script.LazyValue;
import carpet.script.ScriptHost;
import carpet.script.argument.Argument;
import carpet.script.bundled.Module;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FunctionArgument<T>
extends Argument {
    public FunctionValue function;
    public List<T> args;

    private FunctionArgument(FunctionValue function, int offset, List<T> args) {
        super(offset);
        this.function = function;
        this.args = args;
    }

    public static FunctionArgument<LazyValue> findIn(Context c, Module module, List<LazyValue> params, int offset, boolean allowNone, boolean checkArgs) {
        Value functionValue = params.get(offset).evalValue(c);
        if (functionValue.isNull()) {
            if (allowNone) {
                return new FunctionArgument<LazyValue>(null, offset + 1, Collections.emptyList());
            }
            throw new InternalExpressionException("function argument cannot be null");
        }
        if (!(functionValue instanceof FunctionValue)) {
            String name = functionValue.getString();
            functionValue = c.host.getAssertFunction(module, name);
        }
        FunctionValue fun = (FunctionValue)functionValue;
        int argsize = fun.getArguments().size();
        if (checkArgs) {
            int extraargs = params.size() - argsize - offset - 1;
            if (extraargs < 0) {
                throw new InternalExpressionException("Function " + fun.getPrettyString() + " requires at least " + fun.getArguments().size() + " arguments");
            }
            if (extraargs > 0 && fun.getVarArgs() == null) {
                throw new InternalExpressionException("Function " + fun.getPrettyString() + " requires " + fun.getArguments().size() + " arguments");
            }
        }
        ArrayList<LazyValue> lvargs = new ArrayList<LazyValue>();
        int mx = params.size();
        for (int i = offset + 1; i < mx; ++i) {
            lvargs.add(params.get(i));
        }
        return new FunctionArgument<LazyValue>(fun, offset + 1 + argsize, lvargs);
    }

    public static FunctionArgument<Value> fromCommandSpec(ScriptHost host, Value funSpec) {
        FunctionValue function;
        List<Value> params;
        List<Object> args = Collections.emptyList();
        if (!(funSpec instanceof ListValue)) {
            funSpec = ListValue.of(funSpec);
        }
        if ((params = ((ListValue)funSpec).getItems()).isEmpty()) {
            throw new InternalExpressionException("Function has empty spec");
        }
        Value first = params.get(0);
        if (first instanceof FunctionValue) {
            function = (FunctionValue)first;
        } else {
            String name = first.getString();
            function = host.getAssertFunction(host.main, name);
        }
        if (params.size() > 1) {
            args = params.subList(1, params.size());
        }
        return new FunctionArgument<Value>(function, 0, args);
    }
}

