/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.CarpetServer;
import carpet.script.CarpetContext;
import carpet.script.CarpetScriptHost;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.settings.ParsedRule;
import carpet.settings.SettingsManager;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_5218;

public class SystemInfo {
    private static final Map<String, Function<CarpetContext, Value>> options = new HashMap<String, Function<CarpetContext, Value>>(){
        {
            this.put("app_name", c -> {
                String name = c.host.getName();
                return name == null ? Value.NULL : new StringValue(name);
            });
            this.put("app_list", c -> ListValue.wrap(((CarpetScriptHost)c.host).getScriptServer().modules.keySet().stream().filter(Objects::nonNull).map(StringValue::new).collect(Collectors.toList())));
            this.put("app_scope", c -> StringValue.of(c.host.isPerUser() ? "player" : "global"));
            this.put("app_players", c -> ListValue.wrap(c.host.getUserList().stream().map(StringValue::new).collect(Collectors.toList())));
            this.put("world_name", c -> new StringValue(c.s.method_9211().method_27728().method_150()));
            this.put("world_seed", c -> new NumericValue(c.s.method_9225().method_8412()));
            this.put("server_motd", c -> StringValue.of(c.s.method_9211().method_3818()));
            this.put("world_path", c -> StringValue.of(c.s.method_9211().method_27050(class_5218.field_24188).toString()));
            this.put("world_folder", c -> {
                Path serverPath = c.s.method_9211().method_27050(class_5218.field_24188);
                int nodeCount = serverPath.getNameCount();
                if (nodeCount < 2) {
                    return Value.NULL;
                }
                String tlf = serverPath.getName(nodeCount - 2).toString();
                return StringValue.of(tlf);
            });
            this.put("game_difficulty", c -> StringValue.of(c.s.method_9211().method_27728().method_207().method_5460()));
            this.put("game_hardcore", c -> new NumericValue(c.s.method_9211().method_27728().method_152()));
            this.put("game_storage_format", c -> StringValue.of(c.s.method_9211().method_27728().method_27440(c.s.method_9211().method_27728().method_168())));
            this.put("game_default_gamemode", c -> StringValue.of(c.s.method_9211().method_3790().method_8381()));
            this.put("game_max_players", c -> new NumericValue(c.s.method_9211().method_3802()));
            this.put("game_view_distance", c -> new NumericValue(c.s.method_9211().method_3760().method_14568()));
            this.put("game_mod_name", c -> StringValue.of(c.s.method_9211().getServerModName()));
            this.put("game_version", c -> StringValue.of(c.s.method_9211().method_3827()));
            this.put("server_ip", c -> StringValue.of(c.s.method_9211().method_3819()));
            this.put("server_whitelisted", c -> new NumericValue(c.s.method_9211().method_3729()));
            this.put("server_whitelist", c -> {
                MapValue whitelist = new MapValue(Collections.emptyList());
                for (String s : c.s.method_9211().method_3760().method_14560()) {
                    whitelist.append(StringValue.of(s));
                }
                return whitelist;
            });
            this.put("server_banned_players", c -> {
                MapValue whitelist = new MapValue(Collections.emptyList());
                for (String s : c.s.method_9211().method_3760().method_14563().method_14636()) {
                    whitelist.append(StringValue.of(s));
                }
                return whitelist;
            });
            this.put("server_banned_ips", c -> {
                MapValue whitelist = new MapValue(Collections.emptyList());
                for (String s : c.s.method_9211().method_3760().method_14585().method_14636()) {
                    whitelist.append(StringValue.of(s));
                }
                return whitelist;
            });
            this.put("java_max_memory", c -> new NumericValue(Runtime.getRuntime().maxMemory()));
            this.put("java_allocated_memory", c -> new NumericValue(Runtime.getRuntime().totalMemory()));
            this.put("java_used_memory", c -> new NumericValue(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
            this.put("java_cpu_count", c -> new NumericValue(Runtime.getRuntime().availableProcessors()));
            this.put("java_version", c -> StringValue.of(System.getProperty("java.version")));
            this.put("java_bits", c -> {
                for (String property : new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
                    String value = System.getProperty(property);
                    if (value == null || !value.contains("64")) continue;
                    return new NumericValue(64L);
                }
                return new NumericValue(32L);
            });
            this.put("java_system_cpu_load", c -> {
                OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
                return new NumericValue(osBean.getSystemCpuLoad());
            });
            this.put("java_process_cpu_load", c -> {
                OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
                return new NumericValue(osBean.getProcessCpuLoad());
            });
            this.put("world_carpet_rules", c -> {
                Collection<ParsedRule<?>> rules = CarpetServer.settingsManager.getRules();
                MapValue carpetRules = new MapValue(Collections.emptyList());
                rules.forEach((? super T rule) -> carpetRules.put(new StringValue(rule.name), new StringValue(rule.getAsString())));
                CarpetServer.extensions.forEach((? super T e) -> {
                    SettingsManager manager = e.customSettingsManager();
                    if (manager == null) {
                        return;
                    }
                    Collection<ParsedRule<?>> extensionRules = manager.getRules();
                    extensionRules.forEach((? super T rule) -> carpetRules.put(new StringValue(manager.getIdentifier() + ":" + rule.name), new StringValue(rule.getAsString())));
                });
                return carpetRules;
            });
        }
    };

    public static Value get(String what, CarpetContext cc) {
        return options.getOrDefault(what, c -> null).apply(cc);
    }

    public static Value getAll(CarpetContext cc) {
        return MapValue.wrap(options.entrySet().stream().collect(Collectors.toMap(e -> new StringValue((String)e.getKey()), e -> (Value)((Function)e.getValue()).apply(cc))));
    }
}

