/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.exception.InternalExpressionException;
import carpet.script.value.ListValue;
import carpet.script.value.NullValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Locale;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import org.apache.commons.lang3.StringUtils;

public class NumericValue
extends Value {
    private final Double value;
    private Long longValue;
    private static final double epsilon = Math.abs(2.842170943040401E-14);
    private static final MathContext displayRounding = new MathContext(12, RoundingMode.HALF_EVEN);

    public static NumericValue asNumber(Value v1, String id) {
        if (!(v1 instanceof NumericValue)) {
            throw new InternalExpressionException("Argument " + id + " has to be of a numeric type");
        }
        return (NumericValue)v1;
    }

    public static NumericValue asNumber(Value v1) {
        if (!(v1 instanceof NumericValue)) {
            throw new InternalExpressionException("Operand has to be of a numeric type");
        }
        return (NumericValue)v1;
    }

    public static <T extends Number> Value of(T value) {
        if (value == null) {
            return Value.NULL;
        }
        if (value.doubleValue() == (double)value.longValue()) {
            return new NumericValue(value.longValue());
        }
        if (value instanceof Float) {
            return new NumericValue(1.0E-6 * (double)Math.round(1000000.0 * value.doubleValue()));
        }
        return new NumericValue(value.doubleValue());
    }

    @Override
    public String getString() {
        if (this.longValue != null) {
            return Long.toString(this.getLong());
        }
        try {
            if (this.value.isInfinite()) {
                return "INFINITY";
            }
            if (this.value.isNaN()) {
                return "NaN";
            }
            return BigDecimal.valueOf(this.value).round(displayRounding).stripTrailingZeros().toPlainString();
        }
        catch (NumberFormatException exc) {
            throw new InternalExpressionException("Incorrect number format for " + this.value);
        }
    }

    @Override
    public String getPrettyString() {
        if (this.longValue != null || this.getDouble() == (double)this.getLong()) {
            return Long.toString(this.getLong());
        }
        return String.format(Locale.ROOT, "%.1f..", this.getDouble());
    }

    @Override
    public boolean getBoolean() {
        return Math.abs(this.value) > epsilon;
    }

    public double getDouble() {
        return this.value;
    }

    public float getFloat() {
        return this.value.floatValue();
    }

    private static long floor(double double_1) {
        long int_1 = (long)double_1;
        return double_1 < (double)int_1 ? int_1 - 1L : int_1;
    }

    public long getLong() {
        if (this.longValue != null) {
            return this.longValue;
        }
        return NumericValue.floor(this.value + epsilon);
    }

    @Override
    public Value add(Value v) {
        if (v instanceof NumericValue) {
            NumericValue nv = (NumericValue)v;
            if (this.longValue != null && nv.longValue != null) {
                return new NumericValue(this.longValue + nv.longValue);
            }
            return new NumericValue(this.value + nv.value);
        }
        return super.add(v);
    }

    @Override
    public Value subtract(Value v) {
        if (v instanceof NumericValue) {
            NumericValue nv = (NumericValue)v;
            if (this.longValue != null && nv.longValue != null) {
                return new NumericValue(this.longValue - nv.longValue);
            }
            return new NumericValue(this.value - nv.value);
        }
        return super.subtract(v);
    }

    @Override
    public Value multiply(Value v) {
        if (v instanceof NumericValue) {
            NumericValue nv = (NumericValue)v;
            if (this.longValue != null && nv.longValue != null) {
                return new NumericValue(this.longValue * nv.longValue);
            }
            return new NumericValue(this.value * nv.value);
        }
        if (v instanceof ListValue) {
            return v.multiply(this);
        }
        return new StringValue(StringUtils.repeat((String)v.getString(), (int)((int)this.getLong())));
    }

    @Override
    public Value divide(Value v) {
        if (v instanceof NumericValue) {
            return new NumericValue(this.getDouble() / ((NumericValue)v).getDouble());
        }
        return super.divide(v);
    }

    public Value clone() {
        return new NumericValue(this.value, this.longValue);
    }

    @Override
    public int compareTo(Value o) {
        if (o instanceof NullValue) {
            return -o.compareTo(this);
        }
        if (o instanceof NumericValue) {
            NumericValue no = (NumericValue)o;
            if (this.longValue != null && no.longValue != null) {
                return this.longValue.compareTo(no.longValue);
            }
            return this.value.compareTo(no.value);
        }
        return this.getString().compareTo(o.getString());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof NullValue) {
            return o.equals(this);
        }
        if (o instanceof NumericValue) {
            NumericValue no = (NumericValue)o;
            if (this.longValue != null && no.longValue != null) {
                return this.longValue.equals(no.longValue);
            }
            return !this.subtract(no).getBoolean();
        }
        return super.equals(o);
    }

    public NumericValue(double value) {
        this.value = value;
    }

    private NumericValue(double value, Long longValue) {
        this.value = value;
        this.longValue = longValue;
    }

    public NumericValue(String value) {
        BigDecimal decimal = new BigDecimal(value);
        if (decimal.stripTrailingZeros().scale() <= 0) {
            try {
                this.longValue = decimal.longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        this.value = decimal.doubleValue();
    }

    public NumericValue(long value) {
        this.longValue = value;
        this.value = value;
    }

    public NumericValue(boolean boolval) {
        this(boolval ? 1L : 0L);
    }

    @Override
    public int length() {
        return Long.toString(this.getLong()).length();
    }

    @Override
    public double readDoubleNumber() {
        return this.value;
    }

    @Override
    public long readInteger() {
        return this.getLong();
    }

    @Override
    public String getTypeString() {
        return "number";
    }

    @Override
    public int hashCode() {
        if (this.longValue != null || Math.abs(Math.floor(this.value + 0.5) - this.value) < epsilon) {
            return Long.hashCode(this.getLong());
        }
        return Double.hashCode(this.value);
    }

    public int getInt() {
        return (int)this.getLong();
    }

    @Override
    public class_2520 toTag(boolean force) {
        if (this.longValue != null) {
            return class_2503.method_23251((long)this.longValue);
        }
        long lv = this.getLong();
        if (this.value == (double)lv) {
            if (Math.abs(this.value) < 2.147483645E9) {
                return class_2497.method_23247((int)((int)lv));
            }
            return class_2503.method_23251((long)this.getLong());
        }
        return class_2489.method_23241((double)this.value);
    }

    @Override
    public JsonElement toJson() {
        if (this.longValue != null) {
            return new JsonPrimitive((Number)this.longValue);
        }
        long lv = this.getLong();
        if (this.value == (double)lv) {
            return new JsonPrimitive((Number)this.getLong());
        }
        return new JsonPrimitive((Number)this.value);
    }

    public NumericValue opposite() {
        if (this.longValue != null) {
            return new NumericValue(-this.longValue.longValue());
        }
        return new NumericValue(-this.value.doubleValue());
    }
}

