/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Tokenizer;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.FunctionValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.Value;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.class_2520;

public class ThreadValue
extends Value {
    private final CompletableFuture<Value> taskFuture;
    private final long id = sequence++;
    private static long sequence = 0L;

    public ThreadValue(Value pool, FunctionValue function, Expression expr, Tokenizer.Token token, Context ctx, List<Value> args) {
        ThreadPoolExecutor executor = ctx.host.getExecutor(pool);
        this.taskFuture = executor == null ? CompletableFuture.completedFuture(Value.NULL) : CompletableFuture.supplyAsync(() -> {
            try {
                return function.lazyEval(ctx, 0, expr, token, FunctionValue.lazify(args)).evalValue(ctx);
            }
            catch (ExitStatement exit) {
                return exit.retval;
            }
            catch (ExpressionException exc) {
                ctx.host.handleExpressionException("Thread failed", exc);
                return Value.NULL;
            }
        }, ctx.host.getExecutor(pool));
        Thread.yield();
    }

    @Override
    public String getString() {
        return this.taskFuture.getNow(Value.NULL).getString();
    }

    public Value getValue() {
        return this.taskFuture.getNow(Value.NULL);
    }

    @Override
    public boolean getBoolean() {
        return this.taskFuture.getNow(Value.NULL).getBoolean();
    }

    public Value join() {
        try {
            return this.taskFuture.get();
        }
        catch (ExitStatement exit) {
            this.taskFuture.complete(exit.retval);
            return exit.retval;
        }
        catch (InterruptedException | ExecutionException e) {
            return Value.NULL;
        }
    }

    public boolean isFinished() {
        return this.taskFuture.isDone();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ThreadValue)) {
            return false;
        }
        return ((ThreadValue)o).id == this.id;
    }

    @Override
    public int compareTo(Value o) {
        if (!(o instanceof ThreadValue)) {
            throw new InternalExpressionException("Cannot compare tasks to other types");
        }
        return (int)(this.id - ((ThreadValue)o).id);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.id);
    }

    @Override
    public class_2520 toTag(boolean force) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        return this.getValue().toTag(true);
    }

    @Override
    public String getTypeString() {
        return "task";
    }
}

