/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_5251;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Messenger {
    public static final Logger LOG = LogManager.getLogger((String)"Messaging System");
    private static final Pattern colorExtract = Pattern.compile("#([0-9a-fA-F]{6})");

    public static class_2583 parseStyle(String style) {
        class_2583 myStyle = class_2583.field_24360.method_10977(class_124.field_1068);
        for (CarpetFormatting cf : CarpetFormatting.values()) {
            myStyle = cf.apply(style, myStyle);
        }
        return myStyle;
    }

    public static String heatmap_color(double actual, double reference) {
        String color = "g";
        if (actual >= 0.0) {
            color = "e";
        }
        if (actual > 0.5 * reference) {
            color = "y";
        }
        if (actual > 0.8 * reference) {
            color = "r";
        }
        if (actual > reference) {
            color = "m";
        }
        return color;
    }

    public static String creatureTypeColor(class_1311 type) {
        switch (type) {
            case field_6302: {
                return "n";
            }
            case field_6294: {
                return "e";
            }
            case field_6303: {
                return "f";
            }
            case field_6300: {
                return "v";
            }
            case field_24460: {
                return "q";
            }
        }
        return "w";
    }

    private static class_2554 _getChatComponentFromDesc(String message, class_2554 previous_message) {
        if (message.equalsIgnoreCase("")) {
            return new class_2585("");
        }
        if (Character.isWhitespace(message.charAt(0))) {
            message = "w" + message;
        }
        int limit = message.indexOf(32);
        String desc = message;
        String str = "";
        if (limit >= 0) {
            desc = message.substring(0, limit);
            str = message.substring(limit + 1);
        }
        if (desc.charAt(0) == '/') {
            if (previous_message != null) {
                previous_message.method_10862(previous_message.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11745, message)));
            }
            return previous_message;
        }
        if (desc.charAt(0) == '?') {
            if (previous_message != null) {
                previous_message.method_10862(previous_message.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11745, message.substring(1))));
            }
            return previous_message;
        }
        if (desc.charAt(0) == '!') {
            if (previous_message != null) {
                previous_message.method_10862(previous_message.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, message.substring(1))));
            }
            return previous_message;
        }
        if (desc.charAt(0) == '^') {
            if (previous_message != null) {
                previous_message.method_10862(previous_message.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Messenger.c(message.substring(1)))));
            }
            return previous_message;
        }
        class_2585 txt = new class_2585(str);
        txt.method_10862(Messenger.parseStyle(desc));
        return txt;
    }

    public static class_2554 tp(String desc, class_243 pos) {
        return Messenger.tp(desc, pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static class_2554 tp(String desc, class_2338 pos) {
        return Messenger.tp(desc, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static class_2554 tp(String desc, double x, double y, double z) {
        return Messenger.tp(desc, (float)x, (float)y, (float)z);
    }

    public static class_2554 tp(String desc, float x, float y, float z) {
        return Messenger._getCoordsTextComponent(desc, x, y, z, false);
    }

    public static class_2554 tp(String desc, int x, int y, int z) {
        return Messenger._getCoordsTextComponent(desc, x, y, z, true);
    }

    public static class_2554 dbl(String style, double double_value) {
        return Messenger.c(String.format("%s %.1f", style, double_value), String.format("^w %f", double_value));
    }

    public static class_2554 dbls(String style, double ... doubles) {
        StringBuilder str = new StringBuilder(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            str.append(String.format("%s%.1f", prefix, dbl));
            prefix = ", ";
        }
        str.append(" ]");
        return Messenger.c(str.toString());
    }

    public static class_2554 dblf(String style, double ... doubles) {
        StringBuilder str = new StringBuilder(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            str.append(String.format("%s%f", prefix, dbl));
            prefix = ", ";
        }
        str.append(" ]");
        return Messenger.c(str.toString());
    }

    public static class_2554 dblt(String style, double ... doubles) {
        ArrayList<String> components = new ArrayList<String>();
        components.add(style + " [ ");
        String prefix = "";
        for (double dbl : doubles) {
            components.add(String.format("%s %s%.1f", style, prefix, dbl));
            components.add("?" + dbl);
            components.add("^w " + dbl);
            prefix = ", ";
        }
        components.add(style + "  ]");
        return Messenger.c(components.toArray(new Object[0]));
    }

    private static class_2554 _getCoordsTextComponent(String style, float x, float y, float z, boolean isInt) {
        String command;
        String text;
        if (isInt) {
            text = String.format("%s [ %d, %d, %d ]", style, (int)x, (int)y, (int)z);
            command = String.format("!/tp %d %d %d", (int)x, (int)y, (int)z);
        } else {
            text = String.format("%s [ %.1f, %.1f, %.1f]", style, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
            command = String.format("!/tp %.3f %.3f %.3f", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        }
        return Messenger.c(text, command);
    }

    public static void m(class_2168 source, Object ... fields) {
        if (source != null) {
            source.method_9226((class_2561)Messenger.c(fields), source.method_9211() != null && source.method_9211().method_3847(class_1937.field_25179) != null);
        }
    }

    public static void m(class_1657 player, Object ... fields) {
        player.method_9203((class_2561)Messenger.c(fields), class_156.field_25140);
    }

    public static class_2554 c(Object ... fields) {
        class_2585 message = new class_2585("");
        class_2554 previous_component = null;
        for (Object o : fields) {
            if (o instanceof class_2554) {
                message.method_10852((class_2561)((class_2554)o));
                previous_component = (class_2554)o;
                continue;
            }
            String txt = o.toString();
            class_2554 comp = Messenger._getChatComponentFromDesc(txt, previous_component);
            if (comp != previous_component) {
                message.method_10852((class_2561)comp);
            }
            previous_component = comp;
        }
        return message;
    }

    public static class_2554 s(String text) {
        return Messenger.s(text, "");
    }

    public static class_2554 s(String text, String style) {
        class_2585 message = new class_2585(text);
        message.method_10862(Messenger.parseStyle(style));
        return message;
    }

    public static void send(class_1657 player, Collection<class_2554> lines) {
        lines.forEach(message -> player.method_9203((class_2561)message, class_156.field_25140));
    }

    public static void send(class_2168 source, Collection<class_2554> lines) {
        lines.stream().forEachOrdered(s -> source.method_9226((class_2561)s, false));
    }

    public static void print_server_message(MinecraftServer server, String message) {
        if (server == null) {
            LOG.error("Message not delivered: " + message);
        }
        server.method_9203((class_2561)new class_2585(message), class_156.field_25140);
        class_2554 txt = Messenger.c("gi " + message);
        for (class_1657 entityplayer : server.method_3760().method_14571()) {
            entityplayer.method_9203((class_2561)txt, class_156.field_25140);
        }
    }

    public static void print_server_message(MinecraftServer server, class_2554 message) {
        if (server == null) {
            LOG.error("Message not delivered: " + message.getString());
        }
        server.method_9203((class_2561)message, class_156.field_25140);
        for (class_1657 entityplayer : server.method_3760().method_14571()) {
            entityplayer.method_9203((class_2561)message, class_156.field_25140);
        }
    }

    public static enum CarpetFormatting {
        ITALIC('i', (s, f) -> s.method_10978(Boolean.valueOf(true))),
        STRIKE('s', (s, f) -> s.method_27706(class_124.field_1055)),
        UNDERLINE('u', (s, f) -> s.method_27706(class_124.field_1073)),
        BOLD('b', (s, f) -> s.method_10982(Boolean.valueOf(true))),
        OBFUSCATE('o', (s, f) -> s.method_27706(class_124.field_1051)),
        WHITE('w', (s, f) -> s.method_10977(class_124.field_1068)),
        YELLOW('y', (s, f) -> s.method_10977(class_124.field_1054)),
        LIGHT_PURPLE('m', (s, f) -> s.method_10977(class_124.field_1076)),
        RED('r', (s, f) -> s.method_10977(class_124.field_1061)),
        AQUA('c', (s, f) -> s.method_10977(class_124.field_1075)),
        GREEN('l', (s, f) -> s.method_10977(class_124.field_1060)),
        BLUE('t', (s, f) -> s.method_10977(class_124.field_1078)),
        DARK_GRAY('f', (s, f) -> s.method_10977(class_124.field_1063)),
        GRAY('g', (s, f) -> s.method_10977(class_124.field_1080)),
        GOLD('d', (s, f) -> s.method_10977(class_124.field_1065)),
        DARK_PURPLE('p', (s, f) -> s.method_10977(class_124.field_1064)),
        DARK_RED('n', (s, f) -> s.method_10977(class_124.field_1079)),
        DARK_AQUA('q', (s, f) -> s.method_10977(class_124.field_1062)),
        DARK_GREEN('e', (s, f) -> s.method_10977(class_124.field_1077)),
        DARK_BLUE('v', (s, f) -> s.method_10977(class_124.field_1058)),
        BLACK('k', (s, f) -> s.method_10977(class_124.field_1074)),
        COLOR('#', (s, f) -> {
            class_5251 color = class_5251.method_27719((String)("#" + f));
            return color == null ? s : s.method_27703(color);
        }, s -> {
            Matcher m = colorExtract.matcher((CharSequence)s);
            return m.find() ? m.group(1) : null;
        });

        public char code;
        public BiFunction<class_2583, String, class_2583> applier;
        public Function<String, String> container;

        private CarpetFormatting(char code, BiFunction<class_2583, String, class_2583> applier) {
            this(code, applier, s -> s.indexOf(code) >= 0 ? Character.toString(code) : null);
        }

        private CarpetFormatting(char code, BiFunction<class_2583, String, class_2583> applier, Function<String, String> container) {
            this.code = code;
            this.applier = applier;
            this.container = container;
        }

        public class_2583 apply(String format, class_2583 previous) {
            String fmt = this.container.apply(format);
            if (fmt != null) {
                return this.applier.apply(previous, fmt);
            }
            return previous;
        }
    }
}

