/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.utils.fabric;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.mojang.bridge.game.GameVersion;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3797;
import org.apache.commons.lang3.ArrayUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FabricUtils {
    public static final FabricLoader LOADER = FabricLoader.getInstance();
    public static final boolean IS_DEVELOPMENT_ENVIRONMENT = LOADER.isDevelopmentEnvironment();
    public static final boolean IS_CLIENT = LOADER.getEnvironmentType() == EnvType.CLIENT;
    public static final Path MC_DIRECTORY = LOADER.getGameDirectory().toPath();
    public static final GameVersion MC_VERSION = class_3797.method_16672();
    public static final String MC_VERSION_STRING = MC_VERSION.getName();
    public static final int MC_MAJOR_VERSION = Integer.parseInt((String)Splitter.on((char)'.').splitToList((CharSequence)MC_VERSION_STRING).get(1));

    private FabricUtils() {
    }

    public static Object toPrimitiveArray(Object[] array) {
        if (array instanceof Boolean[]) {
            return ArrayUtils.toPrimitive((Boolean[])((Boolean[])array));
        }
        if (array instanceof Byte[]) {
            return ArrayUtils.toPrimitive((Byte[])((Byte[])array));
        }
        if (array instanceof Character[]) {
            return ArrayUtils.toPrimitive((Character[])((Character[])array));
        }
        if (array instanceof Double[]) {
            return ArrayUtils.toPrimitive((Double[])((Double[])array));
        }
        if (array instanceof Float[]) {
            return ArrayUtils.toPrimitive((Float[])((Float[])array));
        }
        if (array instanceof Integer[]) {
            return ArrayUtils.toPrimitive((Integer[])((Integer[])array));
        }
        if (array instanceof Long[]) {
            return ArrayUtils.toPrimitive((Long[])((Long[])array));
        }
        if (array instanceof Short[]) {
            return ArrayUtils.toPrimitive((Short[])((Short[])array));
        }
        throw new IllegalArgumentException("array should be a boxed array");
    }

    public static Object[] toBoxedArray(Object array) {
        Preconditions.checkNotNull((Object)array, (Object)"array should not be null");
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof boolean[]) {
            return ArrayUtils.toObject((boolean[])((boolean[])array));
        }
        if (array instanceof byte[]) {
            return ArrayUtils.toObject((byte[])((byte[])array));
        }
        if (array instanceof char[]) {
            return ArrayUtils.toObject((char[])((char[])array));
        }
        if (array instanceof double[]) {
            return ArrayUtils.toObject((double[])((double[])array));
        }
        if (array instanceof float[]) {
            return ArrayUtils.toObject((float[])((float[])array));
        }
        if (array instanceof int[]) {
            return ArrayUtils.toObject((int[])((int[])array));
        }
        if (array instanceof long[]) {
            return ArrayUtils.toObject((long[])((long[])array));
        }
        if (array instanceof short[]) {
            return ArrayUtils.toObject((short[])((short[])array));
        }
        throw new IllegalArgumentException("array should be an array");
    }

    public static Path getPath(String path) {
        return Paths.get(path, new String[0]).normalize();
    }

    public static String withUnixDirectorySeparators(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        return FabricUtils.withUnixDirectorySeparators(path.toString());
    }

    public static String withUnixDirectorySeparators(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        return path.replace('\\', '/');
    }

    public static @Nullable Field findFieldNullable(Class<?> clazz, String ... names) {
        Preconditions.checkNotNull(clazz, (Object)"clazz should not be null");
        Preconditions.checkNotNull((Object)names, (Object)"names should not be null");
        for (Field field : clazz.getDeclaredFields()) {
            for (String name : names) {
                if (!name.equals(field.getName())) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }

    public static Field findField(Class<?> clazz, String ... names) {
        Field field = FabricUtils.findFieldNullable(clazz, names);
        if (field == null) {
            throw new IllegalArgumentException("No such field " + Arrays.toString(names) + " in: " + clazz.getName());
        }
        return field;
    }

    public static @Nullable Method findMethodNullable(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return FabricUtils.findMethodNullable(clazz, name, name, parameterTypes);
    }

    public static @Nullable Method findMethodNullable(Class<?> clazz, String name, String obfuscatedName, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(clazz, (Object)"clazz should not be null");
        Preconditions.checkNotNull((Object)name, (Object)"name should not be null");
        Preconditions.checkNotNull((Object)obfuscatedName, (Object)"obfuscatedName should not be null");
        Preconditions.checkNotNull(parameterTypes, (Object)"parameterTypes should not be null");
        for (Method method : clazz.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!name.equals(methodName) && !obfuscatedName.equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static @Nullable Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Method method = FabricUtils.findMethodNullable(clazz, name, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("No such method " + name + " in: " + clazz.getName());
        }
        return method;
    }

    public static @Nullable Method findMethod(Class<?> clazz, String name, String obfuscatedName, Class<?> ... parameterTypes) {
        Method method = FabricUtils.findMethodNullable(clazz, name, obfuscatedName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("No such method " + name + " in: " + clazz.getName());
        }
        return method;
    }

    public static @Nullable Class<?> getClass(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name should not be null");
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static boolean isDedicatedServer(class_2172 source) {
        return source instanceof class_2168 && ((class_2168)source).method_9211().method_3816();
    }

    public static void crashReport(String message, Throwable throwable) {
        Preconditions.checkNotNull((Object)message, (Object)"message should not be null");
        Preconditions.checkNotNull((Object)throwable, (Object)"throwable should not be null");
        throw new class_148(new class_128(message, throwable));
    }
}

