/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.utils.fabric.config;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.therandomlabs.utils.config.ConfigManager;
import com.therandomlabs.utils.fabric.FabricUtils;
import io.github.cottonmc.clientcommands.CottonClientCommandSource;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ConfigReloadCommand {
    private final String name;
    private final String clientName;
    private final Class<?> configClass;
    private @Nullable Consumer<? super class_2172> preReload;
    private @Nullable Consumer<? super class_2172> postReload;
    private @Nullable String serverSuccessMessage;

    public ConfigReloadCommand(String name, String clientName, Class<?> configClass) {
        Preconditions.checkNotNull((Object)name, (Object)"name should not be null");
        Preconditions.checkNotNull((Object)clientName, (Object)"clientName should not be null");
        Preconditions.checkNotNull(configClass, (Object)"configClass should not be null");
        this.name = name;
        this.clientName = clientName;
        this.configClass = configClass;
    }

    public ConfigReloadCommand preReload(Consumer<? super class_2172> preReload) {
        Preconditions.checkNotNull(preReload, (Object)"preReload should not be null");
        if (this.preReload != null) {
            throw new IllegalStateException("preReload has already been set");
        }
        this.preReload = preReload;
        return this;
    }

    public ConfigReloadCommand postReload(Consumer<? super class_2172> postReload) {
        Preconditions.checkNotNull(postReload, (Object)"postReload should not be null");
        if (this.preReload != null) {
            throw new IllegalStateException("postReload has already been set");
        }
        this.postReload = postReload;
        return this;
    }

    public ConfigReloadCommand serverSuccessMessage(String message) {
        Preconditions.checkNotNull((Object)message, (Object)"message should not be null");
        if (this.serverSuccessMessage != null) {
            throw new IllegalStateException("serverSuccessMessage has already been set");
        }
        this.serverSuccessMessage = message;
        return this;
    }

    public void registerClient(CommandDispatcher<? extends class_2172> dispatcher) {
        Preconditions.checkNotNull(dispatcher, (Object)"dispatcher should not be null");
        this.register(dispatcher, this.clientName, 0);
    }

    public void registerServer(CommandDispatcher<? extends class_2172> dispatcher) {
        Preconditions.checkNotNull(dispatcher, (Object)"dispatcher should not be null");
        this.register(dispatcher, this.name, 4);
    }

    private void register(CommandDispatcher<? extends class_2172> dispatcher, String name, int permissionLevel) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)name).requires(source -> source.method_9259(permissionLevel))).executes(this::execute));
    }

    private int execute(CommandContext<class_2172> context) {
        class_2172 source = (class_2172)context.getSource();
        if (this.preReload != null) {
            this.preReload.accept((class_2172)source);
        }
        ConfigManager.reloadFromDisk(this.configClass);
        if (this.postReload != null) {
            this.postReload.accept((class_2172)source);
        }
        boolean dedicatedServer = FabricUtils.isDedicatedServer(source);
        if (this.serverSuccessMessage != null && dedicatedServer) {
            ((class_2168)source).method_9226((class_2561)new class_2585(this.serverSuccessMessage), true);
        } else {
            String currentName = dedicatedServer ? this.name : this.clientName;
            class_2588 text = new class_2588("commands." + currentName + ".success");
            if (source instanceof class_2168) {
                ((class_2168)source).method_9226((class_2561)text, true);
            } else {
                ((CottonClientCommandSource)source).sendFeedback((class_2561)text);
            }
        }
        return 1;
    }
}

