/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.utils.fabric.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.therandomlabs.utils.config.TypeAdapter;
import com.therandomlabs.utils.config.TypeAdapters;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;

final class IdentifierTypeAdapter
implements TypeAdapter {
    private static final Map<Class<?>, class_2385<?>> registries = new HashMap();
    private final Class<?> registryEntryClass;
    private final class_2378<Object> registry;
    private final boolean isArray;

    IdentifierTypeAdapter(Class<?> registryEntryClass, boolean isArray) {
        this.registryEntryClass = registryEntryClass;
        this.registry = (class_2378)registries.get(registryEntryClass);
        this.isArray = isArray;
    }

    public Object getValue(CommentedFileConfig config, String name, Object defaultValue) {
        if (this.isArray) {
            return this.getArrayValue(config, name);
        }
        String identifierString = (String)config.get(name);
        if (identifierString.isEmpty()) {
            return defaultValue;
        }
        class_2960 identifier = new class_2960(identifierString.replaceAll("\\s", ""));
        Object value = this.registry.method_10223(identifier);
        return value == null ? defaultValue : value;
    }

    public void setValue(CommentedFileConfig config, String name, Object value) {
        if (this.isArray) {
            config.set(name, Arrays.stream((Object[])value).map(this::asString).collect(Collectors.toList()));
        } else {
            config.set(name, (Object)this.asString(value));
        }
    }

    public String asString(Object value) {
        return value == null ? "" : this.registry.method_10221(value).toString();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean canBeNull() {
        return true;
    }

    private Object getArrayValue(CommentedFileConfig config, String name) {
        List list = (List)config.get(name);
        ArrayList<Object> values = new ArrayList<Object>(list.size());
        for (String element : list) {
            Object object = this.registry.method_10223(new class_2960(element.replaceAll("\\s", "")));
            if (object == null) continue;
            values.add(object);
        }
        return values.toArray((Object[])Array.newInstance(this.registryEntryClass, 0));
    }

    static void initialize() {
        TypeAdapters.registerAutoRegistrar(IdentifierTypeAdapter::registerIfRegistryEntry);
    }

    private static void reloadRegistries() {
        registries.clear();
        for (class_2378 registry : class_2378.field_11144) {
            Optional identifier = registry.method_10235().stream().findAny();
            if (!identifier.isPresent()) continue;
            Class<?> clazz = registry.method_10223((class_2960)identifier.get()).getClass();
            if (clazz.getSuperclass() != Object.class) {
                clazz = clazz.getSuperclass();
            }
            registries.put(clazz, (class_2385)registry);
        }
    }

    private static void registerIfRegistryEntry(Class<?> clazz) {
        if (registries.containsKey(clazz)) {
            IdentifierTypeAdapter.register(clazz);
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            if (registries.containsKey(clazz)) {
                IdentifierTypeAdapter.register(componentType);
            }
        }
    }

    private static void register(Class<?> clazz) {
        TypeAdapters.register(clazz, (TypeAdapter)new IdentifierTypeAdapter(clazz, false));
        TypeAdapters.register(Array.newInstance(clazz, 0).getClass(), (TypeAdapter)new IdentifierTypeAdapter(clazz, true));
    }

    static {
        IdentifierTypeAdapter.reloadRegistries();
    }
}

