/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.therandomlabs.utils.config.Config;
import com.therandomlabs.vanilladeathchest.ShulkerBoxColor;
import com.therandomlabs.vanilladeathchest.util.DeathChestPlacer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2522;

@Config(id="vanilladeathchest", comment={"VanillaDeathChest configuration"})
public final class VDCConfig {
    @Config.Category(value={"Options related to death chest defense."})
    public static final Defense defense = null;
    @Config.Category(value={"Options that don't fit into any other categories."})
    public static final Misc misc = null;
    @Config.Category(value={"Options related to death chest protection."})
    public static final Protection protection = null;
    @Config.Category(value={"Options related to death chest spawning."})
    public static final Spawning spawning = null;

    public static final class Spawning {
        @Config.Property(value={"The message sent to a player a death chest is placed after they die.", "%s refers to the X, Y and Z coordinates.", "Set this to an empty string to disable the message."})
        public static String chatMessage = "Death chest spawned at [%s, %s, %s]";
        @Config.Property(value={"The display name of the death chest container.", "Leave this empty to not specify a custom name."})
        public static String containerDisplayName = "Death Chest";
        @Config.Property(value={"The type of death chest that should be placed."})
        public static DeathChestPlacer.DeathChestType chestType = DeathChestPlacer.DeathChestType.SINGLE_OR_DOUBLE;
        @Config.Property(value={"Whether to force place a death chest at the location of a player's death if no viable locations are found."})
        public static boolean forcePlaceIfLocationNotFound = true;
        @Config.RangeInt(min=1)
        @Config.Property(value={"The death chest location search radius."})
        public static int locationSearchRadius = 8;
        @Config.Property(value={"Whether death chests can only spawn on solid blocks."})
        public static boolean mustBeOnSolidBlocks;
        @Config.Property(value={"A regular expression that matches the registry names of items that can be placed in death chests."})
        public static String registryNameRegex;
        @Config.Property(value={"Whether death chests should only be spawned if the container can be found in the player's inventory.", "If this is enabled, the container is consumed if it is found."})
        public static boolean useContainerInInventory;
        @Config.Property(value={"The color of the shulker box if chestType is set to SHULKER_BOX or DOUBLE_SHULKER_BOX."})
        public static ShulkerBoxColor shulkerBoxColor;

        static {
            registryNameRegex = ".+";
            shulkerBoxColor = ShulkerBoxColor.WHITE;
        }
    }

    public static final class Protection {
        @Config.Property(value={"Whether players in creative mode should be able to bypass death chest protection."})
        public static boolean bypassIfCreative = true;
        @Config.RangeInt(min=0)
        @Config.Property(value={"The required permission level to bypass death chest protection."})
        public static int bypassPermissionLevel = 3;
        @Config.Property(value={"Whether death chests should be protected.", "When this is enabled, death chests can only be broken by their owners."})
        public static boolean enabled = true;
        @Config.RangeInt(min=0)
        @Config.Property(value={"The amount of time in ticks death chest protection should last.", "120000 ticks is 5 in-game days.", "Set this to 0 to protect death chests indefinitely."})
        public static int period = 120000;
    }

    public static final class Misc {
        @Config.Property(value={"Whether death chests should disappear when they are emptied."})
        public static boolean deathChestsDisappearWhenEmptied = true;
        @Config.Property(value={"Whether death chests should be dropped when broken.", "Enable this for infinite chests."})
        public static boolean dropDeathChests;
        @Config.Property(value={"The name of the disableDeathChests gamerule.", "Set this to an empty string to disable the gamerule."})
        public static String gameRuleName;
        @Config.RequiresReload
        @Config.Property(value={"Whether to enable the /vdcreload command."})
        public static boolean vdcreload;

        static {
            gameRuleName = "disableDeathChests";
            vdcreload = true;
        }
    }

    public static final class Defense {
        @Config.Property(value={"Whether the unlocker should be damaged rather than consumed."})
        public static boolean damageUnlockerInsteadOfConsume;
        @Config.Property(value={"Whether defense entities drop experience."})
        public static boolean defenseEntityDropsExperience;
        @Config.Property(value={"Whether defense entities drop items."})
        public static boolean defenseEntityDropsItems;
        @Config.RangeDouble(min=0.0)
        @Config.Property(value={"The maximum distance squared that a defense entity can be from its chest."})
        public static double defenseEntityMaxDistanceSquared;
        @Config.RangeDouble(min=0.0)
        @Config.Property(value={"The maximum distance squared that a defense entity can be from its player if it is too far away from its chest."})
        public static double defenseEntityMaxDistanceSquaredFromPlayer;
        @Config.Property(value={"The defense entity NBT data."})
        public static String defenseEntityNBT;
        @Config.Property(value={"The registry name of the defense entity.", "If the defense entity is a living entity, it will not automatically despawn.", "If the defense entity can have a revenge target, then the revenge target will be set to the player that died."})
        public static class_1299<? extends class_1297> defenseEntityRegistryName;
        @Config.RangeInt(min=1)
        @Config.Property(value={"The number of defense entities to spawn."})
        public static int defenseEntitySpawnCount;
        @Config.Blacklist(value={"minecraft:air"})
        @Config.Property(value={"The registry name of the unlocker."})
        public static class_1792 unlocker;
        @Config.RangeInt(min=0, max=32767)
        @Config.Property(value={"How many times the unlocker should be consumed or damaged.", "If the unlocker cannot be consumed or damage this many times, the death chest will not be unlocked.", "Note that only the stack that the player is holding will be consumed, and that players in creative mode will not have their unlocker item consumed."})
        public static int unlockerConsumeAmount;
        @Config.RangeInt(min=0, max=32767)
        @Config.Property(value={"The meta value of the unlocker."})
        public static int unlockerMeta;
        @Config.Property(value={"The message that is sent to the player when they fail to unlock a death chest.", "This string takes the required amount and display name of the item as arguments."})
        public static String unlockFailedMessage;
        @Config.Property(value={"Whether the unlock failed message should be a status message rather than a chat message."})
        public static boolean unlockFailedStatusMessage;

        public static void onReload() {
            try {
                class_2522.method_10718((String)defenseEntityNBT);
            }
            catch (CommandSyntaxException ignored) {
                defenseEntityNBT = "{}";
            }
        }

        static {
            defenseEntityMaxDistanceSquared = 64.0;
            defenseEntityMaxDistanceSquaredFromPlayer = 64.0;
            defenseEntityNBT = "{}";
            defenseEntitySpawnCount = 3;
            unlockerConsumeAmount = 1;
            unlockerMeta = Short.MAX_VALUE;
            unlockFailedMessage = "You need %s of the following item to retrieve your items: %s";
            unlockFailedStatusMessage = true;
        }
    }
}

