/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.api.deathchest;

import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChest;
import com.therandomlabs.vanilladeathchest.api.event.deathchest.DeathChestRemoveCallback;
import com.therandomlabs.vanilladeathchest.world.storage.VDCSavedData;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2480;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DeathChestManager {
    private DeathChestManager() {
    }

    public static void addDeathChest(class_3218 world, class_1657 player, class_2338 pos, boolean isDoubleChest) {
        VDCSavedData data = VDCSavedData.get(world);
        Map<class_2338, DeathChest> deathChests = data.getDeathChests();
        DeathChest deathChest = new DeathChest(world, player.method_5667(), world.method_8510(), pos, isDoubleChest, false);
        deathChests.put(pos, deathChest);
        if (isDoubleChest) {
            deathChests.put(pos.method_10078(), deathChest);
        }
        data.method_80();
    }

    public static boolean isDeathChest(class_3218 world, class_2338 pos) {
        return DeathChestManager.getDeathChest(world, pos) != null;
    }

    public static boolean isLocked(class_3218 world, class_2338 pos) {
        DeathChest deathChest = DeathChestManager.getDeathChest(world, pos);
        return deathChest != null && !deathChest.isUnlocked();
    }

    public static @Nullable DeathChest getDeathChest(class_3218 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        if (block != class_2246.field_10034 && !(block instanceof class_2480)) {
            return null;
        }
        Map<class_2338, DeathChest> deathChests = VDCSavedData.get(world).getDeathChests();
        return deathChests.get(pos);
    }

    public static @Nullable DeathChest removeDeathChest(class_3218 world, class_2338 pos) {
        class_2338 east;
        class_2338 west;
        Map<class_2338, DeathChest> deathChests = VDCSavedData.get(world).getDeathChests();
        DeathChest chest = deathChests.remove(pos);
        if (chest == null) {
            return null;
        }
        if (chest.isDoubleChest()) {
            if (chest.getPos().equals((Object)pos)) {
                west = pos;
                east = pos.method_10078();
            } else {
                west = pos.method_10067();
                east = pos;
            }
        } else {
            west = pos;
            east = null;
        }
        ((DeathChestRemoveCallback)DeathChestRemoveCallback.EVENT.invoker()).onRemove(chest, west, east);
        return chest;
    }
}

