/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.handler;

import com.therandomlabs.vanilladeathchest.VDCConfig;
import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChest;
import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChestManager;
import com.therandomlabs.vanilladeathchest.api.event.block.BreakBlockCallback;
import com.therandomlabs.vanilladeathchest.api.event.block.ExplosionDetonationCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DeathChestInteractionHandler
implements BreakBlockCallback,
UseBlockCallback,
ExplosionDetonationCallback {
    private static @Nullable class_2338 harvesting;

    @Override
    public boolean breakBlock(class_3218 world, class_3222 player, class_2338 pos) {
        if (pos.equals((Object)harvesting)) {
            return true;
        }
        DeathChest deathChest = DeathChestManager.getDeathChest(world, pos);
        if (deathChest == null) {
            return true;
        }
        if (!DeathChestInteractionHandler.canInteract(player, deathChest)) {
            return false;
        }
        DeathChest chest = DeathChestManager.removeDeathChest(world, pos);
        if (chest.isDoubleChest()) {
            harvesting = chest.getPos().equals((Object)pos) ? pos.method_10078() : pos.method_10067();
            player.field_13974.method_14266(harvesting);
        }
        return true;
    }

    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_3965 result) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        DeathChest deathChest = DeathChestManager.getDeathChest((class_3218)world, result.method_17777());
        if (deathChest == null) {
            return class_1269.field_5811;
        }
        return DeathChestInteractionHandler.canInteract((class_3222)player, deathChest) ? class_1269.field_5811 : class_1269.field_5812;
    }

    @Override
    public void onExplosionDetonate(class_3218 world, class_1927 explosion) {
        explosion.method_8346().removeIf(pos -> DeathChestManager.isLocked(world, pos));
    }

    private static boolean canInteract(class_3222 player, DeathChest deathChest) {
        String message;
        if (!deathChest.canInteract((class_1657)player)) {
            return false;
        }
        if (VDCConfig.Defense.unlocker == null || deathChest.isUnlocked()) {
            return true;
        }
        class_1799 stack = player.method_5998(player.method_6058());
        int amount = VDCConfig.Defense.unlockerConsumeAmount;
        if (stack.method_7909() == VDCConfig.Defense.unlocker) {
            if (amount == 0) {
                deathChest.setUnlocked(true);
                return true;
            }
            if (VDCConfig.Defense.damageUnlockerInsteadOfConsume) {
                boolean unlocked = player.field_7503.field_7477;
                if (!unlocked && stack.method_7963() && stack.method_7919() + amount < stack.method_7919()) {
                    stack.method_7970(amount, player.method_6051(), player);
                    unlocked = true;
                }
                if (unlocked) {
                    deathChest.setUnlocked(true);
                    return true;
                }
            } else if (stack.method_7947() >= amount) {
                if (!player.field_7503.field_7477) {
                    stack.method_7934(amount);
                }
                deathChest.setUnlocked(true);
                return true;
            }
        }
        if (!(message = VDCConfig.Defense.unlockFailedMessage).isEmpty()) {
            class_2585 component = new class_2585(String.format(message, amount, new class_2588(VDCConfig.Defense.unlocker.method_7876()).method_27695(new class_124[0]).method_10851().trim()));
            player.method_7353((class_2561)component, VDCConfig.Defense.unlockFailedStatusMessage);
        }
        return false;
    }
}

