/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.handler;

import com.google.common.collect.Queues;
import com.therandomlabs.vanilladeathchest.VanillaDeathChest;
import com.therandomlabs.vanilladeathchest.api.event.player.PlayerDropAllItemsCallback;
import com.therandomlabs.vanilladeathchest.util.DeathChestPlacer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_3218;

public class DeathChestPlaceHandler
implements PlayerDropAllItemsCallback,
ServerTickEvents.EndWorldTick {
    private static final Map<class_2874, Queue<DeathChestPlacer>> PLACERS = new HashMap<class_2874, Queue<DeathChestPlacer>>();

    @Override
    public boolean onPlayerDropAllItems(class_3218 world, class_1657 player, List<class_1542> drops) {
        if (drops.isEmpty()) {
            return true;
        }
        class_1928 gameRules = world.method_8450();
        if (gameRules.method_8355(class_1928.field_19389)) {
            return true;
        }
        class_1928.class_4313<class_1928.class_4310> key = VanillaDeathChest.getDisableDeathChestsKey();
        if (key != null && gameRules.method_8355(key)) {
            return true;
        }
        Queue<DeathChestPlacer> placers = DeathChestPlaceHandler.getPlacers((class_1937)world);
        placers.add(new DeathChestPlacer(world, player, drops));
        return false;
    }

    public void onEndTick(class_3218 world) {
        DeathChestPlacer placer;
        Queue<DeathChestPlacer> placers = DeathChestPlaceHandler.getPlacers((class_1937)world);
        ArrayList<DeathChestPlacer> toReadd = new ArrayList<DeathChestPlacer>();
        while ((placer = placers.poll()) != null) {
            if (placer.run()) continue;
            toReadd.add(placer);
        }
        placers.addAll(toReadd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue<DeathChestPlacer> getPlacers(class_1937 world) {
        Map<class_2874, Queue<DeathChestPlacer>> map = PLACERS;
        synchronized (map) {
            return PLACERS.computeIfAbsent(world.method_8597(), key -> Queues.newConcurrentLinkedQueue());
        }
    }
}

