/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.util;

import com.google.common.collect.ImmutableList;
import com.therandomlabs.vanilladeathchest.VDCConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DeathChestLocationFinder {
    private static @Nullable SearchOrder searchOrder;

    public static Iterable<class_2338> getSearchOrder(int size) {
        if (searchOrder == null || DeathChestLocationFinder.searchOrder.size != size) {
            searchOrder = new SearchOrder(size);
        }
        return searchOrder;
    }

    public static @Nullable class_2338 findLocation(class_1937 world, class_1657 player, class_2338 pos, AtomicBoolean doubleChest) {
        boolean isDoubleChest = doubleChest.get();
        class_2338 searchPos = new class_2338(pos.method_10263(), Math.min(256, Math.max(1, pos.method_10264())), pos.method_10260());
        class_2338 singleChestPos = null;
        for (class_2338 translation : DeathChestLocationFinder.getSearchOrder(VDCConfig.Spawning.locationSearchRadius)) {
            class_2338 potentialPos = searchPos.method_10081((class_2382)translation);
            if (!DeathChestLocationFinder.canPlace(world, player, potentialPos)) continue;
            if ((!isDoubleChest || DeathChestLocationFinder.canPlace(world, player, potentialPos.method_10078())) && DeathChestLocationFinder.isOnSolidBlocks(world, player, potentialPos, isDoubleChest)) {
                return potentialPos;
            }
            if (singleChestPos != null) continue;
            singleChestPos = potentialPos;
        }
        if (singleChestPos != null) {
            doubleChest.set(false);
            return singleChestPos;
        }
        return VDCConfig.Spawning.forcePlaceIfLocationNotFound ? pos : null;
    }

    public static boolean canPlace(class_1937 world, class_1657 player, class_2338 pos, boolean doubleChest) {
        if (doubleChest) {
            return DeathChestLocationFinder.canPlace(world, player, pos) && DeathChestLocationFinder.canPlace(world, player, pos.method_10078());
        }
        return DeathChestLocationFinder.canPlace(world, player, pos);
    }

    public static boolean canPlace(class_1937 world, class_1657 player, class_2338 pos) {
        if (!world.method_22340(pos) || !world.method_8505(player, pos)) {
            return false;
        }
        class_1750 context = new class_1750(new class_1838(player, class_1268.field_5808, new class_3965(new class_243(0.0, 0.0, 0.0), class_2350.field_11033, pos, false)));
        if (DeathChestLocationFinder.isReplaceable(world, pos, context) && DeathChestLocationFinder.isReplaceable(world, pos.method_10084(), context)) {
            return DeathChestLocationFinder.isNotChest(world, pos.method_10095()) && DeathChestLocationFinder.isNotChest(world, pos.method_10078()) && DeathChestLocationFinder.isNotChest(world, pos.method_10072()) && DeathChestLocationFinder.isNotChest(world, pos.method_10067());
        }
        return false;
    }

    private static boolean isReplaceable(class_1937 world, class_2338 pos, class_1750 context) {
        if (pos.method_10264() < 1 || pos.method_10264() > world.method_8322()) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        return state.method_26215() || state.method_26166(context);
    }

    private static boolean isNotChest(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26204() != class_2246.field_10034;
    }

    private static boolean isOnSolidBlocks(class_1937 world, class_1657 player, class_2338 pos, boolean isDoubleChest) {
        if (!VDCConfig.Spawning.mustBeOnSolidBlocks) {
            return true;
        }
        class_2338 down = pos.method_10074();
        if (!world.method_8515(down, (class_1297)player)) {
            return false;
        }
        return !isDoubleChest || world.method_8515(down.method_10078(), (class_1297)player);
    }

    private static class SearchOrder
    implements Iterable<class_2338> {
        public final int size;
        private List<class_2338> translations;

        public SearchOrder(int size) {
            this.size = size;
            this.translations = new ArrayList<class_2338>();
            for (int x = 0; x <= size; ++x) {
                this.add(x);
                this.add(-x);
            }
            this.translations = ImmutableList.copyOf(this.translations);
        }

        @Override
        public Iterator<class_2338> iterator() {
            return this.translations.iterator();
        }

        private void add(int x) {
            for (int y = 0; y <= this.size; ++y) {
                this.add(x, y);
                this.add(x, -y);
            }
        }

        private void add(int x, int y) {
            for (int z = 0; z <= this.size; ++z) {
                this.translations.add(new class_2338(x, y, z));
                this.translations.add(new class_2338(x, y, -z));
            }
        }
    }
}

