/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.therandomlabs.vanilladeathchest.VDCConfig;
import com.therandomlabs.vanilladeathchest.VanillaDeathChest;
import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChestDefenseEntity;
import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChestManager;
import com.therandomlabs.vanilladeathchest.util.DeathChestLocationFinder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;

public final class DeathChestPlacer {
    private final WeakReference<class_3218> world;
    private final WeakReference<class_1657> player;
    private final List<class_1542> drops;
    private boolean alreadyCalled;

    public DeathChestPlacer(class_3218 world, class_1657 player, List<class_1542> drops) {
        this.world = new WeakReference<class_3218>(world);
        this.player = new WeakReference<class_1657>(player);
        this.drops = new ArrayList<class_1542>(drops);
    }

    public final boolean run() {
        if (!this.alreadyCalled) {
            this.alreadyCalled = true;
            return false;
        }
        class_3218 world = (class_3218)this.world.get();
        if (world == null) {
            return true;
        }
        class_1657 player = (class_1657)this.player.get();
        if (player == null) {
            return true;
        }
        this.place(world, player);
        for (class_1542 drop : this.drops) {
            world.method_8649((class_1297)new class_1542((class_1937)world, drop.method_23317(), drop.method_23318(), drop.method_23321(), drop.method_6983()));
        }
        return true;
    }

    private void place(class_3218 world, class_1657 player) {
        class_1542 item2;
        int i;
        class_2586 blockEntity2;
        boolean useDoubleChest;
        DeathChestType type = VDCConfig.Spawning.chestType;
        GameProfile profile = player.method_7334();
        class_2338 playerPos = new class_2338(player.method_19538());
        Pattern pattern = Pattern.compile(VDCConfig.Spawning.registryNameRegex);
        List filtered = this.drops.stream().filter(item -> pattern.matcher(class_2378.field_11142.method_10221((Object)item.method_6983().method_7909()).toString()).matches()).collect(Collectors.toList());
        boolean bl = useDoubleChest = (type == DeathChestType.SINGLE_OR_DOUBLE || type == DeathChestType.DOUBLE_SHULKER_BOX) && filtered.size() > 27;
        if (VDCConfig.Spawning.useContainerInInventory) {
            ArrayList<class_1542> empty = new ArrayList<class_1542>();
            boolean foundOne = false;
            boolean foundAll = false;
            for (class_1542 item3 : this.drops) {
                class_1799 stack = item3.method_6983();
                if (type == DeathChestType.SINGLE_ONLY || type == DeathChestType.SINGLE_OR_DOUBLE) {
                    if (stack.method_7909() != class_1792.field_8003.get(class_2246.field_10034)) {
                        continue;
                    }
                } else {
                    if (!(class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2480)) continue;
                    class_2487 tag = stack.method_7969();
                    if (tag != null) {
                        class_2371 inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                        class_1262.method_5429((class_2487)tag.method_10562("BlockEntityTag"), (class_2371)inventory);
                        if (inventory.stream().anyMatch(itemStack -> !itemStack.method_7960())) continue;
                    }
                }
                if (!useDoubleChest) {
                    stack.method_7934(1);
                    if (stack.method_7960()) {
                        empty.add(item3);
                    }
                    foundAll = true;
                    break;
                }
                if (stack.method_7947() > 1) {
                    stack.method_7934(2);
                    if (stack.method_7960()) {
                        empty.add(item3);
                    }
                    foundAll = true;
                    break;
                }
                stack.method_7934(1);
                if (stack.method_7960()) {
                    empty.add(item3);
                }
                if (foundOne) {
                    foundAll = true;
                    break;
                }
                foundOne = true;
            }
            if (useDoubleChest) {
                if (!foundAll) {
                    if (!foundOne) {
                        return;
                    }
                    useDoubleChest = false;
                }
            } else if (!foundAll) {
                return;
            }
            this.drops.removeAll(empty);
            filtered.removeAll(empty);
        }
        AtomicBoolean doubleChest = new AtomicBoolean(useDoubleChest);
        class_2338 pos = DeathChestLocationFinder.findLocation((class_1937)world, player, playerPos, doubleChest);
        useDoubleChest = doubleChest.get();
        if (pos == null) {
            VanillaDeathChest.logger.warn("No death chest location found for player at [{}]", (Object)playerPos);
            return;
        }
        class_2248 block = type == DeathChestType.SHULKER_BOX || type == DeathChestType.DOUBLE_SHULKER_BOX ? class_2480.method_10525((class_1767)VDCConfig.Spawning.shulkerBoxColor.get()) : class_2246.field_10034;
        class_2680 state = block.method_9564();
        class_2338 east = pos.method_10078();
        if (useDoubleChest) {
            if (block == class_2246.field_10034) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12574));
                world.method_8501(east, (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12571));
            } else {
                world.method_8501(pos, state);
                world.method_8501(east, state);
            }
        } else {
            world.method_8501(pos, state);
        }
        class_2586 blockEntity = world.method_8321(pos);
        class_2586 class_25862 = blockEntity2 = useDoubleChest ? world.method_8321(east) : null;
        if (!(blockEntity instanceof class_2621) || useDoubleChest && !(blockEntity2 instanceof class_2621)) {
            VanillaDeathChest.logger.warn("Failed to place death chest at [{}] due to invalid block entity", (Object)pos);
            return;
        }
        class_2621 chest = (class_2621)(useDoubleChest ? blockEntity2 : blockEntity);
        for (i = 0; i < 27 && !filtered.isEmpty(); ++i) {
            item2 = (class_1542)filtered.get(0);
            chest.method_5447(i, item2.method_6983());
            filtered.remove(0);
            this.drops.remove(item2);
        }
        if (!VDCConfig.Spawning.containerDisplayName.isEmpty()) {
            chest.method_17488((class_2561)new class_2585(VDCConfig.Spawning.containerDisplayName));
        }
        if (useDoubleChest) {
            chest = (class_2621)blockEntity;
            for (i = 0; i < 27 && !filtered.isEmpty(); ++i) {
                item2 = (class_1542)filtered.get(0);
                chest.method_5447(i, item2.method_6983());
                filtered.remove(0);
                this.drops.remove(item2);
            }
            if (!VDCConfig.Spawning.containerDisplayName.isEmpty()) {
                chest.method_17488((class_2561)new class_2585(VDCConfig.Spawning.containerDisplayName));
            }
        }
        if (VDCConfig.Defense.defenseEntityRegistryName != null) {
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5;
            for (int i2 = 0; i2 < VDCConfig.Defense.defenseEntitySpawnCount; ++i2) {
                class_2487 compound = null;
                try {
                    compound = class_2522.method_10718((String)VDCConfig.Defense.defenseEntityNBT);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
                compound.method_10582("id", VDCConfig.Defense.defenseEntityRegistryName.toString());
                class_1297 entity = class_1299.method_17842((class_2487)compound, (class_1937)world, spawnedEntity -> {
                    spawnedEntity.method_23327(x, y, z);
                    return !world.method_18768(spawnedEntity) ? null : spawnedEntity;
                });
                if (!(entity instanceof class_1308)) continue;
                class_1308 living = (class_1308)entity;
                living.method_5971();
                living.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16467, null, null);
                living.method_6015((class_1309)player);
                DeathChestDefenseEntity defenseEntity = (DeathChestDefenseEntity)living;
                defenseEntity.setDeathChestPlayer(player.method_5667());
                defenseEntity.setDeathChestPos(pos);
            }
        }
        DeathChestManager.addDeathChest(world, player, pos, useDoubleChest);
        VanillaDeathChest.logger.info("Death chest for {} spawned at [{}]", (Object)profile.getName(), (Object)pos);
        player.method_7353((class_2561)new class_2585(String.format(VDCConfig.Spawning.chatMessage, pos.method_10263(), pos.method_10264(), pos.method_10260())), false);
    }

    public static enum DeathChestType {
        SINGLE_ONLY,
        SINGLE_OR_DOUBLE,
        SHULKER_BOX,
        DOUBLE_SHULKER_BOX;

    }
}

