/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.world.storage;

import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChest;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VDCSavedData
extends class_18 {
    public static final int TAG_COMPOUND = new class_2487().method_10711();
    public static final String ID = "vanilladeathchest";
    public static final String DEATH_CHESTS_KEY = "DeathChests";
    public static final String UUID_KEY = "UUID";
    public static final String CREATION_TIME_KEY = "CreationTime";
    public static final String POS_KEY = "Pos";
    public static final String IS_DOUBLE_CHEST_KEY = "IsDoubleChest";
    public static final String UNLOCKED_KEY = "Unlocked";
    private static @Nullable class_3218 currentWorld;
    private final class_3218 world;
    private Map<class_2338, DeathChest> deathChests = new ConcurrentHashMap<class_2338, DeathChest>();

    public VDCSavedData() {
        this(ID);
    }

    public VDCSavedData(String name) {
        super(name);
        if (currentWorld == null) {
            throw new NullPointerException("currentWorld should not be null");
        }
        this.world = currentWorld;
    }

    public void method_77(class_2487 nbt) {
        this.deathChests.clear();
        class_2499 list = nbt.method_10554(DEATH_CHESTS_KEY, TAG_COMPOUND);
        for (class_2520 tag : list) {
            class_2487 compound = (class_2487)tag;
            UUID playerID = class_2512.method_25930((class_2520)compound.method_10580(UUID_KEY));
            long creationTime = compound.method_10537(CREATION_TIME_KEY);
            class_2338 pos = class_2512.method_10691((class_2487)compound.method_10562(POS_KEY));
            boolean isDoubleChest = compound.method_10577(IS_DOUBLE_CHEST_KEY);
            boolean unlocked = compound.method_10577(UNLOCKED_KEY);
            this.deathChests.put(pos, new DeathChest(this.world, playerID, creationTime, pos, isDoubleChest, unlocked));
        }
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 tagList = new class_2499();
        for (Map.Entry<class_2338, DeathChest> entry : this.deathChests.entrySet()) {
            DeathChest deathChest = entry.getValue();
            class_2487 compound = new class_2487();
            compound.method_10566(UUID_KEY, (class_2520)class_2512.method_25929((UUID)deathChest.getPlayerID()));
            compound.method_10544(CREATION_TIME_KEY, deathChest.getCreationTime());
            compound.method_10566(POS_KEY, (class_2520)class_2512.method_10692((class_2338)entry.getKey()));
            compound.method_10556(IS_DOUBLE_CHEST_KEY, deathChest.isDoubleChest());
            compound.method_10556(UNLOCKED_KEY, deathChest.isUnlocked());
            tagList.add((Object)compound);
        }
        nbt.method_10566(DEATH_CHESTS_KEY, (class_2520)tagList);
        return nbt;
    }

    public Map<class_2338, DeathChest> getDeathChests() {
        return this.deathChests;
    }

    public static VDCSavedData get(class_3218 world) {
        currentWorld = world;
        VDCSavedData instance = (VDCSavedData)world.method_17983().method_17924(VDCSavedData::new, ID);
        currentWorld = null;
        return instance;
    }
}

