/*
 * Decompiled with CFR 0.152.
 */
package net.hkva.discord;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.hkva.discord.Config;

public class ConfigFile {
    public static final Config DEFAULT_CONFIG = new Config();
    private static final File FABRIC_CONFIG_DIR = FabricLoader.getInstance().getConfigDirectory();
    private static final Gson CONFIG_SERIALIZER = new GsonBuilder().setPrettyPrinting().create();
    private final File file;

    public ConfigFile(String fileName) {
        this.file = new File(FABRIC_CONFIG_DIR, fileName);
    }

    public String toString() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            return this.file.getAbsolutePath();
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public Optional<Config> readConfig() {
        Optional<Config> optional;
        FileReader reader = new FileReader(this.file);
        try {
            optional = Optional.of((Config)CONFIG_SERIALIZER.fromJson((Reader)reader, Config.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public void writeConfig(Config config) {
        try (FileWriter writer = new FileWriter(this.file);){
            writer.write(CONFIG_SERIALIZER.toJson((Object)config));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeDefaultConfig() {
        this.writeConfig(DEFAULT_CONFIG);
    }
}

