/*
 * Decompiled with CFR 0.152.
 */
package net.hkva.discord;

import java.util.Optional;
import java.util.function.Consumer;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.hkva.discord.callback.DiscordMessageCallback;

public class DiscordBot
extends ListenerAdapter {
    private Optional<JDA> connection = Optional.empty();

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        ((DiscordMessageCallback)DiscordMessageCallback.EVENT.invoker()).dispatch(event.getMessage());
    }

    public void connect(String token) throws LoginException, InterruptedException {
        JDABuilder builder = JDABuilder.createDefault(token).setStatus(OnlineStatus.ONLINE).addEventListeners(this);
        this.connection = Optional.of(builder.build());
        this.connection.get().awaitReady();
    }

    public void disconnect() {
        this.withConnection(c -> c.shutdownNow());
        this.connection = Optional.empty();
    }

    public boolean isConnected() {
        return this.connection.isPresent() && this.connection.get().getStatus() == JDA.Status.CONNECTED;
    }

    public boolean withConnection(Consumer<JDA> action) {
        if (!this.connection.isPresent()) {
            return false;
        }
        action.accept(this.connection.get());
        return true;
    }
}

