/*
 * Decompiled with CFR 0.152.
 */
package net.hkva.discord;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.vdurmont.emoji.EmojiParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.server.ServerStartCallback;
import net.fabricmc.fabric.api.event.server.ServerStopCallback;
import net.fabricmc.fabric.api.event.server.ServerTickCallback;
import net.hkva.discord.Config;
import net.hkva.discord.ConfigFile;
import net.hkva.discord.DiscordBot;
import net.hkva.discord.DiscordCommandManager;
import net.hkva.discord.callback.DiscordMessageCallback;
import net.hkva.discord.callback.ServerChatCallback;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2556;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiscordIntegrationMod
implements DedicatedServerModInitializer {
    public static Logger LOGGER = LogManager.getLogger((String)"Discord Integration");
    public static List<String> messageBufferIn = Collections.synchronizedList(new ArrayList());
    private static final ConfigFile configFile = new ConfigFile("discord.json");
    private static Config config = ConfigFile.DEFAULT_CONFIG;
    private static DiscordBot bot = new DiscordBot();
    private static Optional<MinecraftServer> server = Optional.empty();
    private static DiscordCommandManager commands = new DiscordCommandManager();
    private static int lastPlayerCount = -1;
    private static final int PLAYER_COUNT_UPDATE_INTERVAL = 100;

    public void onInitializeServer() {
        if (!DiscordIntegrationMod.readConfig()) {
            LOGGER.warn("Not running since config was just created");
            LOGGER.warn("You can reload the config with /discord loadConfig");
            LOGGER.warn("Then, you can connect to Discord with /discord reconnect");
            return;
        }
        DiscordIntegrationMod.connectBot();
        ServerStartCallback.EVENT.register(DiscordIntegrationMod::onServerStart);
        ServerStopCallback.EVENT.register(DiscordIntegrationMod::onServerStop);
        ServerTickCallback.EVENT.register(DiscordIntegrationMod::onServerTick);
        ServerChatCallback.EVENT.register(DiscordIntegrationMod::onServerChat);
        DiscordMessageCallback.EVENT.register(DiscordIntegrationMod::onDiscordChat);
    }

    private static void onServerStart(MinecraftServer server) {
        DiscordIntegrationMod.server = Optional.of(server);
    }

    private static void onServerStop(MinecraftServer server) {
        DiscordIntegrationMod.server = Optional.empty();
        bot.disconnect();
    }

    private static void onServerTick(MinecraftServer server) {
        if (server.method_3780() % 100 == 0) {
            int playerCount = server.method_3788();
            bot.withConnection(c -> {
                if (lastPlayerCount != playerCount) {
                    lastPlayerCount = playerCount;
                    c.getPresence().setActivity(Activity.playing(String.format("%d/%d players", playerCount, server.method_3802())));
                }
            });
        }
    }

    private static void onServerChat(MinecraftServer server, class_2561 text, class_2556 type, UUID senderUUID) {
        if (type == class_2556.field_11737 && senderUUID == class_156.field_25140) {
            return;
        }
        String discordMessage = DiscordIntegrationMod.formatOutgoing(text.getString());
        bot.withConnection(c -> {
            for (Long channelID : DiscordIntegrationMod.config.relayChannelIDs) {
                TextChannel relayChannel = c.getTextChannelById(channelID);
                if (relayChannel == null || !relayChannel.canTalk()) {
                    LOGGER.warn("Relay channel " + channelID + " is invalid");
                    continue;
                }
                relayChannel.sendMessage(DiscordIntegrationMod.formatGuildEmoji(discordMessage, relayChannel.getGuild())).queue();
            }
        });
    }

    private static void onDiscordChat(Message message) {
        if (!server.isPresent()) {
            return;
        }
        if (message.getType() != MessageType.DEFAULT) {
            return;
        }
        User author = message.getAuthor();
        if (author.isBot()) {
            return;
        }
        String messageContent = message.getContentDisplay();
        if (messageContent.startsWith(DiscordIntegrationMod.config.commandPrefix) && message.getTextChannel().canTalk()) {
            String messageNoPrefix = messageContent.substring(DiscordIntegrationMod.config.commandPrefix.length());
            try {
                commands.getDispatcher().execute(messageNoPrefix, (Object)message);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return;
        }
        if (!DiscordIntegrationMod.config.relayChannelIDs.contains(message.getChannel().getIdLong())) {
            return;
        }
        server.get().method_3760().method_14616(DiscordIntegrationMod.formatIncoming(message), class_2556.field_11737, class_156.field_25140);
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"discord").requires(serverCommandSource -> serverCommandSource.method_9259(4))).then(class_2170.method_9247((String)"loadConfig").executes(DiscordIntegrationMod::reloadConfigCommand))).then(class_2170.method_9247((String)"status").executes(DiscordIntegrationMod::statusCommand))).then(class_2170.method_9247((String)"reconnect").executes(DiscordIntegrationMod::reconnectCommand)));
    }

    public static int reloadConfigCommand(CommandContext<class_2168> context) {
        String response = "Discord: Loaded config";
        if (!DiscordIntegrationMod.readConfig()) {
            response = "Discord: Wrote default config";
        }
        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(response), true);
        return 0;
    }

    public static int statusCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!bot.isConnected()) {
            source.method_9226((class_2561)new class_2585("Discord: Not connected"), false);
        } else {
            bot.withConnection(c -> {
                source.method_9226((class_2561)new class_2585("Discord: Connected"), false);
                source.method_9226((class_2561)new class_2585("Status: " + (Object)((Object)c.getStatus())), false);
            });
        }
        return 0;
    }

    public static int reconnectCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        bot.disconnect();
        source.method_9226((class_2561)new class_2585("Discord: Disconnected"), true);
        if (!DiscordIntegrationMod.connectBot()) {
            source.method_9226((class_2561)new class_2585("Discord: Could not log in"), true);
        } else {
            source.method_9226((class_2561)new class_2585("Discord: Connected"), true);
        }
        return 0;
    }

    public static boolean readConfig() {
        Optional<Config> readResult;
        boolean result = true;
        if (!configFile.exists()) {
            LOGGER.warn("Config file " + configFile + " does not exist, creating...");
            configFile.writeDefaultConfig();
            result = false;
        }
        if (!(readResult = configFile.readConfig()).isPresent()) {
            LOGGER.error("Failed to read config file " + configFile);
        } else {
            LOGGER.info("Read config " + configFile);
            config = readResult.get();
        }
        return result;
    }

    public static boolean connectBot() {
        if (bot.isConnected()) {
            throw new IllegalStateException("Bot is already connected");
        }
        try {
            bot.connect(DiscordIntegrationMod.config.token);
        }
        catch (Exception e) {
            LOGGER.warn("Discord: Could not log in with the supplied token");
            return false;
        }
        LOGGER.info("Discord: Logged in");
        return true;
    }

    public static void disconnectBot() {
        if (!bot.isConnected()) {
            throw new IllegalStateException("Bot is already disconnected");
        }
        bot.disconnect();
        LOGGER.info("Logged out of Discord");
    }

    public static void withServer(Consumer<MinecraftServer> action) {
        if (server.isPresent()) {
            action.accept(server.get());
        }
    }

    public static String formatOutgoing(String message) {
        return message.replace("@", "@ ");
    }

    public static class_2561 formatIncoming(Message message) {
        class_2585 text = new class_2585(String.format("[%s] ", DiscordIntegrationMod.formatUsername(message.getAuthor())));
        for (Message.Attachment a : message.getAttachments()) {
            class_2585 attachmentText = new class_2585(a.getFileName());
            attachmentText.method_10862(attachmentText.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11749, a.getUrl())).method_27706(class_124.field_1060).method_27706(class_124.field_1073).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("Click to open in your web browser"))));
            text.method_10852((class_2561)attachmentText).method_27693(" ");
        }
        text.method_27693(EmojiParser.parseToAliases(message.getContentDisplay()));
        return text;
    }

    public static String formatUsername(User user) {
        return String.format("%s#%s", user.getName(), user.getDiscriminator());
    }

    public static String escapeDiscordFormatting(String str) {
        return str.replaceAll("_", "\\_");
    }

    public static String formatGuildEmoji(String message, Guild guild) {
        for (Emote e : guild.getEmotes()) {
            String emojiDisplay = String.format(":%s:", e.getName());
            String emojiFormatted = String.format("<%s%s>", emojiDisplay, e.getId());
            message = message.replaceAll(emojiDisplay, emojiFormatted);
        }
        return message;
    }
}

