/*
 * Decompiled with CFR 0.152.
 */
package net.hkva.discord.discordcommand;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.util.ArrayList;
import java.util.ListIterator;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.hkva.discord.DiscordCommandManager;
import net.hkva.discord.DiscordIntegrationMod;
import net.minecraft.class_266;
import net.minecraft.class_267;

public class ScoreboardCommand {
    public static void register(CommandDispatcher<Message> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)DiscordCommandManager.literal("scoreboard").then(DiscordCommandManager.literal("list").executes(ScoreboardCommand::listScoreboards))).then(DiscordCommandManager.argument("name", StringArgumentType.string()).executes(ScoreboardCommand::displayScoreboard)));
    }

    public static int listScoreboards(CommandContext<Message> context) {
        DiscordIntegrationMod.withServer(s -> {
            EmbedBuilder e = new EmbedBuilder();
            e.setColor(Color.GREEN);
            e.setTitle("Available scoreboards");
            for (class_266 o : s.method_3845().method_1151()) {
                e.appendDescription(String.format("%s\n", o.method_1113()));
            }
            ((Message)context.getSource()).getTextChannel().sendMessage(e.build()).queue();
        });
        return 0;
    }

    public static int displayScoreboard(CommandContext<Message> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        DiscordIntegrationMod.withServer(s -> {
            class_266 o = s.method_3845().method_1165(name);
            if (o == null) {
                EmbedBuilder e = new EmbedBuilder();
                e.setColor(Color.RED);
                e.setTitle("Error");
                e.setDescription(String.format("No scoreboard named \"%s\" exists", name));
                ((Message)context.getSource()).getTextChannel().sendMessage(e.build()).queue();
                return;
            }
            EmbedBuilder e = new EmbedBuilder();
            e.setColor(Color.GREEN);
            e.setTitle(o.method_1114().getString());
            ArrayList scores = new ArrayList(s.method_3845().method_1184(o));
            ListIterator itr = scores.listIterator(scores.size());
            while (itr.hasPrevious()) {
                class_267 score = (class_267)itr.previous();
                e.appendDescription(String.format("%s: %d\n", DiscordIntegrationMod.escapeDiscordFormatting(score.method_1129()), score.method_1126()));
            }
            ((Message)context.getSource()).getTextChannel().sendMessage(e.build()).queue();
        });
        return 0;
    }
}

