/*
 * Decompiled with CFR 0.152.
 */
package com.extracraftx.minecraft.bettersleeping.events;

import com.extracraftx.minecraft.bettersleeping.BetterSleeping;
import com.extracraftx.minecraft.bettersleeping.config.Config;
import com.extracraftx.minecraft.bettersleeping.interfaces.SleepManaged;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5268;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.text.StrSubstitutor;

public class EventHandler {
    public static void onTick(MinecraftServer server) {
        int percent = server.method_3767().method_8356(BetterSleeping.key);
        if (percent >= 100 || percent <= 0) {
            return;
        }
        server.method_3738().forEach(world -> {
            List players = world.method_18456();
            int count = 0;
            for (class_1657 p : players) {
                if (!p.method_6113() || !p.method_7276()) continue;
                ++count;
            }
            if (count != players.size() && count * 100 / players.size() >= percent) {
                EventHandler.skipNight(world, players);
            }
        });
    }

    private static void skipNight(class_3218 world, List<class_3222> players) {
        if (world.method_8450().method_8355(class_1928.field_19396)) {
            long l = world.method_8401().method_217() + 24000L;
            world.method_29199(l - l % 24000L);
        }
        if (world.method_8450().method_8355(class_1928.field_19406)) {
            ((class_5268)world.method_8401()).method_164(0);
            ((class_5268)world.method_8401()).method_157(false);
            ((class_5268)world.method_8401()).method_173(0);
            ((class_5268)world.method_8401()).method_147(false);
        }
        class_2585 skipText = new class_2585(Config.INSTANCE.nightSkippedMessage);
        for (String format : Config.INSTANCE.formatting) {
            skipText.method_27692(class_124.method_533((String)format));
        }
        players.forEach(p -> {
            p.method_9203((class_2561)skipText, p.method_5667());
            if (p.method_6113()) {
                p.method_7358(false, true);
                SleepManaged sm = (SleepManaged)p;
                sm.setNightsAwake(0);
            } else {
                SleepManaged sm = (SleepManaged)p;
                sm.incrementNightsAwake(1);
                int nightsAwake = sm.getNightsAwake();
                if (Config.INSTANCE.awakeDebuff && nightsAwake >= Config.INSTANCE.nightsBeforeDebuff) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("nights", NumberFormat.getInstance().format(nightsAwake));
                    class_2585 debuffText = new class_2585(StrSubstitutor.replace((Object)Config.INSTANCE.debuffMessage, args, (String)"{", (String)"}"));
                    for (String format : Config.INSTANCE.formatting) {
                        debuffText.method_27692(class_124.method_533((String)format));
                    }
                    p.method_9203((class_2561)debuffText, p.method_5667());
                    int nightsAwakeOver = nightsAwake - Config.INSTANCE.nightsBeforeDebuff + 1;
                    p.method_6092(new class_1293(class_1294.field_5916, nightsAwakeOver * 100));
                    p.method_6092(new class_1293(class_1294.field_5909, 1000, nightsAwakeOver / 2));
                    p.method_6092(new class_1293(class_1294.field_5901, 1000, nightsAwakeOver / 2));
                    p.method_6092(new class_1293(class_1294.field_5911, 1000, nightsAwakeOver / 2));
                    if (nightsAwakeOver > 2) {
                        p.method_6092(new class_1293(class_1294.field_5919, 500));
                    }
                }
            }
        });
    }

    public static void onWakeup(class_1657 player, boolean b1, boolean b2) {
        if (!(player instanceof class_3222)) {
            return;
        }
        if (Config.INSTANCE.sleepRecovery && !b2) {
            player.method_6092(new class_1293(class_1294.field_5924, 300, 0));
            return;
        }
        List players = player.method_5770().method_18456();
        long count = players.stream().filter(class_1309::method_6113).count();
        if (players.size() <= 1) {
            return;
        }
        class_3222 sp = (class_3222)player;
        EventHandler.sendAsleepMessage(players, count, players.size(), sp.method_5682().method_3767().method_8356(BetterSleeping.key));
    }

    public static void onSleep(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        List players = player.method_5770().method_18456();
        long count = players.stream().filter(class_1309::method_6113).count();
        if (players.size() <= 1) {
            return;
        }
        class_3222 sp = (class_3222)player;
        EventHandler.sendAsleepMessage(players, count, players.size(), sp.method_5682().method_3767().method_8356(BetterSleeping.key));
    }

    private static void sendAsleepMessage(List<? extends class_1657> players, long asleep, int total, int percentRequired) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("asleep", NumberFormat.getInstance().format(asleep));
        args.put("total", NumberFormat.getInstance().format(players.size()));
        args.put("percent", NumberFormat.getInstance().format(asleep * 100L / (long)players.size()));
        args.put("required", NumberFormat.getInstance().format(percentRequired * players.size() / 100));
        args.put("percentRequired", NumberFormat.getInstance().format(percentRequired));
        class_2585 sleepingMessage = new class_2585(StrSubstitutor.replace((Object)Config.INSTANCE.playersAsleepMessage, args, (String)"{", (String)"}"));
        for (String format : Config.INSTANCE.formatting) {
            sleepingMessage.method_27692(class_124.method_533((String)format));
        }
        players.forEach(p -> p.method_9203((class_2561)sleepingMessage, p.method_5667()));
    }
}

