/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.goal;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_3695;
import net.minecraft.class_4135;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1355.class})
public abstract class GoalSelectorMixin {
    private static final class_1352.class_4134[] CONTROLS = class_1352.class_4134.values();
    @Shadow
    @Final
    private Supplier<class_3695> field_6463;
    @Mutable
    @Shadow
    @Final
    private Set<class_4135> field_6461;
    @Shadow
    @Final
    private EnumSet<class_1352.class_4134> field_6462;
    @Shadow
    @Final
    private Map<class_1352.class_4134, class_4135> field_18411;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void reinit(Supplier<class_3695> supplier, CallbackInfo ci) {
        this.field_6461 = new ObjectLinkedOpenHashSet(this.field_6461);
    }

    @Overwrite
    public void method_6275() {
        this.updateGoalStates();
        this.tickGoals();
    }

    private void updateGoalStates() {
        this.field_6463.get().method_15396("goalUpdate");
        this.stopGoals();
        this.cleanupControls();
        this.startGoals();
        this.field_6463.get().method_15407();
    }

    private void stopGoals() {
        for (class_4135 goal : this.field_6461) {
            if (!goal.method_19056() || goal.method_6266() && !this.areControlsDisabled(goal)) continue;
            goal.method_6270();
        }
    }

    private void cleanupControls() {
        for (class_1352.class_4134 control : CONTROLS) {
            class_4135 goal = this.field_18411.get(control);
            if (goal == null || goal.method_19056()) continue;
            this.field_18411.remove(control);
        }
    }

    private void startGoals() {
        for (class_4135 goal : this.field_6461) {
            if (goal.method_19056() || !goal.method_6264() || !this.areGoalControlsAvailable(goal)) continue;
            for (class_1352.class_4134 control : goal.method_6271()) {
                class_4135 otherGoal = this.getGoalOccupyingControl(control);
                if (otherGoal != null) {
                    otherGoal.method_6270();
                }
                this.setGoalOccupyingControl(control, goal);
            }
            goal.method_6269();
        }
    }

    private void tickGoals() {
        this.field_6463.get().method_15396("goalTick");
        for (class_4135 goal : this.field_6461) {
            if (!goal.method_19056()) continue;
            goal.method_6268();
        }
        this.field_6463.get().method_15407();
    }

    private boolean areControlsDisabled(class_4135 goal) {
        for (class_1352.class_4134 control : goal.method_6271()) {
            if (!this.isControlDisabled(control)) continue;
            return true;
        }
        return false;
    }

    private boolean areGoalControlsAvailable(class_4135 goal) {
        for (class_1352.class_4134 control : goal.method_6271()) {
            if (this.isControlDisabled(control)) {
                return false;
            }
            class_4135 occupied = this.getGoalOccupyingControl(control);
            if (occupied == null || occupied.method_19055(goal)) continue;
            return false;
        }
        return true;
    }

    private boolean isControlDisabled(class_1352.class_4134 control) {
        return this.field_6462.contains(control);
    }

    private class_4135 getGoalOccupyingControl(class_1352.class_4134 control) {
        return this.field_18411.get(control);
    }

    private void setGoalOccupyingControl(class_1352.class_4134 control, class_4135 goal) {
        this.field_18411.put(control, goal);
    }
}

