/*
 * Decompiled with CFR 0.152.
 */
package io.github.gunpowder.entities;

import com.google.common.collect.ImmutableList;
import io.github.gunpowder.api.GunpowderDimensionManager;
import io.github.gunpowder.api.GunpowderMod;
import io.github.gunpowder.api.builders.TeleportRequest;
import io.github.gunpowder.mixin.cast.SyncPlayer;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2385;
import net.minecraft.class_27;
import net.minecraft.class_2780;
import net.minecraft.class_2784;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3949;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J<\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0016\u0010\u001c\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0016J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lio/github/gunpowder/entities/DimensionManager;", "Lio/github/gunpowder/api/GunpowderDimensionManager;", "()V", "dimTypeRegistry", "Lnet/minecraft/util/registry/SimpleRegistry;", "Lnet/minecraft/world/dimension/DimensionType;", "getDimTypeRegistry", "()Lnet/minecraft/util/registry/SimpleRegistry;", "server", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "addDimensionType", "", "dimensionTypeId", "Lnet/minecraft/util/registry/RegistryKey;", "dimensionType", "persist", "", "addWorld", "Lnet/minecraft/server/world/ServerWorld;", "worldId", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/chunk/ChunkGenerator;", "properties", "Lnet/minecraft/world/level/ServerWorldProperties;", "hasDimensionType", "hasWorld", "removeDimensionType", "removeWorld", "gunpowder-base"})
public final class DimensionManager
implements GunpowderDimensionManager {
    @NotNull
    public static final DimensionManager INSTANCE;

    @NotNull
    public final MinecraftServer getServer() {
        return GunpowderMod.Companion.getInstance().getServer();
    }

    private final class_2370<class_2874> getDimTypeRegistry() {
        class_2385 class_23852 = this.getServer().field_25132.method_30530(class_2378.field_25095);
        if (class_23852 == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.util.registry.SimpleRegistry<net.minecraft.world.dimension.DimensionType>");
        }
        return (class_2370)class_23852;
    }

    @Override
    public boolean hasDimensionType(@NotNull class_5321<class_2874> dimensionTypeId) {
        Intrinsics.checkNotNullParameter(dimensionTypeId, (String)"dimensionTypeId");
        return this.getDimTypeRegistry().field_25067.containsKey(dimensionTypeId);
    }

    @Override
    public void addDimensionType(@NotNull class_5321<class_2874> dimensionTypeId, @NotNull class_2874 dimensionType, boolean persist) {
        Intrinsics.checkNotNullParameter(dimensionTypeId, (String)"dimensionTypeId");
        Intrinsics.checkNotNullParameter((Object)dimensionType, (String)"dimensionType");
        if (this.hasDimensionType(dimensionTypeId)) {
            throw (Throwable)new IllegalArgumentException("DimensionType " + dimensionTypeId.method_29177() + " already registered!");
        }
        class_2378.method_10230((class_2378)((class_2378)this.getDimTypeRegistry()), (class_2960)dimensionTypeId.method_29177(), (Object)dimensionType);
    }

    @Override
    public void removeDimensionType(@NotNull class_5321<class_2874> dimensionTypeId) {
        Intrinsics.checkNotNullParameter(dimensionTypeId, (String)"dimensionTypeId");
        if (Intrinsics.areEqual(dimensionTypeId, (Object)class_2874.field_24753) || Intrinsics.areEqual(dimensionTypeId, (Object)class_2874.field_24754) || Intrinsics.areEqual(dimensionTypeId, (Object)class_2874.field_24755)) {
            return;
        }
        if (!this.hasDimensionType(dimensionTypeId)) {
            return;
        }
        class_2874 dtype = (class_2874)this.getDimTypeRegistry().field_11107.get((Object)dimensionTypeId.method_29177());
        this.getDimTypeRegistry().field_11107.remove((Object)dimensionTypeId.method_29177());
        this.getDimTypeRegistry().field_25067.remove(dimensionTypeId);
        this.getDimTypeRegistry().field_26731.remove(dtype);
        this.getDimTypeRegistry().field_26682.remove((Object)dtype);
        this.getDimTypeRegistry().field_26683.removeInt((Object)dtype);
    }

    @Override
    public boolean hasWorld(@NotNull class_5321<class_1937> worldId) {
        Intrinsics.checkNotNullParameter(worldId, (String)"worldId");
        return this.getServer().field_4589.containsKey(worldId);
    }

    @Override
    @NotNull
    public class_3218 addWorld(@NotNull class_5321<class_1937> worldId, @NotNull class_5321<class_2874> dimensionTypeId, @NotNull class_2794 chunkGenerator, @NotNull class_5268 properties, boolean persist) {
        Intrinsics.checkNotNullParameter(worldId, (String)"worldId");
        Intrinsics.checkNotNullParameter(dimensionTypeId, (String)"dimensionTypeId");
        Intrinsics.checkNotNullParameter((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        if (this.hasWorld(worldId)) {
            throw (Throwable)new IllegalArgumentException("World " + worldId.method_29177() + " already registered!");
        }
        class_5219 class_52192 = this.getServer().method_27728();
        Intrinsics.checkNotNullExpressionValue((Object)class_52192, (String)"server.saveProperties");
        class_5285 generatorOptions = class_52192.method_28057();
        Object object = this.getDimTypeRegistry().method_29107(dimensionTypeId);
        Intrinsics.checkNotNull((Object)object);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dimTypeRegistry.get(dimensionTypeId)!!");
        class_2874 dimensionType = (class_2874)object;
        Object v = this.getServer().field_4589.get(class_1937.field_25179);
        Intrinsics.checkNotNull(v);
        class_3218 overworld = (class_3218)v;
        class_3949 worldGenerationProgressListener = overworld.method_14178().field_17254.field_17442;
        class_5285 class_52852 = generatorOptions;
        Intrinsics.checkNotNullExpressionValue((Object)class_52852, (String)"generatorOptions");
        long seed = class_52852.method_28028();
        class_2784 worldBorder2 = new class_2784(dimensionType){
            final /* synthetic */ class_2874 $dimensionType;

            public double method_11964() {
                return super.method_11964() / this.$dimensionType.method_31110();
            }

            public double method_11980() {
                return super.method_11980() / this.$dimensionType.method_31110();
            }
            {
                this.$dimensionType = $captured_local_variable$0;
            }
        };
        class_27 props = new class_27(this.getServer().method_27728(), properties);
        class_3218 world = new class_3218(this.getServer(), this.getServer().field_17200, this.getServer().field_23784, (class_5268)props, worldId, dimensionType, worldGenerationProgressListener, chunkGenerator, false, seed, (List)ImmutableList.of(), false);
        worldBorder2.method_11983((class_2780)new class_2780.class_3976(world.method_8621()));
        Map map = this.getServer().field_4589;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"server.worlds");
        map.put(worldId, world);
        class_3324 class_33242 = this.getServer().method_3760();
        Intrinsics.checkNotNullExpressionValue((Object)class_33242, (String)"server.playerManager");
        for (class_3222 player : class_33242.method_14571()) {
            GunpowderMod.Companion.getInstance().getLogger().info("Marking needsSync for player " + player);
            class_3222 class_32222 = player;
            if (class_32222 == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.github.gunpowder.mixin.cast.SyncPlayer");
            }
            ((SyncPlayer)class_32222).setNeedsSync(true);
        }
        return world;
    }

    @Override
    public void removeWorld(@NotNull class_5321<class_1937> worldId) {
        Intrinsics.checkNotNullParameter(worldId, (String)"worldId");
        if (Intrinsics.areEqual(worldId, (Object)class_1937.field_25181) || Intrinsics.areEqual(worldId, (Object)class_1937.field_25180) || Intrinsics.areEqual(worldId, (Object)class_1937.field_25179)) {
            return;
        }
        if (!this.hasWorld(worldId)) {
            return;
        }
        class_3218 world = (class_3218)this.getServer().field_4589.remove(worldId);
        if (world != null) {
            File path = world.method_8503().field_23784.method_27424(world.method_27983());
            FileUtils.deleteDirectory((File)path);
            class_3324 class_33242 = this.getServer().method_3760();
            Intrinsics.checkNotNullExpressionValue((Object)class_33242, (String)"server.playerManager");
            Iterator iterator = class_33242.method_14571().iterator();
            while (iterator.hasNext()) {
                class_3222 player;
                class_3222 class_32222 = player = (class_3222)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player");
                if (Intrinsics.areEqual((Object)class_32222.method_26281(), worldId)) {
                    player.method_26284(null, null, 0.0f, false, false);
                }
                GunpowderMod.Companion.getInstance().getLogger().info("Marking needsSync for player " + player);
                ((SyncPlayer)player).setNeedsSync(true);
                if (!Intrinsics.areEqual((Object)player.field_6002, (Object)world)) continue;
                TeleportRequest.Companion.builder((Function1<? super TeleportRequest.Builder, Unit>)((Function1)new Function1<TeleportRequest.Builder, Unit>(player){
                    final /* synthetic */ class_3222 $player;

                    public final void invoke(@NotNull TeleportRequest.Builder $this$builder) {
                        class_3218 sw;
                        T element$iv2;
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)$this$builder, (String)"$receiver");
                            Iterable iterable = DimensionManager.INSTANCE.getServer().method_3738();
                            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"server.getWorlds()");
                            Iterable $this$first$iv = iterable;
                            boolean $i$f$first = false;
                            for (T element$iv2 : $this$first$iv) {
                                class_3218 it = (class_3218)element$iv2;
                                boolean bl = false;
                                class_3218 class_32182 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"it");
                                if (!Intrinsics.areEqual((Object)class_32182.method_27983(), (Object)this.$player.method_26281())) continue;
                                break block2;
                            }
                            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        class_3218 class_32183 = sw = (class_3218)element$iv2;
                        Intrinsics.checkNotNullExpressionValue((Object)class_32183, (String)"sw");
                        $this$builder.dimension((class_1937)class_32183);
                        class_2338 class_23382 = this.$player.method_26280();
                        if (class_23382 == null) {
                            class_23382 = sw.method_27911();
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"player.spawnPointPosition ?: sw.spawnPos");
                        $this$builder.destination((class_2382)class_23382);
                        $this$builder.player(this.$player);
                    }
                    {
                        this.$player = class_32222;
                        super(1);
                    }
                })).execute(0L);
            }
        }
    }

    private DimensionManager() {
    }

    static {
        DimensionManager dimensionManager;
        INSTANCE = dimensionManager = new DimensionManager();
    }
}

