/*
 * Decompiled with CFR 0.152.
 */
package io.github.gunpowder.entities;

import io.github.gunpowder.api.GunpowderDatabase;
import io.github.gunpowder.api.GunpowderMod;
import io.github.gunpowder.configs.DatabaseConfig;
import io.github.gunpowder.configs.GunpowderConfig;
import io.github.gunpowder.entities.GunpowderDatabase;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ-\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\u001a\"\u0004\b\u0000\u0010!2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H!0\u0016\u00a2\u0006\u0002\b\u0019H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R7\u0010\u0013\u001a+\u0012'\u0012%\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\u0002\b\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001a0\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/github/gunpowder/entities/GunpowderDatabase;", "Lio/github/gunpowder/api/GunpowderDatabase;", "()V", "config", "Lio/github/gunpowder/configs/GunpowderConfig;", "getConfig", "()Lio/github/gunpowder/configs/GunpowderConfig;", "config$delegate", "Lkotlin/Lazy;", "databaseName", "", "databaseThread", "Ljava/lang/Thread;", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "setDb", "(Lorg/jetbrains/exposed/sql/Database;)V", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/Transaction;", "", "Lkotlin/ExtensionFunctionType;", "Ljava/util/concurrent/CompletableFuture;", "running", "", "disconnect", "", "loadDatabase", "transaction", "T", "callback", "gunpowder-base"})
public final class GunpowderDatabase
implements io.github.gunpowder.api.GunpowderDatabase {
    private static volatile boolean running;
    private static final ConcurrentLinkedQueue<Pair<Function1<Transaction, Object>, CompletableFuture<Object>>> queue;
    private static final Thread databaseThread;
    private static final Lazy config$delegate;
    public static Database db;
    private static final String databaseName;
    @NotNull
    public static final GunpowderDatabase INSTANCE;

    private final GunpowderConfig getConfig() {
        Lazy lazy = config$delegate;
        GunpowderDatabase gunpowderDatabase = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GunpowderConfig)lazy.getValue();
    }

    @Override
    @NotNull
    public Database getDb() {
        Database database = db;
        if (database == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        }
        return database;
    }

    public void setDb(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"<set-?>");
        db = database;
    }

    public final void disconnect() {
        running = false;
        databaseThread.join();
        try {
            TransactionManager.Companion.closeAndUnregister(this.getDb());
        }
        catch (UninitializedPropertyAccessException uninitializedPropertyAccessException) {
            // empty catch block
        }
    }

    public final void loadDatabase() {
        DatabaseConfig dbc = this.getConfig().getDatabase();
        String mode = dbc.getMode();
        if (GunpowderMod.Companion.getInstance().isClient()) {
            mode = "sqlite";
        }
        switch (mode) {
            case "sqlite": {
                FabricLoader fabricLoader = FabricLoader.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)fabricLoader, (String)"FabricLoader.getInstance()");
                File file = fabricLoader.getGameDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FabricLoader.getInstance().gameDirectory");
                String path = file.getCanonicalPath();
                this.setDb(Database.Companion.connect$default((Database.Companion)Database.Companion, (String)("jdbc:sqlite:" + path + "/gunpowder.db"), (String)"org.sqlite.JDBC", null, null, null, null, (int)60, null));
                TransactionManager.Companion.getManager().setDefaultIsolationLevel(8);
                break;
            }
            case "postgres": {
                this.setDb(Database.Companion.connect$default((Database.Companion)Database.Companion, (String)("jdbc:postgresql://" + dbc.getHost() + ':' + dbc.getPort() + '/' + databaseName), (String)"org.postgresql.Driver", (String)dbc.getUsername(), (String)dbc.getPassword(), null, null, (int)48, null));
                break;
            }
            case "mysql": {
                this.setDb(Database.Companion.connect$default((Database.Companion)Database.Companion, (String)("jdbc:mysql://" + dbc.getHost() + ':' + dbc.getPort() + '/' + databaseName), (String)"com.mysql.jdbc.Driver", (String)dbc.getUsername(), (String)dbc.getPassword(), null, null, (int)48, null));
                break;
            }
            default: {
                GunpowderMod.Companion.getInstance().getLogger().error("DB mode '" + mode + "' is invalid");
                throw (Throwable)((Object)new AssertionError((Object)"Invalid db type"));
            }
        }
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> transaction(@NotNull Function1<? super Transaction, ? extends T> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        CompletableFuture fut = new CompletableFuture();
        queue.add((Pair<Function1<Transaction, Object>, CompletableFuture<Object>>)new Pair((Object)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(callback2, (int)1)), fut));
        return fut;
    }

    private GunpowderDatabase() {
    }

    static {
        GunpowderDatabase gunpowderDatabase;
        INSTANCE = gunpowderDatabase = new GunpowderDatabase();
        running = true;
        queue = new ConcurrentLinkedQueue();
        databaseThread = ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)"Gunpowder Database Thread", (int)0, (Function0)databaseThread.1.INSTANCE, (int)22, null);
        config$delegate = LazyKt.lazy((Function0)config.2.INSTANCE);
        databaseName = "gunpowder";
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> transaction(@NotNull Consumer<Transaction> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        return GunpowderDatabase.DefaultImpls.transaction(this, callback2);
    }

    public static final /* synthetic */ boolean access$getRunning$p(GunpowderDatabase $this) {
        GunpowderDatabase gunpowderDatabase = $this;
        return running;
    }

    public static final /* synthetic */ void access$setRunning$p(GunpowderDatabase $this, boolean bl) {
        GunpowderDatabase gunpowderDatabase = $this;
        running = bl;
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getQueue$p(GunpowderDatabase $this) {
        GunpowderDatabase gunpowderDatabase = $this;
        return queue;
    }
}

