/*
 * Decompiled with CFR 0.152.
 */
package io.github.gunpowder.entities;

import com.google.gson.JsonParseException;
import io.github.gunpowder.api.GunpowderMod;
import io.github.gunpowder.api.LanguageUtil;
import io.github.gunpowder.entities.LanguageHandler$sam$java_util_function_BiConsumer$0;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2477;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000e\u001a\u00020\u0006J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0017R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0018"}, d2={"Lio/github/gunpowder/entities/LanguageHandler;", "Lio/github/gunpowder/api/LanguageUtil;", "()V", "languageSettings", "", "Ljava/util/UUID;", "", "getLanguageSettings", "()Ljava/util/Map;", "mapping", "", "modPath", "getModPath", "get", "lang", "languageForPlayer", "player", "Lnet/minecraft/server/network/ServerPlayerEntity;", "loadLanguage", "tryLoad", "", "id", "consumer", "Lkotlin/Function2;", "gunpowder-base"})
public final class LanguageHandler
implements LanguageUtil {
    @NotNull
    private static final Map<String, String> modPath;
    private static final Map<String, Map<String, String>> mapping;
    @NotNull
    private static final Map<UUID, String> languageSettings;
    @NotNull
    public static final LanguageHandler INSTANCE;

    @NotNull
    public final Map<String, String> getModPath() {
        return modPath;
    }

    @NotNull
    public final Map<UUID, String> getLanguageSettings() {
        return languageSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tryLoad(@NotNull String id, @NotNull String lang, @NotNull Function2<? super String, ? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        String path = modPath.getOrDefault(id, "/assets/" + id + "/lang");
        try {
            InputStream inputStream = class_2477.class.getResourceAsStream(path + '/' + lang + ".json");
            if (inputStream == null) {
                return;
            }
            InputStream inputStream2 = inputStream;
            Throwable prevErr = null;
            try {
                Function2<? super String, ? super String, Unit> function2 = consumer;
                class_2477.method_29425((InputStream)inputStream2, (BiConsumer)new LanguageHandler$sam$java_util_function_BiConsumer$0(function2));
            }
            catch (Throwable err) {
                try {
                    prevErr = err;
                    throw err;
                }
                catch (Throwable throwable) {
                    if (prevErr != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable err2) {
                            ExceptionsKt.addSuppressed((Throwable)prevErr, (Throwable)err2);
                        }
                    } else {
                        inputStream2.close();
                    }
                    throw throwable;
                }
            }
            inputStream2.close();
        }
        catch (JsonParseException err) {
            GunpowderMod.Companion.getInstance().getLogger().error("Couldn't read strings from /assets/" + id + "/lang/" + lang + ".json", (Throwable)err);
        }
        catch (IOException err) {
            GunpowderMod.Companion.getInstance().getLogger().error("Couldn't read strings from /assets/" + id + "/lang/" + lang + ".json", (Throwable)err);
        }
    }

    @NotNull
    public final Map<String, String> loadLanguage(@NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        boolean bl = false;
        Map map = new LinkedHashMap();
        FabricLoader fabricLoader = FabricLoader.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fabricLoader, (String)"FabricLoader.getInstance()");
        Collection collection = fabricLoader.getAllMods();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"FabricLoader.getInstance().allMods");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModContainer c = (ModContainer)element$iv;
            boolean bl2 = false;
            ModMetadata modMetadata = c.getMetadata();
            Intrinsics.checkNotNullExpressionValue((Object)modMetadata, (String)"c.metadata");
            String string = modMetadata.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.metadata.id");
            INSTANCE.tryLoad(string, lang, (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(map){

                public final void invoke(@NotNull String p1, @NotNull String p2) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    ((Map)this.receiver).put(p1, p2);
                }
            }));
        }
        Map<String, String> map2 = Collections.unmodifiableMap(map);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(map)");
        return map2;
    }

    @Override
    @NotNull
    public String languageForPlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uuid");
        return languageSettings.getOrDefault(uUID, "en_us");
    }

    @Override
    @NotNull
    public Map<String, String> get(@NotNull String lang) {
        Map<String, String> map;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Map<String, Map<String, String>> $this$getOrPut$iv = mapping;
        boolean $i$f$getOrPut = false;
        Map<String, String> value$iv = $this$getOrPut$iv.get(lang);
        if (value$iv == null) {
            boolean bl = false;
            Map<String, String> answer$iv = INSTANCE.loadLanguage(lang);
            $this$getOrPut$iv.put(lang, answer$iv);
            map = answer$iv;
        } else {
            map = value$iv;
        }
        return map;
    }

    private LanguageHandler() {
    }

    static {
        LanguageHandler languageHandler;
        INSTANCE = languageHandler = new LanguageHandler();
        boolean bl = false;
        modPath = new LinkedHashMap();
        bl = false;
        mapping = new LinkedHashMap();
        bl = false;
        languageSettings = new LinkedHashMap();
    }
}

