/*
 * Decompiled with CFR 0.152.
 */
package io.github.gunpowder.mod;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.github.gunpowder.api.GunpowderMod;
import io.github.gunpowder.api.GunpowderModule;
import io.github.gunpowder.entities.DimensionManager;
import io.github.gunpowder.entities.GunpowderDatabase;
import io.github.gunpowder.entities.GunpowderEvents;
import io.github.gunpowder.entities.GunpowderRegistry;
import io.github.gunpowder.entities.LanguageHandler;
import io.github.gunpowder.injection.AbstractModule;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020(H&J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020*R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006,"}, d2={"Lio/github/gunpowder/mod/AbstractGunpowderMod;", "Lio/github/gunpowder/api/GunpowderMod;", "()V", "database", "Lio/github/gunpowder/entities/GunpowderDatabase;", "getDatabase", "()Lio/github/gunpowder/entities/GunpowderDatabase;", "dimensionManager", "Lio/github/gunpowder/entities/DimensionManager;", "getDimensionManager", "()Lio/github/gunpowder/entities/DimensionManager;", "injector", "Lcom/google/inject/Injector;", "getInjector", "()Lcom/google/inject/Injector;", "languageEngine", "Lio/github/gunpowder/entities/LanguageHandler;", "getLanguageEngine", "()Lio/github/gunpowder/entities/LanguageHandler;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "module", "", "getModule", "()Ljava/lang/String;", "modules", "", "Lio/github/gunpowder/api/GunpowderModule;", "getModules", "()Ljava/util/List;", "setModules", "(Ljava/util/List;)V", "registry", "Lio/github/gunpowder/entities/GunpowderRegistry;", "getRegistry", "()Lio/github/gunpowder/entities/GunpowderRegistry;", "createModule", "Lio/github/gunpowder/injection/AbstractModule;", "initialize", "", "reload", "gunpowder-base"})
public abstract class AbstractGunpowderMod
implements GunpowderMod {
    @NotNull
    private final String module;
    private final Logger logger = LogManager.getLogger(GunpowderMod.class);
    @NotNull
    private final GunpowderRegistry registry = GunpowderRegistry.INSTANCE;
    @NotNull
    private final GunpowderDatabase database = GunpowderDatabase.INSTANCE;
    @NotNull
    private final DimensionManager dimensionManager = DimensionManager.INSTANCE;
    @NotNull
    private final LanguageHandler languageEngine = LanguageHandler.INSTANCE;
    @NotNull
    private final Injector injector;
    @NotNull
    private List<GunpowderModule> modules;

    @NotNull
    public final String getModule() {
        return this.module;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public GunpowderRegistry getRegistry() {
        return this.registry;
    }

    @Override
    @NotNull
    public GunpowderDatabase getDatabase() {
        return this.database;
    }

    @Override
    @NotNull
    public DimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    @Override
    @NotNull
    public LanguageHandler getLanguageEngine() {
        return this.languageEngine;
    }

    @NotNull
    public final Injector getInjector() {
        return this.injector;
    }

    @NotNull
    public final List<GunpowderModule> getModules() {
        return this.modules;
    }

    public final void setModules(@NotNull List<GunpowderModule> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.modules = list;
    }

    public final void reload() {
        Iterable $this$forEach$iv = this.modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GunpowderModule it = (GunpowderModule)element$iv;
            boolean bl = false;
            it.reload();
        }
    }

    public final void initialize() {
        EntrypointContainer it;
        List entrypoints;
        this.getLogger().info("Starting Gunpowder");
        GunpowderRegistry.INSTANCE.registerBuiltin();
        GunpowderDatabase.INSTANCE.loadDatabase();
        GunpowderEvents.INSTANCE.init();
        LanguageHandler.INSTANCE.get("en_us");
        this.getLogger().info("Loading modules");
        List list = entrypoints = FabricLoader.getInstance().getEntrypointContainers(this.module, GunpowderModule.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"entrypoints");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EntrypointContainer)element$iv;
            boolean bl = false;
            EntrypointContainer entrypointContainer = it;
            Intrinsics.checkNotNullExpressionValue((Object)entrypointContainer, (String)"it");
            ((GunpowderModule)entrypointContainer.getEntrypoint()).registerEvents();
        }
        $this$forEach$iv = entrypoints;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GunpowderModule module;
            it = (EntrypointContainer)element$iv;
            boolean bl = false;
            EntrypointContainer entrypointContainer = it;
            Intrinsics.checkNotNullExpressionValue((Object)entrypointContainer, (String)"it");
            GunpowderModule gunpowderModule = module = (GunpowderModule)entrypointContainer.getEntrypoint();
            Intrinsics.checkNotNullExpressionValue((Object)gunpowderModule, (String)"module");
            this.modules.add(gunpowderModule);
            Logger logger = this.getLogger();
            StringBuilder stringBuilder = new StringBuilder().append("Loaded module ").append(module.getName()).append(", provided by ");
            ModContainer modContainer = it.getProvider();
            Intrinsics.checkNotNullExpressionValue((Object)modContainer, (String)"it.provider");
            ModMetadata modMetadata = modContainer.getMetadata();
            Intrinsics.checkNotNullExpressionValue((Object)modMetadata, (String)"it.provider.metadata");
            logger.info(stringBuilder.append(modMetadata.getId()).toString());
            module.registerConfigs();
            module.registerCommands();
            module.onInitialize();
        }
    }

    @NotNull
    public abstract AbstractModule createModule();

    public AbstractGunpowderMod() {
        this.module = "gunpowder:modules";
        Injector injector = Guice.createInjector((Module[])new Module[]{(Module)this.createModule()});
        Intrinsics.checkNotNullExpressionValue((Object)injector, (String)"Guice.createInjector(this.createModule())");
        this.injector = injector;
        boolean bl = false;
        this.modules = new ArrayList();
    }
}

