/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.fabric_1_16_4;

import java.util.Arrays;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3508;
import net.minecraft.class_3532;
import net.minecraft.class_5298;
import org.dynmap.Log;
import org.dynmap.renderer.DynmapBlockState;

public class ChunkSnapshot {
    private final int x;
    private final int z;
    private final Section[] section;
    private final int[] hmap;
    private final int[] biome;
    private final long captureFulltime;
    private final int sectionCnt;
    private final long inhabitedTicks;
    private static final int BLOCKS_PER_SECTION = 4096;
    private static final int COLUMNS_PER_CHUNK = 256;
    private static final byte[] emptyData = new byte[2048];
    private static final byte[] fullData = new byte[2048];
    private static final EmptySection empty_section;

    public ChunkSnapshot(int worldheight, int x, int z, long captime, long inhabitedTime) {
        this.x = x;
        this.z = z;
        this.captureFulltime = captime;
        this.biome = new int[256];
        this.sectionCnt = worldheight / 16;
        this.section = new Section[this.sectionCnt];
        for (int i = 0; i < this.sectionCnt; ++i) {
            this.section[i] = empty_section;
        }
        this.hmap = new int[256];
        this.inhabitedTicks = inhabitedTime;
    }

    public ChunkSnapshot(class_2487 nbt, int worldheight) throws StateListException {
        block23: {
            int[] bb;
            this.x = nbt.method_10550("xPos");
            this.z = nbt.method_10550("zPos");
            this.captureFulltime = 0L;
            this.hmap = nbt.method_10561("HeightMap");
            this.sectionCnt = worldheight / 16;
            this.inhabitedTicks = nbt.method_10545("InhabitedTime") ? nbt.method_10537("InhabitedTime") : 0L;
            this.section = new Section[this.sectionCnt];
            for (int i = 0; i < this.sectionCnt; ++i) {
                this.section[i] = empty_section;
            }
            class_2499 sect = nbt.method_10554("Sections", 10);
            for (int i = 0; i < sect.size(); ++i) {
                class_2487 sec = sect.method_10602(i);
                byte secnum = sec.method_10571("Y");
                if (secnum >= this.sectionCnt || secnum < 0) continue;
                StdSection cursect = new StdSection();
                this.section[secnum] = cursect;
                DynmapBlockState[] states = cursect.states;
                DynmapBlockState[] palette = null;
                if (sec.method_10573("Palette", 9) && sec.method_10573("BlockStates", 12)) {
                    int j;
                    class_2499 plist = sec.method_10554("Palette", 10);
                    long[] statelist = sec.method_10565("BlockStates");
                    palette = new DynmapBlockState[plist.size()];
                    for (int pi = 0; pi < plist.size(); ++pi) {
                        class_2487 tc = plist.method_10602(pi);
                        String pname = tc.method_10558("Name");
                        if (tc.method_10545("Properties")) {
                            StringBuilder statestr = new StringBuilder();
                            class_2487 prop = tc.method_10562("Properties");
                            for (String pid : prop.method_10541()) {
                                if (statestr.length() > 0) {
                                    statestr.append(',');
                                }
                                statestr.append(pid).append('=').append(prop.method_10580(pid).method_10714());
                            }
                            palette[pi] = DynmapBlockState.getStateByNameAndState(pname, statestr.toString());
                        }
                        if (palette[pi] == null) {
                            palette[pi] = DynmapBlockState.getBaseStateByName(pname);
                        }
                        if (palette[pi] != null) continue;
                        palette[pi] = DynmapBlockState.AIR;
                    }
                    class_3508 db = null;
                    class_5298 dbp = null;
                    int bitsperblock = statelist.length * 64 / 4096;
                    int expectedStatelistLength = (4096 + 64 / bitsperblock - 1) / (64 / bitsperblock);
                    if (statelist.length == expectedStatelistLength) {
                        db = new class_3508(bitsperblock, 4096, statelist);
                    } else {
                        int expectedLegacyStatelistLength = class_3532.method_28139((int)(bitsperblock * 4096), (int)64) / 64;
                        if (statelist.length == expectedLegacyStatelistLength) {
                            dbp = new class_5298(bitsperblock, 4096, statelist);
                        } else {
                            throw new StateListException(this.x, this.z, statelist.length, expectedStatelistLength, expectedLegacyStatelistLength);
                        }
                    }
                    if (bitsperblock > 8) {
                        for (j = 0; j < 4096; ++j) {
                            int v = db != null ? db.method_15211(j) : dbp.method_28152(j);
                            states[j] = DynmapBlockState.getStateByGlobalIndex(v);
                        }
                    } else {
                        for (j = 0; j < 4096; ++j) {
                            int v = db != null ? db.method_15211(j) : dbp.method_28152(j);
                            states[j] = v < palette.length ? palette[v] : DynmapBlockState.AIR;
                        }
                    }
                }
                if (sec.method_10545("BlockLight")) {
                    cursect.emitlight = sec.method_10547("BlockLight");
                }
                if (!sec.method_10545("SkyLight")) continue;
                cursect.skylight = sec.method_10547("SkyLight");
            }
            this.biome = new int[256];
            if (!nbt.method_10545("Biomes") || (bb = nbt.method_10561("Biomes")) == null) break block23;
            if (bb.length > 256) {
                for (int i = 0; i < 256; ++i) {
                    int off = (i >> 4 & 0xC) + (i >> 2 & 3);
                    int bv = bb[off + 64];
                    if (bv < 0) {
                        bv = 0;
                    }
                    this.biome[i] = bv;
                }
            } else {
                for (int i = 0; i < bb.length; ++i) {
                    int bv = bb[i];
                    if (bv < 0) {
                        bv = 0;
                    }
                    this.biome[i] = bv;
                }
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public DynmapBlockState getBlockType(int x, int y, int z) {
        return this.section[y >> 4].getBlockType(x, y, z);
    }

    public int getBlockSkyLight(int x, int y, int z) {
        return this.section[y >> 4].getBlockSkyLight(x, y, z);
    }

    public int getBlockEmittedLight(int x, int y, int z) {
        return this.section[y >> 4].getBlockEmittedLight(x, y, z);
    }

    public int getHighestBlockYAt(int x, int z) {
        return this.hmap[z << 4 | x];
    }

    public int getBiome(int x, int z) {
        return this.biome[z << 4 | x];
    }

    public final long getCaptureFullTime() {
        return this.captureFulltime;
    }

    public boolean isSectionEmpty(int sy) {
        return this.section[sy].isEmpty();
    }

    public long getInhabitedTicks() {
        return this.inhabitedTicks;
    }

    static {
        Arrays.fill(fullData, (byte)-1);
        empty_section = new EmptySection();
    }

    public static class StateListException
    extends Exception {
        private static boolean loggedOnce = false;

        public StateListException(int x, int z, int actualLength, int expectedLength, int expectedLegacyLength) {
            if (Log.verbose || !loggedOnce) {
                loggedOnce = true;
                Log.info("Skipping chunk at x=" + x + ",z=" + z + ". Expected statelist of length " + expectedLength + " or " + expectedLegacyLength + " but got " + actualLength + ". This can happen if the chunk was not yet converted to the 1.16 format which can be fixed by visiting the chunk.");
                if (!Log.verbose) {
                    Log.info("You will only see this message once. Turn on verbose logging in the configuration to see all messages.");
                }
            }
        }
    }

    private static class StdSection
    implements Section {
        DynmapBlockState[] states = new DynmapBlockState[4096];
        byte[] skylight;
        byte[] emitlight;

        public StdSection() {
            Arrays.fill(this.states, DynmapBlockState.AIR);
            this.skylight = emptyData;
            this.emitlight = emptyData;
        }

        @Override
        public DynmapBlockState getBlockType(int x, int y, int z) {
            return this.states[(y & 0xF) << 8 | z << 4 | x];
        }

        @Override
        public int getBlockSkyLight(int x, int y, int z) {
            int off = (y & 0xF) << 7 | z << 3 | x >> 1;
            return this.skylight[off] >> 4 * (x & 1) & 0xF;
        }

        @Override
        public int getBlockEmittedLight(int x, int y, int z) {
            int off = (y & 0xF) << 7 | z << 3 | x >> 1;
            return this.emitlight[off] >> 4 * (x & 1) & 0xF;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static class EmptySection
    implements Section {
        private EmptySection() {
        }

        @Override
        public DynmapBlockState getBlockType(int x, int y, int z) {
            return DynmapBlockState.AIR;
        }

        @Override
        public int getBlockSkyLight(int x, int y, int z) {
            return 15;
        }

        @Override
        public int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    private static interface Section {
        public DynmapBlockState getBlockType(int var1, int var2, int var3);

        public int getBlockSkyLight(int var1, int var2, int var3);

        public int getBlockEmittedLight(int var1, int var2, int var3);

        public boolean isEmpty();
    }
}

