/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.fabric_1_16_4;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2361;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2535;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3614;
import net.minecraft.server.MinecraftServer;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.PlayerList;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.fabric_1_16_4.DynmapMod;
import org.dynmap.fabric_1_16_4.FabricCommandSender;
import org.dynmap.fabric_1_16_4.FabricMapChunkCache;
import org.dynmap.fabric_1_16_4.FabricPlayer;
import org.dynmap.fabric_1_16_4.FabricServer;
import org.dynmap.fabric_1_16_4.FabricWorld;
import org.dynmap.fabric_1_16_4.SnapshotCache;
import org.dynmap.fabric_1_16_4.VersionCheck;
import org.dynmap.fabric_1_16_4.command.DmapCommand;
import org.dynmap.fabric_1_16_4.command.DmarkerCommand;
import org.dynmap.fabric_1_16_4.command.DynmapCommand;
import org.dynmap.fabric_1_16_4.command.DynmapExpCommand;
import org.dynmap.fabric_1_16_4.event.BlockEvents;
import org.dynmap.fabric_1_16_4.event.ChunkDataEvents;
import org.dynmap.fabric_1_16_4.event.CustomServerLifecycleEvents;
import org.dynmap.fabric_1_16_4.event.PlayerEvents;
import org.dynmap.fabric_1_16_4.mixin.BiomeEffectsAccessor;
import org.dynmap.fabric_1_16_4.mixin.ThreadedAnvilChunkStorageAccessor;
import org.dynmap.fabric_1_16_4.permissions.FilePermissions;
import org.dynmap.fabric_1_16_4.permissions.OpPermissions;
import org.dynmap.fabric_1_16_4.permissions.PermissionProvider;
import org.dynmap.permissions.PermissionsHandler;
import org.dynmap.renderer.DynmapBlockState;

public class DynmapPlugin {
    DynmapCore core;
    private PermissionProvider permissions;
    private boolean core_enabled;
    public SnapshotCache sscache;
    public PlayerList playerList;
    MapManager mapManager;
    private MinecraftServer server;
    public static DynmapPlugin plugin;
    ChatHandler chathandler;
    private HashMap<String, Integer> sortWeights = new HashMap();
    private long worldIdleTimeoutNS = 30000000000L;
    private HashMap<String, FabricWorld> worlds = new HashMap();
    private class_1936 last_world;
    private FabricWorld last_fworld;
    private Map<String, FabricPlayer> players = new HashMap<String, FabricPlayer>();
    private HashSet<String> modsused = new HashSet();
    private FabricServer fserver;
    private boolean tickregistered = false;
    double tps;
    long lasttick;
    long avgticklen;
    long perTickLimit = 50000000L;
    private boolean useSaveFolder = true;
    private static final int SIGNPOST_ID = 63;
    private static final int WALLSIGN_ID = 68;
    private static final String[] TRIGGER_DEFAULTS;
    static final Pattern patternControlCode;
    ConcurrentLinkedQueue<BlockUpdateRec> blockupdatequeue = new ConcurrentLinkedQueue();
    public static DynmapBlockState[] stateByID;
    private Map<String, LongOpenHashSet> knownloadedchunks = new HashMap<String, LongOpenHashSet>();
    private boolean didInitialKnownChunks = false;
    ConcurrentLinkedQueue<ChatMessage> msgqueue = new ConcurrentLinkedQueue();
    private DynmapCommand dynmapCmd;
    private DmapCommand dmapCmd;
    private DmarkerCommand dmarkerCmd;
    private DynmapExpCommand dynmapexpCmd;
    private PlayerTracker playerTracker = null;
    private WorldTracker worldTracker = null;
    private boolean onblockchange = false;
    private boolean onchunkpopulate = false;
    private boolean onchunkgenerate = false;
    boolean onblockchange_with_id = false;

    DynmapPlugin() {
        plugin = this;
        ServerLifecycleEvents.SERVER_STARTING.register(this::serverStart);
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        CustomServerLifecycleEvents.SERVER_STARTED_PRE_WORLD_LOAD.register(this::serverStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::serverStop);
    }

    int getSortWeight(String name) {
        return this.sortWeights.getOrDefault(name, 0);
    }

    void setSortWeight(String name, int wt) {
        this.sortWeights.put(name, wt);
    }

    void dropSortWeight(String name) {
        this.sortWeights.remove(name);
    }

    private void addKnownChunk(FabricWorld fw, class_1923 pos) {
        LongOpenHashSet cset = this.knownloadedchunks.get(fw.getName());
        if (cset == null) {
            cset = new LongOpenHashSet();
            this.knownloadedchunks.put(fw.getName(), cset);
        }
        cset.add(pos.method_8324());
    }

    private void removeKnownChunk(FabricWorld fw, class_1923 pos) {
        LongOpenHashSet cset = this.knownloadedchunks.get(fw.getName());
        if (cset != null) {
            cset.remove(pos.method_8324());
        }
    }

    private boolean checkIfKnownChunk(FabricWorld fw, class_1923 pos) {
        LongOpenHashSet cset = this.knownloadedchunks.get(fw.getName());
        if (cset != null) {
            return cset.contains(pos.method_8324());
        }
        return false;
    }

    public void initializeBlockStates() {
        stateByID = new DynmapBlockState[16384];
        Arrays.fill(stateByID, DynmapBlockState.AIR);
        class_2361 bsids = class_2248.field_10651;
        DynmapBlockState basebs = null;
        class_2248 baseb = null;
        int baseidx = 0;
        for (class_2680 bs : bsids) {
            DynmapBlockState dbs;
            String bn;
            class_2960 ui;
            class_2248 b;
            int idx = bsids.method_10206((Object)bs);
            if (idx >= stateByID.length) {
                int plen = stateByID.length;
                stateByID = Arrays.copyOf(stateByID, idx + 1);
                Arrays.fill(stateByID, plen, stateByID.length, DynmapBlockState.AIR);
            }
            if ((b = bs.method_26204()) != baseb) {
                basebs = null;
                baseidx = idx;
                baseb = b;
            }
            if ((ui = class_2378.field_11146.method_10221((Object)b)) == null || (bn = ui.method_12836() + ":" + ui.method_12832()).equals(DynmapBlockState.AIR_BLOCK)) continue;
            class_3614 mat = bs.method_26207();
            String statename = "";
            for (class_2769 p : bs.method_28501()) {
                if (statename.length() > 0) {
                    statename = statename + ",";
                }
                statename = statename + p.method_11899() + "=" + bs.method_11654(p).toString();
            }
            DynmapPlugin.stateByID[idx] = dbs = new DynmapBlockState(basebs, idx - baseidx, bn, statename, mat.toString(), idx);
            if (basebs == null) {
                basebs = dbs;
            }
            if (mat.method_15799()) {
                dbs.setSolid();
            }
            if (mat == class_3614.field_15959) {
                dbs.setAir();
            }
            if (mat == class_3614.field_15932) {
                dbs.setLog();
            }
            if (mat == class_3614.field_15923) {
                dbs.setLeaves();
            }
            if (bs.method_26227().method_15769() || bs.method_26204() instanceof class_2404) continue;
            dbs.setWaterlogged();
        }
        for (int gidx = 0; gidx < DynmapBlockState.getGlobalIndexMax(); ++gidx) {
            DynmapBlockState dynmapBlockState = DynmapBlockState.getStateByGlobalIndex(gidx);
        }
    }

    public static final class_1792 getItemByID(int id) {
        return class_1792.method_7875((int)id);
    }

    public static final class_2535 getNetworkManager(class_3244 nh) {
        return nh.field_14127;
    }

    FabricPlayer getOrAddPlayer(class_3222 player) {
        String name = player.method_5477().getString();
        FabricPlayer fp = this.players.get(name);
        if (fp != null) {
            fp.player = player;
        } else {
            fp = new FabricPlayer(this, player);
            this.players.put(name, fp);
        }
        return fp;
    }

    public FabricServer getFabricServer() {
        return this.fserver;
    }

    private void serverStart(MinecraftServer server) {
        this.server = server;
        this.fserver = new FabricServer(this, server);
        this.onEnable();
    }

    private void serverStarted(MinecraftServer server) {
        this.onStart();
        if (this.core != null) {
            this.core.serverStarted();
        }
    }

    private void serverStop(MinecraftServer server) {
        this.onDisable();
        this.server = null;
    }

    public boolean isOp(String player) {
        String[] ops;
        for (String op : ops = this.server.method_3760().method_14603().method_14636()) {
            if (!op.equalsIgnoreCase(player)) continue;
            return true;
        }
        return this.server.method_3724() && player.equalsIgnoreCase(this.server.method_3811());
    }

    boolean hasPerm(class_1657 psender, String permission) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (psender != null && ph.hasPermission(psender.method_5477().getString(), permission)) {
            return true;
        }
        return this.permissions.has(psender, permission);
    }

    boolean hasPermNode(class_1657 psender, String permission) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (psender != null && ph.hasPermissionNode(psender.method_5477().getString(), permission)) {
            return true;
        }
        return this.permissions.hasPermissionNode(psender, permission);
    }

    Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        Set<String> rslt = null;
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null) {
            rslt = ph.hasOfflinePermissions(player, perms);
        }
        Set<String> rslt2 = this.hasOfflinePermissions(player, perms);
        if (rslt != null && rslt2 != null) {
            HashSet<String> newrslt = new HashSet<String>(rslt);
            newrslt.addAll(rslt2);
            rslt = newrslt;
        } else if (rslt2 != null) {
            rslt = rslt2;
        }
        return rslt;
    }

    boolean hasOfflinePermission(String player, String perm) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null && ph.hasOfflinePermission(player, perm)) {
            return true;
        }
        return this.permissions.hasOfflinePermission(player, perm);
    }

    void setChatHandler(ChatHandler chatHandler) {
        DynmapPlugin.plugin.chathandler = chatHandler;
    }

    public void loadExtraBiomes(String mcver) {
        int cnt = 0;
        BiomeMap.loadWellKnownByVersion(mcver);
        class_2378<class_1959> biomeRegistry = this.getFabricServer().getBiomeRegistry();
        class_1959[] list = this.getFabricServer().getBiomeList(biomeRegistry);
        for (int i = 0; i < list.length; ++i) {
            class_1959 bb = list[i];
            if (bb == null) continue;
            String id = biomeRegistry.method_10221((Object)bb).method_12832();
            float tmp = bb.method_8712();
            float hum = bb.method_8715();
            int watermult = ((BiomeEffectsAccessor)bb.method_24377()).getWaterColor();
            Log.verboseinfo("biome[" + i + "]: hum=" + hum + ", tmp=" + tmp + ", mult=" + Integer.toHexString(watermult));
            BiomeMap bmap = BiomeMap.byBiomeID(i);
            if (bmap.isDefault()) {
                bmap = new BiomeMap(i, id, tmp, hum);
                Log.verboseinfo("Add custom biome [" + bmap.toString() + "] (" + i + ")");
                ++cnt;
            } else {
                bmap.setTemperature(tmp);
                bmap.setRainfall(hum);
            }
            if (watermult == -1) continue;
            bmap.setWaterColorMultiplier(watermult);
            Log.verboseinfo("Set watercolormult for " + bmap.toString() + " (" + i + ") to " + Integer.toHexString(watermult));
        }
        if (cnt > 0) {
            Log.info("Added " + cnt + " custom biome mappings");
        }
    }

    private String[] getBiomeNames() {
        class_2378<class_1959> biomeRegistry = this.getFabricServer().getBiomeRegistry();
        class_1959[] list = this.getFabricServer().getBiomeList(biomeRegistry);
        String[] lst = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            class_1959 bb = list[i];
            if (bb == null) continue;
            lst[i] = biomeRegistry.method_10221((Object)bb).method_12832();
        }
        return lst;
    }

    public void onEnable() {
        File dataDirectory;
        String mcver = this.server.method_3827();
        this.loadExtraBiomes(mcver);
        this.registerPlayerLoginListener();
        this.permissions = FilePermissions.create();
        if (this.permissions == null) {
            this.permissions = new OpPermissions(new String[]{"webchat", "marker.icons", "marker.list", "webregister", "stats", "hide.self", "show.self"});
        }
        if (!(dataDirectory = new File("dynmap")).exists()) {
            dataDirectory.mkdirs();
        }
        if (this.core == null) {
            this.core = new DynmapCore();
        }
        this.core.setPluginJarFile(DynmapMod.jarfile);
        this.core.setPluginVersion(DynmapMod.ver);
        this.core.setMinecraftVersion(mcver);
        this.core.setDataFolder(dataDirectory);
        this.core.setServer(this.fserver);
        FabricMapChunkCache.init();
        this.core.setTriggerDefault(TRIGGER_DEFAULTS);
        this.core.setBiomeNames(this.getBiomeNames());
        if (!this.core.initConfiguration(null)) {
            return;
        }
        File filepermexample = new File(this.core.getDataFolder(), "permissions.yml.example");
        this.core.createDefaultFileFromResource("/permissions.yml.example", filepermexample);
        DynmapCommonAPIListener.apiInitialized(this.core);
    }

    public void registerCommands(CommandDispatcher<class_2168> cd) {
        this.dynmapCmd = new DynmapCommand(this);
        this.dmapCmd = new DmapCommand(this);
        this.dmarkerCmd = new DmarkerCommand(this);
        this.dynmapexpCmd = new DynmapExpCommand(this);
        this.dynmapCmd.register(cd);
        this.dmapCmd.register(cd);
        this.dmarkerCmd.register(cd);
        this.dynmapexpCmd.register(cd);
        Log.info("Register commands");
    }

    public void onStart() {
        this.initializeBlockStates();
        if (!this.core.enableCore(null)) {
            return;
        }
        this.core_enabled = true;
        VersionCheck.runCheck(this.core);
        this.perTickLimit = this.core.getMaxTickUseMS() * 1000000;
        this.lasttick = System.nanoTime();
        this.tps = 20.0;
        if (!this.tickregistered) {
            ServerTickEvents.END_SERVER_TICK.register(server -> this.fserver.tickEvent(server));
            this.tickregistered = true;
        }
        this.playerList = this.core.playerList;
        this.sscache = new SnapshotCache(this.core.getSnapShotCacheSize(), this.core.useSoftRefInSnapShotCache());
        this.mapManager = this.core.getMapManager();
        this.loadWorlds();
        if (this.server.method_3738() != null) {
            for (class_3218 world : this.server.method_3738()) {
                FabricWorld fabricWorld = this.getWorld((class_1937)world);
            }
        }
        for (FabricWorld w : this.worlds.values()) {
            if (!this.core.processWorldLoad(w) || !w.isLoaded()) continue;
            this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, w);
        }
        this.core.updateConfigHashcode();
        this.registerEvents();
        Log.info("Register events");
        Log.info("Enabled");
    }

    public void onDisable() {
        DynmapCommonAPIListener.apiTerminated();
        this.saveWorlds();
        this.fserver.clearTaskQueue();
        this.core.disableCore();
        this.core_enabled = false;
        if (this.sscache != null) {
            this.sscache.cleanup();
            this.sscache = null;
        }
        Log.info("Disabled");
    }

    public void handleCommand(class_2168 commandSource, String cmd, String[] args) throws CommandSyntaxException {
        class_3222 psender = null;
        if (commandSource.method_9228() instanceof class_3222) {
            psender = commandSource.method_9207();
        }
        FabricCommandSender dsender = psender != null ? new FabricPlayer(this, psender) : new FabricCommandSender(commandSource);
        this.core.processCommand(dsender, cmd, cmd, args);
    }

    private void registerPlayerLoginListener() {
        if (this.playerTracker == null) {
            this.playerTracker = new PlayerTracker();
            PlayerEvents.PLAYER_LOGGED_IN.register(player -> this.playerTracker.onPlayerLogin(player));
            PlayerEvents.PLAYER_LOGGED_OUT.register(player -> this.playerTracker.onPlayerLogout(player));
            PlayerEvents.PLAYER_CHANGED_DIMENSION.register(player -> this.playerTracker.onPlayerChangedDimension(player));
            PlayerEvents.PLAYER_RESPAWN.register(player -> this.playerTracker.onPlayerRespawn(player));
        }
    }

    private void registerEvents() {
        this.onblockchange = this.core.isTrigger("blockupdate");
        this.onchunkpopulate = this.core.isTrigger("chunkpopulate");
        this.onchunkgenerate = this.core.isTrigger("chunkgenerate");
        this.onblockchange_with_id = this.core.isTrigger("blockupdate-with-id");
        if (this.onblockchange_with_id) {
            this.onblockchange = true;
        }
        if (this.worldTracker == null && (this.onblockchange || this.onchunkpopulate || this.onchunkgenerate)) {
            this.worldTracker = new WorldTracker();
            ServerWorldEvents.LOAD.register((server, world) -> this.worldTracker.handleWorldLoad(server, world));
            ServerWorldEvents.UNLOAD.register((server, world) -> this.worldTracker.handleWorldUnload(server, world));
            ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> this.worldTracker.handleChunkLoad(world, chunk));
            ServerChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> this.worldTracker.handleChunkUnload(world, chunk));
            ChunkDataEvents.SAVE.register((world, chunk) -> this.worldTracker.handleChunkDataSave(world, chunk));
            BlockEvents.EVENT.register((world, pos) -> this.worldTracker.handleBlockEvent(world, pos));
        }
        if (this.onchunkgenerate && this.server.method_3738() != null) {
            for (class_3218 world2 : this.server.method_3738()) {
                FabricWorld fw = this.getWorld((class_1937)world2);
                if (fw == null) continue;
                Long2ObjectLinkedOpenHashMap<class_3193> chunks = ((ThreadedAnvilChunkStorageAccessor)world2.method_14178().field_17254).getChunkHolders();
                for (Map.Entry k : chunks.long2ObjectEntrySet()) {
                    long key = (Long)k.getKey();
                    class_3193 ch = (class_3193)k.getValue();
                    class_2791 c = null;
                    try {
                        c = ch.method_14000().getNow(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (c == null) continue;
                    class_2806 cs = c.method_12009();
                    class_1923 pos2 = ch.method_13994();
                    if (cs != class_2806.field_12803) continue;
                    this.addKnownChunk(fw, pos2);
                }
            }
        }
    }

    FabricWorld getWorldByName(String name) {
        return this.worlds.get(name);
    }

    FabricWorld getWorld(class_1937 w) {
        return this.getWorld(w, true);
    }

    private FabricWorld getWorld(class_1937 w, boolean add_if_not_found) {
        if (this.last_world == w) {
            return this.last_fworld;
        }
        String wname = FabricWorld.getWorldName(this, w);
        for (FabricWorld fw : this.worlds.values()) {
            if (!fw.getRawName().equals(wname)) continue;
            this.last_world = w;
            this.last_fworld = fw;
            if (!fw.isLoaded()) {
                fw.setWorldLoaded(w);
            }
            return fw;
        }
        FabricWorld fw = null;
        if (add_if_not_found) {
            fw = new FabricWorld(this, w);
            this.worlds.put(fw.getName(), fw);
        }
        this.last_world = w;
        this.last_fworld = fw;
        return fw;
    }

    private void saveWorlds() {
        File f = new File(this.core.getDataFolder(), "fabricworlds.yml");
        ConfigurationNode cn = new ConfigurationNode(f);
        ArrayList lst = new ArrayList();
        for (DynmapWorld fw : this.core.mapManager.getWorlds()) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("name", fw.getRawName());
            vals.put("height", fw.worldheight);
            vals.put("sealevel", fw.sealevel);
            vals.put("nether", fw.isNether());
            vals.put("the_end", ((FabricWorld)fw).isTheEnd());
            vals.put("title", fw.getTitle());
            lst.add(vals);
        }
        cn.put("worlds", (Object)lst);
        cn.put("useSaveFolderAsName", (Object)this.useSaveFolder);
        cn.put("maxWorldHeight", (Object)FabricWorld.getMaxWorldHeight());
        cn.save();
    }

    private void loadWorlds() {
        List<Map<String, Object>> lst;
        File f = new File(this.core.getDataFolder(), "fabricworlds.yml");
        if (!f.canRead()) {
            this.useSaveFolder = true;
            return;
        }
        ConfigurationNode cn = new ConfigurationNode(f);
        cn.load();
        FabricWorld.setMaxWorldHeight(cn.getInteger("maxWorldHeight", 256));
        if (cn.containsKey("useSaveFolderAsName")) {
            this.useSaveFolder = cn.getBoolean("useSaveFolderAsName", this.useSaveFolder);
        }
        if ((lst = cn.getMapList("worlds")) == null) {
            Log.warning(String.format("Discarding bad %s", "fabricworlds.yml"));
            return;
        }
        for (Map<String, Object> world : lst) {
            try {
                String name = (String)world.get("name");
                int height = (Integer)world.get("height");
                int sealevel = (Integer)world.get("sealevel");
                boolean nether = (Boolean)world.get("nether");
                boolean theend = (Boolean)world.get("the_end");
                String title = (String)world.get("title");
                if (name == null) continue;
                FabricWorld fw = new FabricWorld(this, name, height, sealevel, nether, theend, title);
                fw.setWorldUnloaded();
                this.core.processWorldLoad(fw);
                this.worlds.put(fw.getName(), fw);
            }
            catch (Exception x) {
                Log.warning(String.format("Unable to load saved worlds from %s", "fabricworlds.yml"));
                return;
            }
        }
    }

    static {
        TRIGGER_DEFAULTS = new String[]{"blockupdate", "chunkpopulate", "chunkgenerate"};
        patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    }

    public class WorldTracker {
        public void handleWorldLoad(MinecraftServer server, class_3218 world) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final FabricWorld fw = DynmapPlugin.this.getWorld((class_1937)world);
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    if (DynmapPlugin.this.core.processWorldLoad(fw)) {
                        DynmapPlugin.this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, fw);
                    }
                }
            }, 0L);
        }

        public void handleWorldUnload(MinecraftServer server, class_3218 world) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final FabricWorld fw = DynmapPlugin.this.getWorld((class_1937)world);
            if (fw != null) {
                DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                    @Override
                    public void run() {
                        DynmapPlugin.this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_UNLOAD, fw);
                        DynmapPlugin.this.core.processWorldUnload(fw);
                    }
                }, 0L);
                fw.setWorldUnloaded();
            }
        }

        public void handleChunkLoad(class_3218 world, class_2818 chunk) {
            FabricWorld fw;
            if (!DynmapPlugin.this.onchunkgenerate) {
                return;
            }
            if (chunk != null && chunk.method_12009() == class_2806.field_12803 && (fw = DynmapPlugin.this.getWorld((class_1937)world, false)) != null) {
                DynmapPlugin.this.addKnownChunk(fw, chunk.method_12004());
            }
        }

        public void handleChunkUnload(class_3218 world, class_2818 chunk) {
            if (!DynmapPlugin.this.onchunkgenerate) {
                return;
            }
            if (chunk != null && chunk.method_12009() == class_2806.field_12803) {
                FabricWorld fw = DynmapPlugin.this.getWorld((class_1937)world, false);
                class_1923 cp = chunk.method_12004();
                if (fw != null) {
                    if (!DynmapPlugin.this.checkIfKnownChunk(fw, cp)) {
                        int ymax = 0;
                        class_2826[] sections = chunk.method_12006();
                        for (int i = 0; i < sections.length; ++i) {
                            if (sections[i] == null || sections[i].method_12261()) continue;
                            ymax = 16 * (i + 1);
                        }
                        int x = cp.field_9181 << 4;
                        int z = cp.field_9180 << 4;
                        if (ymax > 0) {
                            Log.info("New generated chunk detected at " + cp + " for " + fw.getName());
                            DynmapPlugin.this.mapManager.touchVolume(fw.getName(), x, 0, z, x + 15, ymax, z + 16, "chunkgenerate");
                        }
                    }
                    DynmapPlugin.this.removeKnownChunk(fw, cp);
                }
            }
        }

        public void handleChunkDataSave(class_3218 world, class_2791 chunk) {
            if (!DynmapPlugin.this.onchunkgenerate) {
                return;
            }
            if (chunk != null && chunk.method_12009() == class_2806.field_12803) {
                FabricWorld fw = DynmapPlugin.this.getWorld((class_1937)world, false);
                class_1923 cp = chunk.method_12004();
                if (fw != null && !DynmapPlugin.this.checkIfKnownChunk(fw, cp)) {
                    int ymax = 0;
                    class_2826[] sections = chunk.method_12006();
                    for (int i = 0; i < sections.length; ++i) {
                        if (sections[i] == null || sections[i].method_12261()) continue;
                        ymax = 16 * (i + 1);
                    }
                    int x = cp.field_9181 << 4;
                    int z = cp.field_9180 << 4;
                    if (ymax > 0) {
                        DynmapPlugin.this.mapManager.touchVolume(fw.getName(), x, 0, z, x + 15, ymax, z + 16, "chunkgenerate");
                    }
                    DynmapPlugin.this.addKnownChunk(fw, cp);
                }
            }
        }

        public void handleBlockEvent(class_1937 world, class_2338 pos) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            if (!DynmapPlugin.this.onblockchange) {
                return;
            }
            if (!(world instanceof class_3218)) {
                return;
            }
            BlockUpdateRec r = new BlockUpdateRec();
            r.w = world;
            FabricWorld fw = DynmapPlugin.this.getWorld(world, false);
            if (fw == null) {
                return;
            }
            r.wid = fw.getName();
            r.x = pos.method_10263();
            r.y = pos.method_10264();
            r.z = pos.method_10260();
            DynmapPlugin.this.blockupdatequeue.add(r);
        }
    }

    public class PlayerTracker {
        public void onPlayerLogin(class_3222 player) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final FabricPlayer dp = DynmapPlugin.this.getOrAddPlayer(player);
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    DynmapPlugin.this.core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_JOIN, dp);
                }
            }, 2L);
        }

        public void onPlayerLogout(class_3222 player) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final FabricPlayer dp = DynmapPlugin.this.getOrAddPlayer(player);
            final String name = player.method_5477().getString();
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    DynmapPlugin.this.core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_QUIT, dp);
                    DynmapPlugin.this.players.remove(name);
                }
            }, 0L);
        }

        public void onPlayerChangedDimension(class_3222 player) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            DynmapPlugin.this.getOrAddPlayer(player);
        }

        public void onPlayerRespawn(class_3222 player) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            DynmapPlugin.this.getOrAddPlayer(player);
        }
    }

    public class ProfileTexture {
        public String url;
    }

    public class TexturesPayload {
        public long timestamp;
        public String profileId;
        public String profileName;
        public boolean isPublic;
        public Map<String, ProfileTexture> textures;
    }

    public static class ChatHandler {
        private final DynmapPlugin plugin;

        ChatHandler(DynmapPlugin plugin) {
            this.plugin = plugin;
        }

        public void handleChat(class_3222 player, String message) {
            if (!message.startsWith("/")) {
                ChatMessage cm = new ChatMessage();
                cm.message = message;
                cm.sender = player;
                this.plugin.msgqueue.add(cm);
            }
        }
    }

    static class ChatMessage {
        String message;
        class_3222 sender;

        ChatMessage() {
        }
    }

    public static class BlockUpdateRec {
        class_1936 w;
        String wid;
        int x;
        int y;
        int z;
    }
}

