/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.fabric_1_16_4;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2852;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.common.BiomeMap;
import org.dynmap.fabric_1_16_4.ChunkSnapshot;
import org.dynmap.fabric_1_16_4.DynmapPlugin;
import org.dynmap.fabric_1_16_4.FabricWorld;
import org.dynmap.fabric_1_16_4.SnapshotCache;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynIntHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.VisibilityLimit;

public class FabricMapChunkCache
extends MapChunkCache {
    private final DynmapPlugin plugin;
    private static boolean init = false;
    private static Field updateEntityTick = null;
    private static Field chunksToRemove = null;
    private static Field chunkCoord = null;
    private static Field nbtTag = null;
    private class_1937 w;
    private DynmapWorld dw;
    private class_3215 cps;
    private int nsect;
    private List<DynmapChunk> chunks;
    private ListIterator<DynmapChunk> iterator;
    private int x_min;
    private int x_max;
    private int z_min;
    private int z_max;
    private int x_dim;
    private boolean biome;
    private boolean biomeraw;
    private boolean highesty;
    private boolean blockdata;
    private MapChunkCache.HiddenChunkStyle hidestyle = MapChunkCache.HiddenChunkStyle.FILL_AIR;
    private List<VisibilityLimit> visible_limits = null;
    private List<VisibilityLimit> hidden_limits = null;
    private boolean isempty = true;
    private int snapcnt;
    private ChunkSnapshot[] snaparray;
    private DynIntHashMap[] snaptile;
    private byte[][] sameneighborbiomecnt;
    private BiomeMap[][] biomemap;
    private boolean[][] isSectionNotEmpty;
    private static final BlockStep[] unstep = new BlockStep[]{BlockStep.X_MINUS, BlockStep.Y_MINUS, BlockStep.Z_MINUS, BlockStep.X_PLUS, BlockStep.Y_PLUS, BlockStep.Z_PLUS};
    private BiomeMap[] biome_to_bmap;
    private static final EmptyChunk EMPTY = new EmptyChunk();
    private static final PlainChunk STONE = new PlainChunk(DynmapBlockState.STONE_BLOCK);
    private static final PlainChunk OCEAN = new PlainChunk(DynmapBlockState.WATER_BLOCK);
    private static boolean didError = false;

    private static final int getIndexInChunk(int cx, int cy, int cz) {
        return cy << 8 | cz << 4 | cx;
    }

    public FabricMapChunkCache(DynmapPlugin plugin) {
        int i;
        this.plugin = plugin;
        class_2378<class_1959> biomeRegistry = plugin.getFabricServer().getBiomeRegistry();
        class_1959[] b = plugin.getFabricServer().getBiomeList(biomeRegistry);
        BiomeMap[] bm = BiomeMap.values();
        this.biome_to_bmap = new BiomeMap[256];
        for (i = 0; i < this.biome_to_bmap.length; ++i) {
            this.biome_to_bmap[i] = BiomeMap.NULL;
        }
        block1: for (i = 0; i < b.length; ++i) {
            if (b[i] == null) continue;
            String bs = biomeRegistry.method_10221((Object)b[i]).toString();
            for (int j = 0; j < bm.length; ++j) {
                if (!bm[j].toString().equals(bs)) continue;
                this.biome_to_bmap[i] = bm[j];
                continue block1;
            }
        }
        FabricMapChunkCache.init();
    }

    public static void init() {
        if (!init) {
            int i;
            Field[] f = class_3215.class.getDeclaredFields();
            f = class_3218.class.getDeclaredFields();
            for (i = 0; i < f.length; ++i) {
                if (updateEntityTick != null || !f[i].getType().isAssignableFrom(Integer.TYPE)) continue;
                updateEntityTick = f[i];
                updateEntityTick.setAccessible(true);
            }
            f = class_2802.class.getDeclaredFields();
            for (i = 0; i < f.length; ++i) {
                if (chunksToRemove != null || !f[i].getType().equals(Map.class)) continue;
                chunksToRemove = f[i];
                chunksToRemove.setAccessible(true);
            }
            if (updateEntityTick == null) {
                Log.severe("ERROR: cannot find updateEntityTick - dynmap cannot drive entity cleanup when no players are active");
            }
            init = true;
        }
    }

    public void setChunks(FabricWorld dw, List<DynmapChunk> chunks) {
        this.dw = dw;
        this.w = dw.getWorld();
        if (dw.isLoaded()) {
            class_2802 cp = this.w.method_8398();
            if (cp instanceof class_3215) {
                this.cps = (class_3215)cp;
            } else {
                Log.severe("Error: world " + dw.getName() + " has unsupported chunk provider");
            }
        } else {
            chunks = new ArrayList<DynmapChunk>();
        }
        this.nsect = dw.worldheight >> 4;
        this.chunks = chunks;
        if (chunks.size() == 0) {
            this.x_min = 0;
            this.x_max = 0;
            this.z_min = 0;
            this.z_max = 0;
            this.x_dim = 1;
        } else {
            this.x_min = this.x_max = chunks.get((int)0).x;
            this.z_min = this.z_max = chunks.get((int)0).z;
            for (DynmapChunk c : chunks) {
                if (c.x > this.x_max) {
                    this.x_max = c.x;
                }
                if (c.x < this.x_min) {
                    this.x_min = c.x;
                }
                if (c.z > this.z_max) {
                    this.z_max = c.z;
                }
                if (c.z >= this.z_min) continue;
                this.z_min = c.z;
            }
            this.x_dim = this.x_max - this.x_min + 1;
        }
        this.snapcnt = this.x_dim * (this.z_max - this.z_min + 1);
        this.snaparray = new ChunkSnapshot[this.snapcnt];
        this.snaptile = new DynIntHashMap[this.snapcnt];
        this.isSectionNotEmpty = new boolean[this.snapcnt][];
    }

    public class_2487 readChunk(int x, int z) {
        try {
            class_3898 acl = this.cps.field_17254;
            class_1923 coord = new class_1923(x, z);
            class_2487 rslt = acl.method_23696(coord);
            if (rslt != null) {
                rslt = rslt.method_10562("Level");
                String stat = rslt.method_10558("Status");
                class_2806 cs = class_2806.method_12168((String)stat);
                if (stat == null || !cs.method_12165(class_2806.field_12805)) {
                    rslt = null;
                }
            }
            return rslt;
        }
        catch (Exception exc) {
            Log.severe(String.format("Error reading chunk: %s,%d,%d", this.dw.getName(), x, z), exc);
            return null;
        }
    }

    private Object getNBTValue(class_2520 v) {
        Object val = null;
        switch (v.method_10711()) {
            case 1: {
                val = ((class_2481)v).method_10698();
                break;
            }
            case 2: {
                val = ((class_2516)v).method_10696();
                break;
            }
            case 3: {
                val = ((class_2497)v).method_10701();
                break;
            }
            case 4: {
                val = ((class_2503)v).method_10699();
                break;
            }
            case 5: {
                val = Float.valueOf(((class_2494)v).method_10700());
                break;
            }
            case 6: {
                val = ((class_2489)v).method_10697();
                break;
            }
            case 7: {
                val = ((class_2479)v).method_10521();
                break;
            }
            case 8: {
                val = ((class_2519)v).method_10714();
                break;
            }
            case 9: {
                class_2499 tl = (class_2499)v;
                ArrayList<Object> vlist = new ArrayList<Object>();
                byte type = tl.method_10601();
                block20: for (int i = 0; i < tl.size(); ++i) {
                    switch (type) {
                        case 5: {
                            float fv = tl.method_10604(i);
                            vlist.add(Float.valueOf(fv));
                            continue block20;
                        }
                        case 6: {
                            double dv = tl.method_10611(i);
                            vlist.add(dv);
                            continue block20;
                        }
                        case 8: {
                            String sv = tl.method_10608(i);
                            vlist.add(sv);
                            continue block20;
                        }
                        case 10: {
                            class_2487 tc = tl.method_10602(i);
                            vlist.add(this.getNBTValue((class_2520)tc));
                            continue block20;
                        }
                        case 11: {
                            int[] ia = tl.method_10610(i);
                            vlist.add(ia);
                        }
                    }
                }
                val = vlist;
                break;
            }
            case 10: {
                class_2487 tc = (class_2487)v;
                HashMap<String, Object> vmap = new HashMap<String, Object>();
                for (Object t : tc.method_10541()) {
                    String st = (String)t;
                    class_2520 tg = tc.method_10580(st);
                    vmap.put(st, this.getNBTValue(tg));
                }
                val = vmap;
                break;
            }
            case 11: {
                val = ((class_2495)v).method_10588();
            }
        }
        return val;
    }

    private boolean isChunkVisible(DynmapChunk chunk) {
        boolean vis = true;
        if (this.visible_limits != null) {
            vis = false;
            for (VisibilityLimit limit : this.visible_limits) {
                if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                vis = true;
                break;
            }
        }
        if (vis && this.hidden_limits != null) {
            for (VisibilityLimit limit : this.hidden_limits) {
                if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                vis = false;
                break;
            }
        }
        return vis;
    }

    private boolean tryChunkCache(DynmapChunk chunk, boolean vis) {
        ChunkSnapshot ss = null;
        SnapshotCache.SnapshotRec ssr = DynmapPlugin.plugin.sscache.getSnapshot(this.dw.getName(), chunk.x, chunk.z, this.blockdata, this.biome, this.biomeraw, this.highesty);
        if (ssr != null) {
            ss = ssr.ss;
            if (!vis) {
                ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
            }
            int idx = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
            this.snaparray[idx] = ss;
            this.snaptile[idx] = ssr.tileData;
        }
        return ssr != null;
    }

    private SnapshotCache.SnapshotRec prepChunkSnapshot(DynmapChunk chunk, class_2487 nbt) throws ChunkSnapshot.StateListException {
        ChunkSnapshot ss = new ChunkSnapshot(nbt, this.dw.worldheight);
        DynIntHashMap tileData = new DynIntHashMap();
        class_2499 tiles = nbt.method_10554("TileEntities", 10);
        if (tiles == null) {
            tiles = new class_2499();
        }
        ArrayList<Object> vals = new ArrayList<Object>();
        for (int tid = 0; tid < tiles.size(); ++tid) {
            int tz;
            int cz;
            int ty;
            class_2487 tc = tiles.method_10602(tid);
            int tx = tc.method_10550("x");
            int cx = tx & 0xF;
            DynmapBlockState blk = ss.getBlockType(cx, ty = tc.method_10550("y"), cz = (tz = tc.method_10550("z")) & 0xF);
            String[] te_fields = HDBlockModels.getTileEntityFieldsNeeded(blk);
            if (te_fields == null) continue;
            vals.clear();
            for (String id : te_fields) {
                Object val;
                class_2520 v = tc.method_10580(id);
                if (v == null || (val = this.getNBTValue(v)) == null) continue;
                vals.add(id);
                vals.add(val);
            }
            if (vals.size() <= 0) continue;
            Object[] vlist = vals.toArray(new Object[vals.size()]);
            tileData.put(FabricMapChunkCache.getIndexInChunk(cx, ty, cz), vlist);
        }
        SnapshotCache.SnapshotRec ssr = new SnapshotCache.SnapshotRec();
        ssr.ss = ss;
        ssr.tileData = tileData;
        DynmapPlugin.plugin.sscache.putSnapshot(this.dw.getName(), chunk.x, chunk.z, ssr, this.blockdata, this.biome, this.biomeraw, this.highesty);
        return ssr;
    }

    public int getLoadedChunks() {
        int cnt = 0;
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return 0;
        }
        ListIterator<DynmapChunk> iter = this.chunks.listIterator();
        while (iter.hasNext()) {
            DynIntHashMap tileData;
            ChunkSnapshot ss;
            long startTime;
            block9: {
                startTime = System.nanoTime();
                DynmapChunk chunk = iter.next();
                int chunkindex = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
                if (this.snaparray[chunkindex] != null) continue;
                boolean vis = this.isChunkVisible(chunk);
                if (this.tryChunkCache(chunk, vis)) {
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
                    ++cnt;
                    continue;
                }
                if (!this.cps.method_12123(chunk.x, chunk.z)) continue;
                if (vis) {
                    class_2487 nbt = null;
                    try {
                        nbt = class_2852.method_12410((class_3218)((class_3218)this.w), (class_2791)this.cps.method_12126(chunk.x, chunk.z, false));
                    }
                    catch (NullPointerException e) {
                        Log.severe("ChunkSerializer.serialize threw a NullPointerException", e);
                        continue;
                    }
                    if (nbt != null) {
                        nbt = nbt.method_10562("Level");
                    }
                    try {
                        SnapshotCache.SnapshotRec ssr = this.prepChunkSnapshot(chunk, nbt);
                        ss = ssr.ss;
                        tileData = ssr.tileData;
                        break block9;
                    }
                    catch (ChunkSnapshot.StateListException e) {
                        continue;
                    }
                }
                ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                tileData = new DynIntHashMap();
            }
            this.snaparray[chunkindex] = ss;
            this.snaptile[chunkindex] = tileData;
            this.endChunkLoad(startTime, MapChunkCache.ChunkStats.LOADED_CHUNKS);
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int loadChunks(int max_to_load) {
        return this.getLoadedChunks() + this.readChunks(max_to_load);
    }

    public int readChunks(int max_to_load) {
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return 0;
        }
        int cnt = 0;
        if (this.iterator == null) {
            this.iterator = this.chunks.listIterator();
        }
        DynmapCore.setIgnoreChunkLoads(true);
        while (cnt < max_to_load && this.iterator.hasNext()) {
            long startTime = System.nanoTime();
            DynmapChunk chunk = this.iterator.next();
            int chunkindex = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
            if (this.snaparray[chunkindex] != null) continue;
            boolean vis = this.isChunkVisible(chunk);
            if (this.tryChunkCache(chunk, vis)) {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
            } else {
                class_2487 nbt = this.readChunk(chunk.x, chunk.z);
                if (nbt != null) {
                    DynIntHashMap tileData;
                    ChunkSnapshot ss;
                    if (!vis) {
                        ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                        tileData = new DynIntHashMap();
                    } else {
                        try {
                            SnapshotCache.SnapshotRec ssr = this.prepChunkSnapshot(chunk, nbt);
                            ss = ssr.ss;
                            tileData = ssr.tileData;
                        }
                        catch (ChunkSnapshot.StateListException e) {
                            continue;
                        }
                    }
                    this.snaparray[chunkindex] = ss;
                    this.snaptile[chunkindex] = tileData;
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNLOADED_CHUNKS);
                } else {
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNGENERATED_CHUNKS);
                }
            }
            ++cnt;
        }
        DynmapCore.setIgnoreChunkLoads(false);
        if (!this.iterator.hasNext()) {
            this.isempty = true;
            for (int i = 0; i < this.snaparray.length; ++i) {
                if (this.snaparray[i] == null) {
                    this.snaparray[i] = EMPTY;
                    continue;
                }
                if (this.snaparray[i] == EMPTY) continue;
                this.isempty = false;
            }
        }
        return cnt;
    }

    @Override
    public boolean isDoneLoading() {
        if (!this.dw.isLoaded()) {
            return true;
        }
        if (this.iterator != null) {
            return !this.iterator.hasNext();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.isempty;
    }

    @Override
    public void unloadChunks() {
        if (this.snaparray != null) {
            for (int i = 0; i < this.snaparray.length; ++i) {
                this.snaparray[i] = null;
            }
            this.snaparray = null;
        }
    }

    private void initSectionData(int idx) {
        this.isSectionNotEmpty[idx] = new boolean[this.nsect + 1];
        if (this.snaparray[idx] != EMPTY) {
            for (int i = 0; i < this.nsect; ++i) {
                if (this.snaparray[idx].isSectionEmpty(i)) continue;
                this.isSectionNotEmpty[idx][i] = true;
            }
        }
    }

    @Override
    public boolean isEmptySection(int sx, int sy, int sz) {
        int idx = sx - this.x_min + (sz - this.z_min) * this.x_dim;
        if (this.isSectionNotEmpty[idx] == null) {
            this.initSectionData(idx);
        }
        return !this.isSectionNotEmpty[idx][sy];
    }

    @Override
    public MapIterator getIterator(int x, int y, int z) {
        if (this.dw.getEnvironment().equals("the_end")) {
            return new OurEndMapIterator(x, y, z);
        }
        return new OurMapIterator(x, y, z);
    }

    @Override
    public void setHiddenFillStyle(MapChunkCache.HiddenChunkStyle style) {
        this.hidestyle = style;
    }

    @Override
    public void setVisibleRange(VisibilityLimit lim) {
        if (this.visible_limits == null) {
            this.visible_limits = new ArrayList<VisibilityLimit>();
        }
        this.visible_limits.add(lim);
    }

    @Override
    public void setHiddenRange(VisibilityLimit lim) {
        if (this.hidden_limits == null) {
            this.hidden_limits = new ArrayList<VisibilityLimit>();
        }
        this.hidden_limits.add(lim);
    }

    @Override
    public boolean setChunkDataTypes(boolean blockdata, boolean biome, boolean highestblocky, boolean rawbiome) {
        this.biome = biome;
        this.biomeraw = rawbiome;
        this.highesty = highestblocky;
        this.blockdata = blockdata;
        return true;
    }

    @Override
    public DynmapWorld getWorld() {
        return this.dw;
    }

    static /* synthetic */ byte[][] access$802(FabricMapChunkCache x0, byte[][] x1) {
        x0.sameneighborbiomecnt = x1;
        return x1;
    }

    static /* synthetic */ BiomeMap[][] access$1002(FabricMapChunkCache x0, BiomeMap[][] x1) {
        x0.biomemap = x1;
        return x1;
    }

    private static class PlainChunk
    extends ChunkSnapshot {
        private DynmapBlockState fill;

        PlainChunk(String fill) {
            super(256, 0, 0, 0L, 0L);
            this.fill = DynmapBlockState.getBaseStateByName(fill);
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getZ() {
            return 0;
        }

        @Override
        public int getBiome(int x, int z) {
            return -1;
        }

        @Override
        public final DynmapBlockState getBlockType(int x, int y, int z) {
            if (y < 64) {
                return this.fill;
            }
            return DynmapBlockState.AIR;
        }

        @Override
        public final int getBlockSkyLight(int x, int y, int z) {
            if (y < 64) {
                return 0;
            }
            return 15;
        }

        @Override
        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getHighestBlockYAt(int x, int z) {
            return 64;
        }

        @Override
        public boolean isSectionEmpty(int sy) {
            return sy < 4;
        }
    }

    private static class EmptyChunk
    extends ChunkSnapshot {
        public EmptyChunk() {
            super(256, 0, 0, 0L, 0L);
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getZ() {
            return 0;
        }

        @Override
        public final DynmapBlockState getBlockType(int x, int y, int z) {
            return DynmapBlockState.AIR;
        }

        @Override
        public final int getBlockSkyLight(int x, int y, int z) {
            return 15;
        }

        @Override
        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getHighestBlockYAt(int x, int z) {
            return 0;
        }

        @Override
        public int getBiome(int x, int z) {
            return -1;
        }

        @Override
        public boolean isSectionEmpty(int sy) {
            return true;
        }
    }

    private class OurEndMapIterator
    extends OurMapIterator {
        OurEndMapIterator(int x0, int y0, int z0) {
            super(x0, y0, z0);
        }

        @Override
        public final int getBlockSkyLight() {
            return 15;
        }
    }

    public class OurMapIterator
    implements MapIterator {
        private int x;
        private int y;
        private int z;
        private int chunkindex;
        private int bx;
        private int bz;
        private ChunkSnapshot snap;
        private BlockStep laststep;
        private DynmapBlockState blk;
        private final int worldheight;
        private final int x_base;
        private final int z_base;

        OurMapIterator(int x0, int y0, int z0) {
            this.x_base = FabricMapChunkCache.this.x_min << 4;
            this.z_base = FabricMapChunkCache.this.z_min << 4;
            if (FabricMapChunkCache.this.biome) {
                this.biomePrep();
            }
            this.initialize(x0, y0, z0);
            this.worldheight = FabricMapChunkCache.this.w.method_8322();
        }

        @Override
        public final void initialize(int x0, int y0, int z0) {
            this.x = x0;
            this.y = y0;
            this.z = z0;
            this.chunkindex = (this.x >> 4) - FabricMapChunkCache.this.x_min + ((this.z >> 4) - FabricMapChunkCache.this.z_min) * FabricMapChunkCache.this.x_dim;
            this.bx = this.x & 0xF;
            this.bz = this.z & 0xF;
            this.snap = this.chunkindex >= FabricMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : FabricMapChunkCache.this.snaparray[this.chunkindex];
            this.laststep = BlockStep.Y_MINUS;
            this.blk = this.y >= 0 && this.y < this.worldheight ? null : DynmapBlockState.AIR;
        }

        @Override
        public int getBlockSkyLight() {
            try {
                return this.snap.getBlockSkyLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 15;
            }
        }

        @Override
        public final int getBlockEmittedLight() {
            try {
                return this.snap.getBlockEmittedLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 0;
            }
        }

        private void biomePrep() {
            int i;
            if (FabricMapChunkCache.this.sameneighborbiomecnt != null) {
                return;
            }
            int x_size = FabricMapChunkCache.this.x_dim << 4;
            int z_size = FabricMapChunkCache.this.z_max - FabricMapChunkCache.this.z_min + 1 << 4;
            FabricMapChunkCache.access$802(FabricMapChunkCache.this, new byte[x_size][]);
            FabricMapChunkCache.access$1002(FabricMapChunkCache.this, new BiomeMap[x_size][]);
            for (i = 0; i < x_size; ++i) {
                ((FabricMapChunkCache)FabricMapChunkCache.this).sameneighborbiomecnt[i] = new byte[z_size];
                ((FabricMapChunkCache)FabricMapChunkCache.this).biomemap[i] = new BiomeMap[z_size];
            }
            for (i = 0; i < x_size; ++i) {
                for (int j = 0; j < z_size; ++j) {
                    BiomeMap bm;
                    if (j == 0) {
                        this.initialize(i + this.x_base, 64, this.z_base);
                    } else {
                        this.stepPosition(BlockStep.Z_PLUS);
                    }
                    int bb = this.snap.getBiome(this.bx, this.bz);
                    ((FabricMapChunkCache)FabricMapChunkCache.this).biomemap[i][j] = bm = BiomeMap.byBiomeID(bb);
                    int cnt = 0;
                    if (i > 0) {
                        if (bm == FabricMapChunkCache.this.biomemap[i - 1][j]) {
                            ++cnt;
                            byte[] byArray = FabricMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j > 0 && bm == FabricMapChunkCache.this.biomemap[i - 1][j - 1]) {
                            ++cnt;
                            byte[] byArray = FabricMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j - 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j < z_size - 1 && bm == FabricMapChunkCache.this.biomemap[i - 1][j + 1]) {
                            ++cnt;
                            byte[] byArray = FabricMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j + 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                    }
                    if (j > 0 && FabricMapChunkCache.this.biomemap[i][j] == FabricMapChunkCache.this.biomemap[i][j - 1]) {
                        ++cnt;
                        byte[] byArray = FabricMapChunkCache.this.sameneighborbiomecnt[i];
                        int n = j - 1;
                        byArray[n] = (byte)(byArray[n] + 1);
                    }
                    ((FabricMapChunkCache)FabricMapChunkCache.this).sameneighborbiomecnt[i][j] = (byte)cnt;
                }
            }
        }

        @Override
        public final BiomeMap getBiome() {
            try {
                return FabricMapChunkCache.this.biomemap[this.x - this.x_base][this.z - this.z_base];
            }
            catch (Exception ex) {
                return BiomeMap.NULL;
            }
        }

        @Override
        public final int getSmoothGrassColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = FabricMapChunkCache.this.biomemap[rx][rz];
                if (FabricMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = FabricMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothFoliageColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = FabricMapChunkCache.this.biomemap[rx][rz];
                if (FabricMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = FabricMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothColorMultiplier(int[] colormap, int[] swampmap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = FabricMapChunkCache.this.biomemap[rx][rz];
                if (FabricMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = FabricMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothWaterColorMultiplier() {
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = FabricMapChunkCache.this.biomemap[rx][rz];
                if (FabricMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    return bm.getWaterColorMult();
                }
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                for (int xoff = -1; xoff < 2; ++xoff) {
                    for (int zoff = -1; zoff < 2; ++zoff) {
                        bm = FabricMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                        int mult = bm.getWaterColorMult();
                        raccum += mult >> 16 & 0xFF;
                        gaccum += mult >> 8 & 0xFF;
                        baccum += mult & 0xFF;
                    }
                }
                return raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
            }
            catch (Exception x) {
                return 0xFFFFFF;
            }
        }

        @Override
        public final int getSmoothWaterColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = FabricMapChunkCache.this.biomemap[rx][rz];
                if (FabricMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = FabricMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final void stepPosition(BlockStep step) {
            this.blk = null;
            switch (step.ordinal()) {
                case 0: {
                    ++this.x;
                    ++this.bx;
                    if (this.bx != 16) break;
                    this.bx = 0;
                    ++this.chunkindex;
                    if (this.chunkindex >= FabricMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = FabricMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 1: {
                    ++this.y;
                    if (this.y < this.worldheight) break;
                    this.blk = DynmapBlockState.AIR;
                    break;
                }
                case 2: {
                    ++this.z;
                    ++this.bz;
                    if (this.bz != 16) break;
                    this.bz = 0;
                    this.chunkindex += FabricMapChunkCache.this.x_dim;
                    if (this.chunkindex >= FabricMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = FabricMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 3: {
                    --this.x;
                    --this.bx;
                    if (this.bx != -1) break;
                    this.bx = 15;
                    --this.chunkindex;
                    if (this.chunkindex >= FabricMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = FabricMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 4: {
                    --this.y;
                    if (this.y >= 0) break;
                    this.blk = DynmapBlockState.AIR;
                    break;
                }
                case 5: {
                    --this.z;
                    --this.bz;
                    if (this.bz != -1) break;
                    this.bz = 15;
                    this.chunkindex -= FabricMapChunkCache.this.x_dim;
                    this.snap = this.chunkindex >= FabricMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : FabricMapChunkCache.this.snaparray[this.chunkindex];
                }
            }
            this.laststep = step;
        }

        @Override
        public BlockStep unstepPosition() {
            BlockStep ls = this.laststep;
            this.stepPosition(unstep[ls.ordinal()]);
            return ls;
        }

        @Override
        public void unstepPosition(BlockStep s) {
            this.stepPosition(unstep[s.ordinal()]);
        }

        @Override
        public final void setY(int y) {
            this.laststep = y > this.y ? BlockStep.Y_PLUS : BlockStep.Y_MINUS;
            this.y = y;
            this.blk = y < 0 || y >= this.worldheight ? DynmapBlockState.AIR : null;
        }

        @Override
        public final int getX() {
            return this.x;
        }

        @Override
        public final int getY() {
            return this.y;
        }

        @Override
        public final int getZ() {
            return this.z;
        }

        @Override
        public final DynmapBlockState getBlockTypeAt(BlockStep s) {
            if (s == BlockStep.Y_MINUS) {
                if (this.y > 0) {
                    return this.snap.getBlockType(this.bx, this.y - 1, this.bz);
                }
            } else if (s == BlockStep.Y_PLUS) {
                if (this.y < this.worldheight - 1) {
                    return this.snap.getBlockType(this.bx, this.y + 1, this.bz);
                }
            } else {
                BlockStep ls = this.laststep;
                this.stepPosition(s);
                DynmapBlockState tid = this.snap.getBlockType(this.bx, this.y, this.bz);
                this.unstepPosition();
                this.laststep = ls;
                return tid;
            }
            return DynmapBlockState.AIR;
        }

        @Override
        public BlockStep getLastStep() {
            return this.laststep;
        }

        @Override
        public int getWorldHeight() {
            return this.worldheight;
        }

        @Override
        public long getBlockKey() {
            return this.chunkindex * this.worldheight + this.y << 8 | this.bx << 4 | this.bz;
        }

        @Override
        public final boolean isEmptySection() {
            try {
                return !FabricMapChunkCache.this.isSectionNotEmpty[this.chunkindex][this.y >> 4];
            }
            catch (Exception x) {
                FabricMapChunkCache.this.initSectionData(this.chunkindex);
                return !FabricMapChunkCache.this.isSectionNotEmpty[this.chunkindex][this.y >> 4];
            }
        }

        @Override
        public RenderPatchFactory getPatchFactory() {
            return HDBlockModels.getPatchDefinitionFactory();
        }

        @Override
        public Object getBlockTileEntityField(String fieldId) {
            try {
                int idx = FabricMapChunkCache.getIndexInChunk(this.bx, this.y, this.bz);
                Object[] vals = (Object[])FabricMapChunkCache.this.snaptile[this.chunkindex].get(idx);
                for (int i = 0; i < vals.length; i += 2) {
                    if (!vals[i].equals(fieldId)) continue;
                    return vals[i + 1];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public DynmapBlockState getBlockTypeAt(int xoff, int yoff, int zoff) {
            int xx = this.x + xoff;
            int yy = this.y + yoff;
            int zz = this.z + zoff;
            int idx = (xx >> 4) - FabricMapChunkCache.this.x_min + ((zz >> 4) - FabricMapChunkCache.this.z_min) * FabricMapChunkCache.this.x_dim;
            try {
                return FabricMapChunkCache.this.snaparray[idx].getBlockType(xx & 0xF, yy, zz & 0xF);
            }
            catch (Exception x) {
                return DynmapBlockState.AIR;
            }
        }

        @Override
        public Object getBlockTileEntityFieldAt(String fieldId, int xoff, int yoff, int zoff) {
            return null;
        }

        @Override
        public long getInhabitedTicks() {
            try {
                return this.snap.getInhabitedTicks();
            }
            catch (Exception x) {
                return 0L;
            }
        }

        @Override
        public DynmapBlockState getBlockType() {
            if (this.blk == null) {
                this.blk = this.snap.getBlockType(this.bx, this.y, this.bz);
            }
            return this.blk;
        }
    }
}

