/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.fabric_1_16_4;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2762;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.apache.commons.codec.binary.Base64;
import org.dynmap.DynmapLocation;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.fabric_1_16_4.DynmapPlugin;
import org.dynmap.fabric_1_16_4.FabricAdapter;
import org.dynmap.fabric_1_16_4.FabricCommandSender;

public class FabricPlayer
extends FabricCommandSender
implements DynmapPlayer {
    private static final Gson GSON = new GsonBuilder().create();
    private final DynmapPlugin plugin;
    class_3222 player;
    private final String skinurl;
    private final UUID uuid;

    public FabricPlayer(DynmapPlugin plugin, class_3222 player) {
        this.plugin = plugin;
        this.player = player;
        String url = null;
        if (this.player != null) {
            Property textureProperty;
            this.uuid = this.player.method_5667();
            GameProfile prof = this.player.method_7334();
            if (prof != null && (textureProperty = (Property)Iterables.getFirst((Iterable)prof.getProperties().get((Object)"textures"), null)) != null) {
                DynmapPlugin.TexturesPayload result = null;
                try {
                    String json = new String(Base64.decodeBase64((String)textureProperty.getValue()), StandardCharsets.UTF_8);
                    result = (DynmapPlugin.TexturesPayload)GSON.fromJson(json, DynmapPlugin.TexturesPayload.class);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
                if (result != null && result.textures != null && result.textures.containsKey("SKIN")) {
                    url = result.textures.get((Object)"SKIN").url;
                }
            }
        } else {
            this.uuid = null;
        }
        this.skinurl = url;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public String getName() {
        if (this.player != null) {
            String n = this.player.method_5477().getString();
            return n;
        }
        return "[Server]";
    }

    @Override
    public String getDisplayName() {
        if (this.player != null) {
            String n = this.player.method_5476().getString();
            return n;
        }
        return "[Server]";
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public DynmapLocation getLocation() {
        if (this.player == null) {
            return null;
        }
        class_243 pos = this.player.method_19538();
        return FabricAdapter.toDynmapLocation(this.plugin, this.player.method_14220(), pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    @Override
    public String getWorld() {
        if (this.player == null) {
            return null;
        }
        if (this.player.field_6002 != null) {
            return this.plugin.getWorld(this.player.field_6002).getName();
        }
        return null;
    }

    @Override
    public InetSocketAddress getAddress() {
        SocketAddress sa;
        class_3244 networkHandler;
        if (this.player != null && (networkHandler = this.player.field_13987) != null && networkHandler.method_2872() != null && (sa = networkHandler.method_2872().method_10755()) instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    @Override
    public boolean isSneaking() {
        if (this.player != null) {
            return this.player.method_5715();
        }
        return false;
    }

    @Override
    public double getHealth() {
        if (this.player != null) {
            double h = this.player.method_6032();
            if (h > 20.0) {
                h = 20.0;
            }
            return h;
        }
        return 0.0;
    }

    @Override
    public int getArmorPoints() {
        if (this.player != null) {
            return this.player.method_6096();
        }
        return 0;
    }

    @Override
    public DynmapLocation getBedSpawnLocation() {
        return null;
    }

    @Override
    public long getLastLoginTime() {
        return 0L;
    }

    @Override
    public long getFirstLoginTime() {
        return 0L;
    }

    @Override
    public boolean hasPrivilege(String privid) {
        if (this.player != null) {
            return this.plugin.hasPerm((class_1657)this.player, privid);
        }
        return false;
    }

    @Override
    public boolean isOp() {
        return this.plugin.isOp(this.player.method_5477().getString());
    }

    @Override
    public void sendMessage(String msg) {
        class_2585 ichatcomponent = new class_2585(msg);
        this.player.method_9203((class_2561)ichatcomponent, class_156.field_25140);
    }

    @Override
    public boolean isInvisible() {
        if (this.player != null) {
            return this.player.method_5767();
        }
        return false;
    }

    @Override
    public int getSortWeight() {
        return this.plugin.getSortWeight(this.getName());
    }

    @Override
    public void setSortWeight(int wt) {
        if (wt == 0) {
            this.plugin.dropSortWeight(this.getName());
        } else {
            this.plugin.setSortWeight(this.getName(), wt);
        }
    }

    @Override
    public boolean hasPermissionNode(String node) {
        return this.player != null && this.plugin.hasPermNode((class_1657)this.player, node);
    }

    @Override
    public String getSkinURL() {
        return this.skinurl;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void sendTitleText(String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        if (this.player != null) {
            class_3222 player = this.player;
            class_2762 times = new class_2762(fadeInTicks, stayTicks, fadeOutTicks);
            player.field_13987.method_14364((class_2596)times);
            if (title != null) {
                class_2762 titlepkt = new class_2762(class_2762.class_2763.field_12630, (class_2561)new class_2585(title));
                player.field_13987.method_14364((class_2596)titlepkt);
            }
            if (subtitle != null) {
                class_2762 subtitlepkt = new class_2762(class_2762.class_2763.field_12632, (class_2561)new class_2585(subtitle));
                player.field_13987.method_14364((class_2596)subtitlepkt);
            }
        }
    }
}

