/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.hdmap.TexturePackHDShader;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.LightLevels;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class TexturePackHDCaveShader
extends TexturePackHDShader {
    private int maxskylevel;
    private int minemittedlevel;

    public TexturePackHDCaveShader(DynmapCore core, ConfigurationNode configuration) {
        super(core, configuration);
        this.maxskylevel = configuration.getInteger("max-sky-light", 0);
        this.minemittedlevel = configuration.getInteger("min-emitted-light", 1);
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new CaveShaderState(mapiter, map, cache, scale);
    }

    class CaveShaderState
    extends TexturePackHDShader.ShaderState {
        private boolean ready;
        private LightLevels ll;

        protected CaveShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache, int scale) {
            super(mapiter, map, cache, scale);
            this.ll = new LightLevels();
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            super.reset(ps);
            this.ready = false;
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            if (this.ready) {
                return super.processBlock(ps);
            }
            if (ps.getLastBlockStep() == BlockStep.Y_MINUS && ps.getBlockState().isAir()) {
                ps.getLightLevels(this.ll);
                if (this.ll.sky <= TexturePackHDCaveShader.this.maxskylevel && this.ll.emitted > TexturePackHDCaveShader.this.minemittedlevel) {
                    this.ready = true;
                }
            }
            return false;
        }
    }
}

