/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.storage.MapStorageTile;
import org.dynmap.utils.BufferInputStream;
import org.dynmap.utils.BufferOutputStream;

public class ImageIOManager {
    public static String preUpdateCommand = null;
    public static String postUpdateCommand = null;
    private static Object imageioLock = new Object();
    public static DynmapCore core;
    private static boolean did_warning;

    private static MapType.ImageFormat validateFormat(MapType.ImageFormat fmt) {
        if (fmt.getEncoding() == MapType.ImageEncoding.WEBP && core.getCWEBPPath() == null) {
            if (!did_warning) {
                Log.warning("Attempt to use WEBP support when not usable: using JPEG");
                did_warning = true;
            }
            fmt = MapType.ImageFormat.FORMAT_JPG;
        }
        return fmt;
    }

    private static void doWEBPEncode(BufferedImage img, MapType.ImageFormat fmt, OutputStream out) throws IOException {
        BufferOutputStream bos = new BufferOutputStream();
        ImageIO.write((RenderedImage)img, "png", bos);
        File tmpfile = File.createTempFile("pngToWebp", "png");
        FileOutputStream fos = new FileOutputStream(tmpfile);
        fos.write(bos.buf, 0, bos.len);
        fos.close();
        File tmpfile2 = File.createTempFile("pngToWebp", "webp");
        String[] args = new String[]{core.getCWEBPPath(), "-q", Integer.toString((int)fmt.getQuality()), tmpfile.getAbsolutePath(), "-o", tmpfile2.getAbsolutePath()};
        Process pr = Runtime.getRuntime().exec(args);
        try {
            pr.waitFor();
        }
        catch (InterruptedException ix) {
            throw new IOException("Error waiting for encoder");
        }
        Files.copy((File)tmpfile2, (OutputStream)out);
        out.flush();
        tmpfile.delete();
        tmpfile2.delete();
    }

    private static BufferedImage doWEBPDecode(BufferInputStream buf) throws IOException {
        File tmpfile = File.createTempFile("webpToPng", "webp");
        Files.write((byte[])buf.buffer(), (File)tmpfile);
        File tmpfile2 = File.createTempFile("webpToPng", "png");
        String[] args = new String[]{core.getDWEBPPath(), tmpfile.getAbsolutePath(), "-o", tmpfile2.getAbsolutePath()};
        Process pr = Runtime.getRuntime().exec(args);
        try {
            pr.waitFor();
        }
        catch (InterruptedException ix) {
            throw new IOException("Error waiting for encoder");
        }
        BufferedImage obuf = ImageIO.read(tmpfile2);
        tmpfile.delete();
        tmpfile2.delete();
        return obuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferOutputStream imageIOEncode(BufferedImage img, MapType.ImageFormat fmt) {
        BufferOutputStream bos = new BufferOutputStream();
        Object object = imageioLock;
        synchronized (object) {
            try {
                ImageIO.setUseCache(false);
                fmt = ImageIOManager.validateFormat(fmt);
                if (fmt.getEncoding() == MapType.ImageEncoding.JPG) {
                    WritableRaster raster = img.getRaster();
                    WritableRaster newRaster = raster.createWritableChild(0, 0, img.getWidth(), img.getHeight(), 0, 0, new int[]{0, 1, 2});
                    DirectColorModel cm = (DirectColorModel)img.getColorModel();
                    DirectColorModel newCM = new DirectColorModel(cm.getPixelSize(), cm.getRedMask(), cm.getGreenMask(), cm.getBlueMask());
                    BufferedImage rgbBuffer = new BufferedImage(newCM, newRaster, false, null);
                    ImageWriter writer = null;
                    Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                    if (iter.hasNext()) {
                        writer = iter.next();
                    }
                    if (writer == null) {
                        Log.severe("No JPEG ENCODER - Java VM does not support JPEG encoding");
                        return null;
                    }
                    ImageWriteParam iwp = writer.getDefaultWriteParam();
                    iwp.setCompressionMode(2);
                    iwp.setCompressionQuality(fmt.getQuality());
                    ImageOutputStream ios = ImageIO.createImageOutputStream(bos);
                    writer.setOutput(ios);
                    writer.write(null, new IIOImage(rgbBuffer, null, null), iwp);
                    writer.dispose();
                    rgbBuffer.flush();
                } else if (fmt.getEncoding() == MapType.ImageEncoding.WEBP) {
                    ImageIOManager.doWEBPEncode(img, fmt, bos);
                } else {
                    ImageIO.write((RenderedImage)img, fmt.getFileExt(), bos);
                }
            }
            catch (IOException iox) {
                Log.info("Error encoding image - " + iox.getMessage());
                return null;
            }
        }
        return bos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage imageIODecode(MapStorageTile.TileRead tr) throws IOException {
        Object object = imageioLock;
        synchronized (object) {
            ImageIO.setUseCache(false);
            if (tr.format == MapType.ImageEncoding.WEBP) {
                return ImageIOManager.doWEBPDecode(tr.image);
            }
            return ImageIO.read(tr.image);
        }
    }

    static {
        did_warning = false;
    }
}

