/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches;

import com.therandomlabs.utils.config.Config;

@Config(id="randompatches", comment={"RandomPatches configuration"})
public final class RPConfig {
    @Config.Category(value={"Options that don't fit into any other categories."})
    public static final Misc misc = null;
    @Config.Category(value={"Options related to the movement speed limits."})
    public static final SpeedLimits speedLimits = null;
    @Config.Category(value={"Options related to the disconnect timeouts."})
    public static final Timeouts timeouts = null;

    private RPConfig() {
    }

    public static final class Timeouts {
        @Config.RangeInt(min=1)
        @Config.Property(value={"The interval at which the server sends the KeepAlive packet."})
        public static int keepAlivePacketInterval = 15;
        @Config.RangeInt(min=1)
        @Config.Property(value={"The login timeout in ticks."})
        public static int loginTimeout = 900;
        @Config.RangeInt(min=1)
        @Config.Property(value={"The read timeout in seconds.", "This is the time it takes for a player to be disconnected after not responding to a KeepAlive packet.", "This value is automatically rounded up to a product of 15."})
        public static int readTimeout = 90;
        public static long readTimeoutMillis;

        private Timeouts() {
        }

        public static void onReload() {
            if (readTimeout < keepAlivePacketInterval) {
                readTimeout = keepAlivePacketInterval;
            } else if (readTimeout % keepAlivePacketInterval != 0) {
                readTimeout = keepAlivePacketInterval * (readTimeout / keepAlivePacketInterval + 1);
            }
            readTimeoutMillis = (long)readTimeout * 1000L;
        }
    }

    public static final class SpeedLimits {
        @Config.RangeDouble(min=1.0)
        @Config.Property(value={"The maximum player speed.", "The vanilla default is 100.0."})
        public static float maxPlayerSpeed = 1000000.0f;
        @Config.RangeDouble(min=1.0)
        @Config.Property(value={"The maximum player elytra speed.", "The vanilla default is 300.0."})
        public static float maxPlayerElytraSpeed = 1000000.0f;
        @Config.RangeDouble(min=1.0)
        @Config.Property(value={"The maximum player vehicle speed.", "The vanilla default is 100.0."})
        public static double maxPlayerVehicleSpeed = 1000000.0;

        private SpeedLimits() {
        }
    }

    public static final class Misc {
        @Config.RequiresRestart
        @Config.Property(value={"Enables the /rpreload command."})
        public static boolean rpreload = true;

        private Misc() {
        }
    }
}

