/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.InfoCommand;
import carpettisaddition.commands.lifetime.LifeTimeCommand;
import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.raid.RaidCommand;
import carpettisaddition.commands.raid.RaidTracker;
import carpettisaddition.logging.ExtensionLoggerRegistry;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.translations.ExtensionTranslations;
import carpettisaddition.utils.stacktrace.StackTraceDeobfuscator;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CarpetTISAdditionServer
implements CarpetExtension {
    public static final CarpetTISAdditionServer instance = new CarpetTISAdditionServer();
    public static final String name = "carpet-tis-addition";
    public static final String fancyName = "Carpet TIS Addition";
    public static final String compactName = "carpet-tis-addition".replace("-", "");
    public static final String version = "1.11.2+build.356";
    public static final Logger LOGGER = LogManager.getLogger((String)"Carpet TIS Addition");
    public static MinecraftServer minecraft_server;

    public String version() {
        return name;
    }

    public static void noop() {
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(CarpetTISAdditionSettings.class);
        CarpetServer.settingsManager.addRuleObserver((serverCommandSource, currentRuleState, originalUserTest) -> {});
    }

    public void onServerLoaded(MinecraftServer server) {
        minecraft_server = server;
    }

    public void onServerLoadedWorldsCTA(MinecraftServer server) {
        MicroTimingLoggerManager.attachServer(server);
        LifeTimeTracker.attachServer(server);
    }

    public void onServerClosed(MinecraftServer server) {
        RaidTracker.getInstance().stop();
        MicroTimingLoggerManager.detachServer();
        LifeTimeTracker.detachServer();
    }

    public void onTick(MinecraftServer server) {
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        RaidCommand.getInstance().registerCommand(dispatcher);
        InfoCommand.getInstance().registerCommand(dispatcher);
        LifeTimeCommand.getInstance().registerCommand(dispatcher);
    }

    public void onPlayerLoggedIn(class_3222 player) {
    }

    public void onPlayerLoggedOut(class_3222 player) {
    }

    public void registerLoggers() {
        ExtensionLoggerRegistry.registerLoggers();
    }

    public Map<String, String> canHasTranslations(String lang) {
        return ExtensionTranslations.getTranslationFromResourcePath(lang);
    }

    static {
        CarpetServer.manageExtension((CarpetExtension)instance);
        StackTraceDeobfuscator.loadMappings();
    }
}

