/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands;

import carpet.utils.Messenger;
import carpettisaddition.translations.TranslatableBase;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.GameUtil;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public abstract class AbstractTracker
extends TranslatableBase {
    private static final Translator baseTranslator = new Translator("tracker");
    private final String name;
    private boolean tracking;
    private long startTick;
    private long startMillis;

    public AbstractTracker(String name) {
        super("tracker", name.toLowerCase());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCommandPrefix() {
        return this.name.toLowerCase();
    }

    public String getTranslatedName() {
        return this.tr("name", this.name);
    }

    public String getTranslatedNameFull() {
        return String.format(baseTranslator.tr("tracker_name_full", "%s Tracker"), this.getTranslatedName());
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public int startTracking(class_2168 source, boolean showFeedback) {
        if (this.isTracking()) {
            if (showFeedback) {
                Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.c((Object[])new Object[]{"r " + String.format(baseTranslator.tr("tracking_already_started", "%s is already running"), this.getTranslatedNameFull())})});
            }
            return 1;
        }
        this.tracking = true;
        this.startTick = GameUtil.getGameTime();
        this.startMillis = System.currentTimeMillis();
        if (showFeedback) {
            Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.c((Object[])new Object[]{"w " + String.format(baseTranslator.tr("tracking_started", "%s started"), this.getTranslatedNameFull())})});
        }
        this.initTracker();
        return 1;
    }

    public int stopTracking(class_2168 source, boolean showFeedback) {
        if (source != null) {
            if (this.isTracking()) {
                this.reportTracking(source, false);
                if (showFeedback) {
                    Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.c((Object[])new Object[]{"w  \n", "w " + String.format(baseTranslator.tr("tracking_stopped", "%s stopped"), this.getTranslatedNameFull())})});
                }
            } else if (showFeedback) {
                Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.c((Object[])new Object[]{"r " + String.format(baseTranslator.tr("tracking_not_started", "%s has not started"), this.getTranslatedNameFull())})});
            }
        }
        this.tracking = false;
        return 1;
    }

    public int restartTracking(class_2168 source) {
        boolean wasTracking = this.isTracking();
        this.stopTracking(source, false);
        this.startTracking(source, false);
        if (wasTracking) {
            source.method_9226((class_2561)Messenger.s((String)" "), false);
        }
        Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.s((String)String.format(baseTranslator.tr("tracking_restarted", "%s restarted"), this.getTranslatedNameFull()))});
        return 1;
    }

    public int reportTracking(class_2168 source, boolean realtime) {
        if (this.isTracking()) {
            this.printTrackingResult(source, realtime);
            return 1;
        }
        Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.c((Object[])new Object[]{"r " + String.format(baseTranslator.tr("tracking_not_started", "%s has not started"), this.getTranslatedNameFull())})});
        return 1;
    }

    public LiteralArgumentBuilder<class_2168> getTrackingArgumentBuilder() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tracking").executes(c -> this.reportTracking((class_2168)c.getSource(), false))).then(class_2170.method_9247((String)"start").executes(c -> this.startTracking((class_2168)c.getSource(), true)))).then(class_2170.method_9247((String)"stop").executes(c -> this.stopTracking((class_2168)c.getSource(), true)))).then(class_2170.method_9247((String)"restart").executes(c -> this.restartTracking((class_2168)c.getSource())))).then(class_2170.method_9247((String)"realtime").executes(c -> this.reportTracking((class_2168)c.getSource(), true)));
    }

    protected long getTrackedTick(boolean realtime) {
        return Math.max(1L, realtime ? (System.currentTimeMillis() - this.getStartMillis()) / 50L : GameUtil.getGameTime() - this.getStartTick());
    }

    protected long sendTrackedTime(class_2168 source, boolean realtime) {
        long ticks = this.getTrackedTick(realtime);
        source.method_9226((class_2561)Messenger.c((Object[])new Object[]{"w  \n", "g ----------- ", "w " + this.getTranslatedNameFull(), "g  -----------\n", String.format("w %s %.2f min (%s)", baseTranslator.tr("Tracked"), (double)ticks / 1200.0, baseTranslator.tr(realtime ? "real time" : "in game"))}), false);
        return ticks;
    }

    public void stop() {
        this.stopTracking(null, false);
    }

    protected abstract void initTracker();

    protected abstract void printTrackingResult(class_2168 var1, boolean var2);
}

