/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime;

import carpet.utils.Messenger;
import carpettisaddition.commands.AbstractTracker;
import carpettisaddition.commands.lifetime.LifeTimeWorldTracker;
import carpettisaddition.commands.lifetime.interfaces.IServerWorld;
import carpettisaddition.commands.lifetime.utils.LifeTimeTrackerUtil;
import carpettisaddition.commands.lifetime.utils.SpecificDetailMode;
import carpettisaddition.utils.TextUtil;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class LifeTimeTracker
extends AbstractTracker {
    private static boolean attachedServer = false;
    private static final LifeTimeTracker INSTANCE = new LifeTimeTracker();
    private final Map<class_3218, LifeTimeWorldTracker> trackers = new Reference2ObjectArrayMap();

    public LifeTimeTracker() {
        super("LifeTime");
    }

    public static LifeTimeTracker getInstance() {
        return INSTANCE;
    }

    public static void attachServer(MinecraftServer minecraftServer) {
        attachedServer = true;
        LifeTimeTracker.INSTANCE.trackers.clear();
        for (class_3218 world : minecraftServer.method_3738()) {
            LifeTimeTracker.INSTANCE.trackers.put(world, ((IServerWorld)world).getLifeTimeWorldTracker());
        }
    }

    public static void detachServer() {
        attachedServer = false;
        INSTANCE.stop();
    }

    public static boolean isActivated() {
        return attachedServer && INSTANCE.isTracking();
    }

    public Stream<String> getAvailableEntityType() {
        if (!LifeTimeTracker.isActivated()) {
            return Stream.empty();
        }
        return this.trackers.values().stream().flatMap(tracker -> tracker.getDataMap().keySet().stream().map(LifeTimeTrackerUtil::getEntityTypeDescriptor)).distinct();
    }

    @Override
    protected void initTracker() {
        this.trackers.values().forEach(LifeTimeWorldTracker::initTracker);
    }

    @Override
    protected void printTrackingResult(class_2168 source, boolean realtime) {
        try {
            long ticks = this.sendTrackedTime(source, realtime);
            int count = this.trackers.values().stream().mapToInt(tracker -> tracker.print(source, ticks, null, null)).sum();
            if (count == 0) {
                Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.s((String)this.tr("no_result", "No result yet"))});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int printTrackingResultSpecific(class_2168 source, String entityTypeString, String detailModeString, boolean realtime) {
        Optional<class_1299> entityTypeOptional = class_2378.field_11145.method_10220().filter(entityType -> LifeTimeTrackerUtil.getEntityTypeDescriptor(entityType).equals(entityTypeString)).findFirst();
        if (entityTypeOptional.isPresent()) {
            SpecificDetailMode detailMode = null;
            if (detailModeString != null) {
                try {
                    detailMode = SpecificDetailMode.fromString(detailModeString);
                }
                catch (IllegalArgumentException e) {
                    Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.s((String)String.format(this.tr("invalid_detail", "Invalid statistic detail \"%s\""), detailModeString), (String)"r")});
                    return 1;
                }
            }
            long ticks = this.sendTrackedTime(source, realtime);
            class_1299 entityType2 = entityTypeOptional.get();
            source.method_9226((class_2561)Messenger.c((Object[])new Object[]{"w " + this.tr("specific_result.pre", "Life time result for "), entityType2.method_5897(), "w " + this.tr("specific_result.post", "")}), false);
            SpecificDetailMode finalDetailMode = detailMode;
            int count = this.trackers.values().stream().mapToInt(tracker -> tracker.print(source, ticks, entityType2, finalDetailMode)).sum();
            if (count == 0) {
                Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.s((String)this.tr("no_result", "No result yet"))});
            }
        } else {
            Messenger.m((class_2168)source, (Object[])new Object[]{Messenger.s((String)String.format(this.tr("unknown_entity_type", "Unknown entity type \"%s\""), entityTypeString), (String)"r")});
        }
        return 1;
    }

    protected int showHelp(class_2168 source) {
        String docLink = this.tr("help.doc_link", "https://github.com/TISUnion/Carpet-TIS-Addition#lifetime");
        source.method_9226((class_2561)Messenger.c((Object[])new Object[]{String.format("wb %s\n", this.getTranslatedNameFull()), String.format("w %s\n", this.tr("help.doc_summary", "A tracker to track lifetime and spawn / removal reasons from all newly spawned and dead entities")), String.format("w %s", this.tr("help.complete_doc_hint", "Complete doc")), TextUtil.getSpaceText(), TextUtil.getFancyText(null, Messenger.s((String)this.tr("help.here", "here"), (String)"ut"), Messenger.s((String)docLink, (String)"t"), new class_2558(class_2558.class_2559.field_11749, docLink))}), false);
        return 1;
    }
}

