/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime;

import carpet.utils.Messenger;
import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.removal.RemovalReason;
import carpettisaddition.commands.lifetime.spawning.SpawningReason;
import carpettisaddition.commands.lifetime.utils.LifeTimeTrackerUtil;
import carpettisaddition.commands.lifetime.utils.SpecificDetailMode;
import carpettisaddition.commands.lifetime.utils.TrackedData;
import carpettisaddition.translations.TranslatableBase;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class LifeTimeWorldTracker
extends TranslatableBase {
    private final class_3218 world;
    private final Map<class_1299<?>, TrackedData> dataMap = Maps.newHashMap();
    private long spawnStageCounter;

    public LifeTimeWorldTracker(class_3218 world) {
        super(LifeTimeTracker.getInstance().getTranslator());
        this.world = world;
    }

    public Map<class_1299<?>, TrackedData> getDataMap() {
        return this.dataMap;
    }

    public void initTracker() {
        this.dataMap.clear();
    }

    private Optional<TrackedData> getTrackedData(class_1297 entity) {
        if (LifeTimeTracker.isActivated() && LifeTimeTrackerUtil.isTrackedEntity(entity)) {
            return Optional.of(this.dataMap.computeIfAbsent(entity.method_5864(), e -> new TrackedData()));
        }
        return Optional.empty();
    }

    public void onEntitySpawn(class_1297 entity, SpawningReason reason) {
        this.getTrackedData(entity).ifPresent(data -> data.updateSpawning(entity, reason));
    }

    public void onEntityRemove(class_1297 entity, RemovalReason reason) {
        this.getTrackedData(entity).ifPresent(data -> data.updateRemoval(entity, reason));
    }

    public void increaseSpawnStageCounter() {
        ++this.spawnStageCounter;
    }

    public long getSpawnStageCounter() {
        return this.spawnStageCounter;
    }

    private List<class_2554> addIfEmpty(List<class_2554> list, class_2554 text) {
        if (list.isEmpty()) {
            list.add(text);
        }
        return list;
    }

    protected int print(class_2168 source, long ticks, class_1299<?> specificType, SpecificDetailMode detailMode) {
        TrackedData specificData = this.dataMap.get(specificType);
        if (this.dataMap.isEmpty() || specificType != null && specificData == null) {
            return 0;
        }
        ArrayList result = Lists.newArrayList();
        result.add(Messenger.c((Object[])new Object[]{"w  \n", TextUtil.attachFormatting(TextUtil.getDimensionNameText((class_5321<class_1937>)this.world.method_27983()), class_124.field_1067, class_124.field_1065), String.format("g  (%s)", this.world.method_27983().method_29177())}));
        if (specificType == null) {
            this.printAll(ticks, result);
        } else {
            this.printSpecific(ticks, specificType, specificData, detailMode, result);
        }
        Messenger.send((class_2168)source, (Collection)result);
        return 1;
    }

    private void printAll(long ticks, List<class_2554> result) {
        this.dataMap.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingLong(a -> ((TrackedData)a.getValue()).spawnCount))).forEach(entry -> {
            class_1299 entityType = (class_1299)entry.getKey();
            TrackedData data = (TrackedData)entry.getValue();
            List<class_2554> spawningReasons = data.getSpawningReasonsTexts(ticks, true);
            List<class_2554> removalReasons = data.getRemovalReasonsTexts(ticks, true);
            String currentCommandBase = String.format("/%s %s", LifeTimeTracker.getInstance().getCommandPrefix(), LifeTimeTrackerUtil.getEntityTypeDescriptor(entityType));
            result.add(Messenger.c((Object[])new Object[]{"g - [", TextUtil.getFancyText(null, (class_2554)entityType.method_5897(), Messenger.s((String)this.tr("detail_hint", "Click to show detail")), new class_2558(class_2558.class_2559.field_11745, currentCommandBase)), "g ] ", TextUtil.getFancyText(null, Messenger.c((Object[])new Object[]{"e S", "g /", "r R"}), Messenger.c((Object[])new Object[]{"e " + this.tr("Spawn Count"), "g  / ", "r " + this.tr("Removal Count")}), null), "g : ", TextUtil.getFancyText(null, Messenger.c((Object[])new Object[]{"e " + data.spawnCount}), Messenger.s((String)Messenger.c((Object[])new Object[]{data.getSpawningCountText(ticks), "w " + (spawningReasons.isEmpty() ? "" : "\n"), Messenger.c((Object[])spawningReasons.toArray(new Object[0]))}).getString()), new class_2558(class_2558.class_2559.field_11745, String.format("%s %s", new Object[]{currentCommandBase, SpecificDetailMode.SPAWNING}))), "g /", TextUtil.getFancyText(null, Messenger.c((Object[])new Object[]{"r " + data.getRemovalCount()}), Messenger.s((String)Messenger.c((Object[])new Object[]{data.getRemovalCountText(ticks), "w " + (removalReasons.isEmpty() ? "" : "\n"), Messenger.c((Object[])removalReasons.toArray(new Object[0]))}).getString()), new class_2558(class_2558.class_2559.field_11745, String.format("%s %s", new Object[]{currentCommandBase, SpecificDetailMode.REMOVAL}))), "g , ", TextUtil.getFancyText(null, Messenger.c((Object[])new Object[]{"q L", "g : ", data.lifeTimeStatistic.getCompressedResult("g /")}), Messenger.s((String)Messenger.c((Object[])new Object[]{String.format("q %s\n", this.tr("Life Time Overview")), data.lifeTimeStatistic.getResult("")}).getString()), new class_2558(class_2558.class_2559.field_11745, String.format("%s %s", new Object[]{currentCommandBase, SpecificDetailMode.LIFE_TIME})))}));
        });
    }

    private void printSpecific(long ticks, class_1299<?> specificType, TrackedData specificData, SpecificDetailMode detailMode, List<class_2554> result) {
        boolean showRemoval;
        boolean showLifeTime = detailMode == null || detailMode == SpecificDetailMode.LIFE_TIME;
        boolean showSpawning = detailMode == null || detailMode == SpecificDetailMode.SPAWNING;
        boolean bl = showRemoval = detailMode == null || detailMode == SpecificDetailMode.REMOVAL;
        if (showSpawning) {
            result.add(specificData.getSpawningCountText(ticks));
        }
        if (showRemoval) {
            result.add(specificData.getRemovalCountText(ticks));
        }
        if (showLifeTime) {
            result.add(TextUtil.getFancyText("q", Messenger.s((String)this.tr("Life Time Overview")), Messenger.s((String)this.tr("life_time_explain", "The amount of spawning stage passing between entity spawning and entity removal")), null));
            result.add(specificData.lifeTimeStatistic.getResult(""));
        }
        if (showSpawning) {
            result.add(Messenger.s((String)this.tr("Reasons for spawning"), (String)"e"));
            result.addAll(this.addIfEmpty(specificData.getSpawningReasonsTexts(ticks, false), Messenger.s((String)"  N/A", (String)"g")));
        }
        if (showRemoval) {
            result.add(Messenger.s((String)this.tr("Reasons for removal"), (String)"r"));
            result.addAll(this.addIfEmpty(specificData.getRemovalReasonsTexts(ticks, false), Messenger.s((String)"  N/A", (String)"g")));
        }
    }
}

