/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.utils;

import carpet.utils.Messenger;
import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.interfaces.IEntity;
import carpettisaddition.translations.TranslatableBase;
import carpettisaddition.utils.TextUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_5321;

public class LifeTimeStatistic
extends TranslatableBase {
    public static final String COLOR_MIN_TIME = "q ";
    public static final String COLOR_MAX_TIME = "c ";
    public static final String COLOR_AVG_TIME = "p ";
    public StatisticElement minTimeElement;
    public StatisticElement maxTimeElement;
    public long count;
    public long timeSum;

    public LifeTimeStatistic() {
        super(LifeTimeTracker.getInstance().getTranslator());
        this.clear();
    }

    public void clear() {
        this.count = 0L;
        this.timeSum = 0L;
        this.minTimeElement = new StatisticElement(Integer.MAX_VALUE, null, null);
        this.maxTimeElement = new StatisticElement(Integer.MIN_VALUE, null, null);
    }

    public boolean isValid() {
        return this.count > 0L;
    }

    public void update(class_1297 entity) {
        long time = ((IEntity)entity).getLifeTime();
        ++this.count;
        this.timeSum += time;
        StatisticElement element = new StatisticElement(time, entity.method_5770().method_27983(), ((IEntity)entity).getSpawningPosition());
        if (time < this.minTimeElement.time) {
            this.minTimeElement = element;
        }
        if (time > this.maxTimeElement.time) {
            this.maxTimeElement = element;
        }
    }

    public class_2554 getResult(String indentString) {
        class_2554 indent = Messenger.s((String)indentString, (String)"g");
        class_2554 newLine = Messenger.s((String)"\n");
        if (!this.isValid()) {
            return Messenger.c((Object[])new Object[]{indent, "g   N/A"});
        }
        indent = Messenger.c((Object[])new Object[]{indent, "g - "});
        return Messenger.c((Object[])new Object[]{indent, this.minTimeElement.getTimeWithPos(this.tr("Minimum life time"), COLOR_MIN_TIME), newLine, indent, this.maxTimeElement.getTimeWithPos(this.tr("Maximum life time"), COLOR_MAX_TIME), newLine, indent, "w " + this.tr("Average life time"), "g : ", COLOR_AVG_TIME + String.format("%.4f", (double)this.timeSum / (double)this.count), "g  gt"});
    }

    public class_2554 getCompressedResult(Object divider) {
        if (!this.isValid()) {
            return Messenger.s((String)"N/A", (String)"g");
        }
        return Messenger.c((Object[])new Object[]{COLOR_MIN_TIME + this.minTimeElement.time, divider, COLOR_MAX_TIME + this.maxTimeElement.time, divider, COLOR_AVG_TIME + String.format("%.2f", (double)this.timeSum / (double)this.count), "g  (gt)"});
    }

    private class StatisticElement {
        private final long time;
        private final class_5321<class_1937> dimensionType;
        private final class_243 spawnPos;

        private StatisticElement(long time, class_5321<class_1937> dimensionType, class_243 spawnPos) {
            this.time = time;
            this.dimensionType = dimensionType;
            this.spawnPos = spawnPos;
        }

        private class_2554 getTimeWithPos(String hint, String fmt) {
            return TextUtil.getFancyText(null, Messenger.c((Object[])new Object[]{"w " + hint, "g : ", fmt + this.time, "g  gt"}), Messenger.c((Object[])new Object[]{"w " + LifeTimeStatistic.this.tr("Spawn Position"), "g : ", "w " + TextUtil.getCoordinateString(this.spawnPos)}), new class_2558(class_2558.class_2559.field_11745, TextUtil.getTeleportCommand(this.spawnPos, this.dimensionType)));
        }
    }
}

