/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.utils;

import carpet.utils.Messenger;
import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.removal.RemovalReason;
import carpettisaddition.commands.lifetime.spawning.SpawningReason;
import carpettisaddition.commands.lifetime.utils.AbstractReason;
import carpettisaddition.commands.lifetime.utils.LifeTimeStatistic;
import carpettisaddition.translations.TranslatableBase;
import carpettisaddition.utils.CounterUtil;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2554;

public class TrackedData
extends TranslatableBase {
    public final Map<SpawningReason, Integer> spawningReasons = Maps.newHashMap();
    public long spawnCount;
    public final Map<RemovalReason, LifeTimeStatistic> removalReasons = Maps.newHashMap();
    public final LifeTimeStatistic lifeTimeStatistic = new LifeTimeStatistic();

    public TrackedData() {
        super(LifeTimeTracker.getInstance().getTranslator());
    }

    public void updateSpawning(class_1297 entity, SpawningReason reason) {
        ++this.spawnCount;
        this.spawningReasons.put(reason, this.spawningReasons.getOrDefault(reason, 0) + 1);
    }

    public void updateRemoval(class_1297 entity, RemovalReason reason) {
        this.lifeTimeStatistic.update(entity);
        this.removalReasons.computeIfAbsent(reason, r -> new LifeTimeStatistic()).update(entity);
    }

    public long getRemovalCount() {
        return this.removalReasons.values().stream().mapToLong(stat -> stat.count).sum();
    }

    public class_2554 getSpawningCountText(long ticks) {
        return Messenger.c((Object[])new Object[]{"q " + this.tr("Spawn Count"), "g : ", CounterUtil.ratePerHourText(this.spawnCount, ticks, "wgg")});
    }

    public class_2554 getRemovalCountText(long ticks) {
        return Messenger.c((Object[])new Object[]{"q " + this.tr("Removal Count"), "g : ", CounterUtil.ratePerHourText(this.getRemovalCount(), ticks, "wgg")});
    }

    private class_2554 getReasonWithRate(AbstractReason reason, long ticks, long count, long total) {
        double percentage = 100.0 * (double)count / (double)total;
        return Messenger.c((Object[])new Object[]{"g - ", reason.toText(), "g : ", CounterUtil.ratePerHourText(count, ticks, "wgg"), "w  ", TextUtil.attachHoverText(Messenger.s((String)String.format("%.1f%%", percentage)), Messenger.s((String)String.format("%.6f%%", percentage)))});
    }

    public List<class_2554> getSpawningReasonsTexts(long ticks, boolean hoverMode) {
        ArrayList result = Lists.newArrayList();
        ArrayList entryList = Lists.newArrayList(this.spawningReasons.entrySet());
        entryList.sort(Collections.reverseOrder(Comparator.comparingInt(Map.Entry::getValue)));
        if (!entryList.isEmpty() && hoverMode) {
            result.add(Messenger.s((String)this.tr("Reasons for spawning"), (String)"e"));
        }
        entryList.forEach(entry -> {
            if (hoverMode) {
                result.add(Messenger.s((String)"\n"));
            }
            result.add(this.getReasonWithRate((AbstractReason)entry.getKey(), ticks, ((Integer)entry.getValue()).intValue(), this.spawnCount));
        });
        return result;
    }

    public List<class_2554> getRemovalReasonsTexts(long ticks, boolean hoverMode) {
        ArrayList result = Lists.newArrayList();
        ArrayList entryList = Lists.newArrayList(this.removalReasons.entrySet());
        entryList.sort(Collections.reverseOrder(Comparator.comparingLong(a -> ((LifeTimeStatistic)a.getValue()).count)));
        if (!entryList.isEmpty() && hoverMode) {
            result.add(Messenger.s((String)this.tr("Reasons for removal"), (String)"r"));
        }
        entryList.forEach(entry -> {
            RemovalReason reason = (RemovalReason)entry.getKey();
            LifeTimeStatistic statistic = (LifeTimeStatistic)entry.getValue();
            if (hoverMode) {
                result.add(Messenger.s((String)"\n"));
            }
            result.add(Messenger.c((Object[])new Object[]{this.getReasonWithRate(reason, ticks, statistic.count, this.lifeTimeStatistic.count), "w \n", statistic.getResult("  ")}));
        });
        return result;
    }
}

