/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.raid;

import carpet.utils.Messenger;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.raid.RaidTracker;
import carpettisaddition.mixins.command.raid.RaidAccessor;
import carpettisaddition.mixins.command.raid.RaidManagerAccessor;
import carpettisaddition.utils.CarpetModUtil;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3763;
import net.minecraft.class_3765;
import net.minecraft.class_5321;

public class RaidCommand
extends AbstractCommand {
    private static final RaidCommand INSTANCE = new RaidCommand();

    public static RaidCommand getInstance() {
        return INSTANCE;
    }

    public RaidCommand() {
        super("raid");
    }

    @Override
    public void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"raid").requires(player -> CarpetModUtil.canUseCommand(player, CarpetTISAdditionSettings.commandRaid))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(c -> this.listRaid((class_2168)c.getSource(), false))).then(class_2170.method_9247((String)"full").executes(c -> this.listRaid((class_2168)c.getSource(), true))))).then(RaidTracker.getInstance().getTrackingArgumentBuilder());
        dispatcher.register(builder);
    }

    public int listRaid(class_2168 source, boolean fullMode) {
        if (CarpetTISAdditionServer.minecraft_server == null) {
            return 0;
        }
        boolean hasRaid = false;
        for (class_3218 world : CarpetTISAdditionServer.minecraft_server.method_3738()) {
            Map<Integer, class_3765> raids = ((RaidManagerAccessor)world.method_19495()).getRaids();
            if (raids.isEmpty()) continue;
            ArrayList<class_2554> result = new ArrayList<class_2554>();
            result.add(Messenger.c((Object[])new Object[]{TextUtil.getDimensionNameText((class_5321<class_1937>)world.method_27983()), String.format("w  %s: %d", this.tr("raid count"), raids.size())}));
            hasRaid |= raids.size() > 0;
            for (Map.Entry<Integer, class_3765> entry : raids.entrySet()) {
                class_3765 raid = entry.getValue();
                RaidAccessor raidAccessor = (RaidAccessor)raid;
                int currentWave = raidAccessor.getWavesSpawned();
                String status = raidAccessor.getStatus().method_20026();
                result.add(Messenger.c((Object[])new Object[]{"g - ", TextUtil.getTranslatedName("event.minecraft.raid", new Object[0]), String.format("w  #%d", raid.method_16494())}));
                result.add(Messenger.c((Object[])new Object[]{"g   ", String.format("w %s: %s", this.tr("Status"), this.tr("status." + status, status))}));
                if (fullMode) {
                    result.add(Messenger.c((Object[])new Object[]{"g   ", String.format("w %s: ", this.tr("Center")), TextUtil.getCoordinateText("w", (class_2382)raid.method_16495(), (class_5321<class_1937>)world.method_27983())}));
                    result.add(Messenger.c((Object[])new Object[]{"g   ", String.format("w %s: %d", this.tr("Bad Omen Level"), raid.method_16493())}));
                }
                result.add(Messenger.c((Object[])new Object[]{"g   ", String.format("w %s: %d/%d", this.tr("Waves"), raidAccessor.getWavesSpawned(), raidAccessor.getWaveCount())}));
                Set<class_3763> raiders = raidAccessor.getWaveToRaiders().get(currentWave);
                boolean hasRaiders = raiders != null && !raiders.isEmpty();
                result.add(Messenger.c((Object[])new Object[]{"g   ", String.format("w %s: %s", this.tr("Raiders"), hasRaiders ? String.format("x%d", raiders.size()) : this.tr("None"))}));
                if (!hasRaiders) continue;
                int counter = 0;
                ArrayList line = Lists.newArrayList();
                Iterator<class_3763> iter = raiders.iterator();
                while (iter.hasNext()) {
                    class_3763 raider = iter.next();
                    class_2554 raiderName = TextUtil.getEntityText(raider.equals((Object)raidAccessor.getWaveToCaptain().get(currentWave)) ? "r" : "w", (class_1297)raider);
                    class_2554 raiderMessage = Messenger.c((Object[])new Object[]{raiderName, "g  @ ", TextUtil.getCoordinateText("w", raider.method_19538(), (class_5321<class_1937>)raider.field_6002.method_27983())});
                    if (fullMode) {
                        result.add(Messenger.c((Object[])new Object[]{"g   - ", raiderMessage}));
                        continue;
                    }
                    class_2554 x = Messenger.s((String)String.format("[%s] ", class_2378.field_11145.method_10221((Object)raider.method_5864()).method_12832().substring(0, 1).toUpperCase()));
                    x.method_10862(raiderName.method_10866());
                    TextUtil.attachHoverText(x, raiderMessage);
                    TextUtil.attachClickEvent(x, new class_2558(class_2558.class_2559.field_11745, TextUtil.getTeleportCommand((class_1297)raider)));
                    line.add(x);
                    if (++counter != 10 && iter.hasNext()) continue;
                    line.add(0, "w     ");
                    result.add(Messenger.c((Object[])line.toArray(new Object[0])));
                    line.clear();
                    counter = 0;
                }
            }
            Messenger.send((class_2168)source, result);
        }
        if (!hasRaid) {
            source.method_9226((class_2561)Messenger.c((Object[])new Object[]{String.format("w %s", this.tr("no_raid", "No raid exists"))}), false);
        }
        return 1;
    }
}

