/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.commandblock;

import carpet.logging.LoggerRegistry;
import carpet.utils.Messenger;
import carpettisaddition.logging.ExtensionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.commandblock.ICommandBlockExecutor;
import carpettisaddition.utils.TextUtil;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1697;
import net.minecraft.class_1918;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2554;
import net.minecraft.class_2680;
import net.minecraft.class_3544;
import net.minecraft.class_5321;

public class CommandBlockLogger
extends AbstractLogger {
    public static final String NAME = "commandBlock";
    public static final int MINIMUM_LOG_INTERVAL = 60;
    public static final int MAXIMUM_PREVIEW_LENGTH = 16;
    private static final CommandBlockLogger INSTANCE = new CommandBlockLogger();

    public CommandBlockLogger() {
        super(NAME);
    }

    public static CommandBlockLogger getInstance() {
        return INSTANCE;
    }

    private void logCommandBlockExecution(class_1937 world, class_2554 nameText, class_2554 posText, class_1918 executor) {
        if (!ExtensionLoggerRegistry.__commandBlock) {
            return;
        }
        ICommandBlockExecutor iExecutor = (ICommandBlockExecutor)executor;
        long time = world.method_8510();
        String commandPreview = executor.method_8289();
        if (commandPreview.length() > 16) {
            commandPreview = commandPreview.substring(0, 13) + "...";
        }
        String finalCommandPreview = commandPreview;
        LoggerRegistry.getLogger((String)NAME).log(option -> {
            boolean isThrottledLogging;
            boolean bl = isThrottledLogging = !option.equals("all");
            if (time - iExecutor.getLastLoggedTime() < 60L && isThrottledLogging) {
                return null;
            }
            if (isThrottledLogging) {
                iExecutor.setLastLoggedTime(time);
            }
            return new class_2554[]{Messenger.c((Object[])new Object[]{TextUtil.attachFormatting(TextUtil.copyText(nameText), class_124.field_1065), TextUtil.getSpaceText(), "w " + this.tr("executed"), TextUtil.getSpaceText(), TextUtil.getFancyText("c", Messenger.s((String)finalCommandPreview), Messenger.s((String)executor.method_8289()), null), "g  @ ", posText})};
        });
    }

    public void onCommandBlockActivated(class_1937 world, class_2338 pos, class_2680 state, class_1918 executor) {
        this.logCommandBlockExecution(world, TextUtil.getBlockName(state.method_26204()), TextUtil.getCoordinateText("w", (class_2382)pos, (class_5321<class_1937>)world.method_27983()), executor);
    }

    public void onCommandBlockMinecartActivated(class_1697 entity) {
        if (class_3544.method_15438((String)entity.method_7567().method_8289())) {
            return;
        }
        this.logCommandBlockExecution(entity.method_5770(), TextUtil.getEntityText(null, (class_1297)entity), TextUtil.getCoordinateText("w", entity.method_19538(), (class_5321<class_1937>)entity.method_5770().method_27983()), entity.method_7567());
    }
}

