/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.damage;

import carpet.logging.LoggerRegistry;
import carpet.utils.Messenger;
import carpettisaddition.logging.ExtensionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.damage.interfaces.ILivingEntity;
import carpettisaddition.logging.loggers.damage.modifyreasons.Modification;
import carpettisaddition.logging.loggers.damage.modifyreasons.ModifyReason;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2554;
import net.minecraft.class_2558;

public class DamageLogger
extends AbstractLogger {
    public static final String NAME = "damage";
    private static final Translator TRANSLATOR = new DamageLogger(null, null, 0.0f).getTranslator();
    private final class_1309 entity;
    private final class_1282 damageSource;
    private final float initialAmount;
    private float currentAmount;
    private final List<Modification> modificationList = Lists.newArrayList();
    private boolean valid;

    public DamageLogger(class_1309 entity, class_1282 damageSource, float initialAmount) {
        super(NAME);
        this.entity = entity;
        this.damageSource = damageSource;
        this.initialAmount = initialAmount;
        this.currentAmount = initialAmount;
        this.valid = true;
    }

    public static boolean isLoggerActivated() {
        return ExtensionLoggerRegistry.__damage;
    }

    public static Translator getStaticTranslator() {
        return TRANSLATOR;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static void create(class_1309 entity, class_1282 source, float amount) {
        ILivingEntity iEntity;
        if (DamageLogger.isLoggerActivated() && !(iEntity = (ILivingEntity)entity).getDamageLogger().isPresent()) {
            iEntity.setDamageLogger(new DamageLogger(entity, source, amount));
        }
    }

    public void modifyDamage(float newAmount, ModifyReason reason) {
        if (this.damageSource.method_5534() && (this.entity.method_5753() || this.entity.method_6059(class_1294.field_5918))) {
            this.valid = false;
            return;
        }
        if (newAmount != this.currentAmount) {
            this.modificationList.add(new Modification(this.currentAmount, newAmount, reason));
            this.currentAmount = newAmount;
        }
        if (reason == ModifyReason.INVULNERABLE) {
            this.valid = false;
        }
    }

    private static class_2554[] verifyAndProduceMessage(String option, class_1657 player, class_1297 from, class_1297 to, Supplier<class_2554[]> messageFuture) {
        if ("all".equals(option) || "players".equals(option) && (from instanceof class_1657 || to instanceof class_1657) || "me".equals(option) && (from == player || to == player)) {
            return messageFuture.get();
        }
        return null;
    }

    private static class_2554 getAmountText(String style, float amount) {
        String display = String.format("%.2f", Float.valueOf(amount));
        String detail = String.format("%.6f", Float.valueOf(amount));
        return TextUtil.getFancyText(style, Messenger.s((String)display), Messenger.s((String)detail), new class_2558(class_2558.class_2559.field_11745, detail));
    }

    public void flush(float finalAmount, float remainingHealth) {
        if (!DamageLogger.isLoggerActivated() || !this.isValid()) {
            return;
        }
        this.valid = false;
        class_1297 attacker = this.damageSource.method_5529();
        class_1297 source = this.damageSource.method_5526();
        class_1309 target = this.entity;
        LoggerRegistry.getLogger((String)NAME).log((option, player) -> DamageLogger.verifyAndProduceMessage(option, player, attacker, (class_1297)target, () -> {
            ArrayList lines = Lists.newArrayList();
            lines.add(Messenger.s((String)" "));
            class_2554 sourceName = TextUtil.attachClickEvent((class_2554)target.method_5476(), new class_2558(class_2558.class_2559.field_11745, TextUtil.getTeleportCommand((class_1297)target)));
            ArrayList sourceHoverTextList = Lists.newArrayList();
            if (source != null) {
                sourceHoverTextList.add(Messenger.c((Object[])new Object[]{String.format("w %s: ", this.tr("Source")), source.method_5477()}));
            }
            if (attacker != null) {
                if (!sourceHoverTextList.isEmpty()) {
                    sourceHoverTextList.add("w \n");
                }
                sourceHoverTextList.add(Messenger.c((Object[])new Object[]{String.format("w %s: ", this.tr("Attacker")), attacker.method_5477()}));
            }
            lines.add(Messenger.c((Object[])new Object[]{sourceName, "g  " + this.tr("is receiving"), TextUtil.getSpaceText(), DamageLogger.getAmountText("r", this.initialAmount), TextUtil.getSpaceText(), "g " + this.tr(NAME), String.format("g , %s: ", this.tr("damage type")), TextUtil.getFancyText("w", Messenger.s((String)this.damageSource.method_5525()), sourceHoverTextList.isEmpty() ? null : Messenger.c((Object[])sourceHoverTextList.toArray(new Object[0])), attacker != null ? new class_2558(class_2558.class_2559.field_11745, TextUtil.getTeleportCommand(attacker)) : null)}));
            for (Modification modification : this.modificationList) {
                float oldAmount = modification.getOldAmount();
                float newAmount = modification.getNewAmount();
                float delta = Math.abs(newAmount - oldAmount);
                String sig = newAmount > oldAmount ? "+" : "-";
                String radio = oldAmount != 0.0f ? String.format("%.1f%%", Float.valueOf(100.0f * delta / oldAmount)) : "N/A%";
                lines.add(Messenger.c((Object[])new Object[]{"g  - ", DamageLogger.getAmountText("r", oldAmount), "g  -> ", DamageLogger.getAmountText(newAmount > oldAmount ? "r" : "d", newAmount), String.format("g  (%s", sig), TextUtil.attachHoverText(DamageLogger.getAmountText("g", delta), Messenger.s((String)String.format("%s%.6f", sig, Float.valueOf(delta)))), String.format("g , %s%s) %s", sig, radio, this.tr("due to")), TextUtil.getSpaceText(), modification.getReason().toText()}));
            }
            lines.add(Messenger.c((Object[])new Object[]{sourceName, "w  " + this.tr("actually received"), TextUtil.getSpaceText(), DamageLogger.getAmountText(finalAmount > 0.0f ? "r" : "w", finalAmount), TextUtil.getSpaceText(), String.format("g %s, ", this.tr(NAME)), String.format("w %s: ", this.tr("Remaining health")), DamageLogger.getAmountText(remainingHealth > 0.0f ? "l" : "r", remainingHealth)}));
            return (class_2554[])lines.stream().map(xva$0 -> Messenger.c((Object[])new Object[]{xva$0})).toArray(class_2554[]::new);
        }));
    }
}

