/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.entity;

import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpet.utils.Messenger;
import carpettisaddition.logging.ExtensionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.utils.TextUtil;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2554;
import net.minecraft.class_2588;
import net.minecraft.class_5321;

public abstract class EntityLogger<T extends class_1297>
extends AbstractLogger {
    protected final String loggerName;
    private static final EntityLogger<class_1297> translator = new EntityLogger<class_1297>("entity"){};

    public EntityLogger(String loggerName) {
        super(loggerName);
        this.loggerName = loggerName;
    }

    protected class_2554 getNameText(T entity) {
        return TextUtil.getTranslatedName(entity.method_5864().method_5882(), new Object[0]);
    }

    protected class_2554 getNameTextHoverText(T entity) {
        return null;
    }

    private class_2554 getNameTextRich(T entity) {
        class_2554 text = this.getNameText(entity);
        class_2554 hoverText = this.getNameTextHoverText(entity);
        if (hoverText != null) {
            TextUtil.attachHoverText(text, hoverText);
        }
        return text;
    }

    public void onEntityDespawn(T entity) {
        LoggerRegistry.getLogger((String)this.loggerName).log(option -> {
            if (!LoggingType.DESPAWN.isContainedIn(option)) {
                return null;
            }
            return new class_2554[]{Messenger.c((Object[])new Object[]{String.format("g [%s] ", entity.field_6002.method_8510()), this.getNameTextRich(entity), String.format("r %s", translator.tr(" despawned")), "g  @ ", TextUtil.getCoordinateText("w", entity.method_19538(), (class_5321<class_1937>)entity.field_6002.method_27983())})};
        });
    }

    public void onEntityDied(T entity, class_1282 source, float amount) {
        LoggerRegistry.getLogger((String)this.loggerName).log(option -> {
            if (!LoggingType.DIE.isContainedIn(option)) {
                return null;
            }
            class_2554 itemName = this.getNameTextRich(entity);
            class_2588 deathMessage = TextUtil.getTranslatedName("death.attack." + source.field_5841, TextUtil.attachFormatting(itemName, class_124.field_1068));
            TextUtil.attachFormatting((class_2554)deathMessage, class_124.field_1061);
            TextUtil.attachHoverText((class_2554)deathMessage, Messenger.s((String)String.format("%s: %.1f", translator.tr("damage_amount", "Damage amount"), Float.valueOf(amount))));
            return new class_2554[]{Messenger.c((Object[])new Object[]{String.format("g [%s] ", entity.field_6002.method_8510()), deathMessage, "g  @ ", TextUtil.getCoordinateText("w", entity.method_19538(), (class_5321<class_1937>)entity.field_6002.method_27983())})};
        });
    }

    public Logger getStandardLogger() {
        return ExtensionLoggerRegistry.standardLogger(this.loggerName, LoggingType.DIE.getName(), LoggingType.LOGGING_SUGGESTIONS);
    }

    public static enum LoggingType {
        DESPAWN("despawn"),
        DIE("die");

        private final String name;
        public static final String[] LOGGING_SUGGESTIONS;

        private LoggingType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isContainedIn(String option) {
            return Arrays.asList(option.split("[,. ]")).contains(this.getName());
        }

        static {
            List<String> list = Arrays.stream(LoggingType.values()).map(LoggingType::getName).collect(Collectors.toList());
            list.add(Joiner.on((String)",").join(list));
            LOGGING_SUGGESTIONS = list.toArray(new String[0]);
        }
    }
}

