/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming;

import carpet.logging.LoggerRegistry;
import carpet.utils.Messenger;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.enums.TickStage;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.events.BlockStateChangeEvent;
import carpettisaddition.logging.loggers.microtiming.message.IndentedMessage;
import carpettisaddition.logging.loggers.microtiming.message.MessageList;
import carpettisaddition.logging.loggers.microtiming.message.MessageType;
import carpettisaddition.logging.loggers.microtiming.message.MicroTimingMessage;
import carpettisaddition.logging.loggers.microtiming.tickstages.TickStageExtraBase;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2554;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class MicroTimingLogger
extends AbstractLogger {
    public static final String NAME = "microTiming";
    private TickStage stage;
    private String stageDetail;
    private TickStageExtraBase stageExtra;
    private final class_3218 world;
    public final MessageList messageList = new MessageList();
    private static final Set<class_2769<?>> INTEREST_PROPERTIES = new ReferenceArraySet();

    public MicroTimingLogger(class_3218 world) {
        super(NAME);
        this.world = world;
    }

    public void setTickStage(TickStage stage) {
        this.stage = stage;
        this.stageDetail = null;
        this.stageExtra = null;
    }

    public TickStage getTickStage() {
        return this.stage;
    }

    public void setTickStageDetail(String stageDetail) {
        this.stageDetail = stageDetail;
    }

    public String getTickStageDetail() {
        return this.stageDetail;
    }

    public void setTickStageExtra(TickStageExtraBase extra) {
        this.stageExtra = extra;
    }

    public TickStageExtraBase getTickStageExtra() {
        return this.stageExtra;
    }

    public class_3218 getWorld() {
        return this.world;
    }

    public void onSetBlockState(class_1937 world, class_2338 pos, class_2680 oldState, class_2680 newState, Boolean returnValue, int flags, EventType eventType) {
        class_1767 color = null;
        BlockStateChangeEvent event = new BlockStateChangeEvent(eventType, returnValue, newState.method_26204(), flags);
        for (class_2769 property : newState.method_28501()) {
            if (!INTEREST_PROPERTIES.contains(property)) continue;
            if (color == null) {
                Optional<class_1767> optionalDyeColor = MicroTimingUtil.getWoolOrEndRodWoolColor(world, pos);
                if (!optionalDyeColor.isPresent()) break;
                color = optionalDyeColor.get();
            }
            event.addChanges(property.method_11899(), oldState.method_11654(property), newState.method_11654(property));
        }
        if (event.hasChanges()) {
            this.addMessage(color, world, pos, event);
        }
    }

    public void addMessage(class_1767 color, class_1937 world, class_2338 pos, BaseEvent event) {
        MicroTimingMessage message = new MicroTimingMessage(this, (class_5321<class_1937>)world.method_27983(), pos, color, event);
        if (message.getEvent().getEventType() != EventType.ACTION_END) {
            this.messageList.addMessageAndIndent(message);
        } else {
            this.messageList.addMessageAndUnIndent(message);
        }
    }

    public void addMessage(class_1937 world, class_2338 pos, BaseEvent event, BiFunction<class_1937, class_2338, Optional<class_1767>> woolGetter) {
        Optional<class_1767> color = woolGetter.apply(world, pos);
        color.ifPresent(dyeColor -> this.addMessage((class_1767)dyeColor, world, pos, event));
    }

    public void addMessage(class_1937 world, class_2338 pos, BaseEvent event) {
        this.addMessage(world, pos, event, MicroTimingUtil::getWoolOrEndRodWoolColor);
    }

    private class_2554 getMergedResult(int count, IndentedMessage previousMessage) {
        return Messenger.c((Object[])new Object[]{MicroTimingMessage.getIndentationText(previousMessage.getIndentation()), TextUtil.getFancyText("g", Messenger.s((String)String.format("  +%dx", count)), Messenger.c((Object[])new Object[]{String.format("w %s\n", String.format(this.tr("merged_message", "Merged %d more same message" + (count > 1 ? "s" : "")), count)), previousMessage.getMessage().toText(0, true)}), null)});
    }

    private class_2554[] getTrimmedMessages(List<IndentedMessage> flushedMessages, LoggingOption option) {
        ArrayList msg = Lists.newArrayList();
        HashSet messageHashSet = Sets.newHashSet();
        msg.add(Messenger.s((String)" "));
        msg.add(Messenger.c((Object[])new Object[]{"f [", "f " + this.tr("GameTime"), "^w world.getTime()", "g  " + this.world.method_8510(), "f  @ ", TextUtil.getFancyText("g", TextUtil.getDimensionNameText((class_5321<class_1937>)this.world.method_27983()), Messenger.s((String)this.world.method_27983().method_29177().toString()), null), "f ] ------------"}));
        int skipCount = 0;
        Iterator<IndentedMessage> iterator = flushedMessages.iterator();
        IndentedMessage previousMessage = null;
        while (iterator.hasNext()) {
            boolean showThisMessage;
            IndentedMessage message = iterator.next();
            boolean bl = showThisMessage = option == LoggingOption.ALL || message.getMessage().getMessageType() == MessageType.PROCEDURE;
            if (!showThisMessage && option == LoggingOption.MERGED) {
                boolean bl2 = showThisMessage = previousMessage == null || !message.getMessage().equals(previousMessage.getMessage());
            }
            if (!showThisMessage && option == LoggingOption.UNIQUE) {
                showThisMessage = messageHashSet.add(message.getMessage());
            }
            if (showThisMessage) {
                if (option == LoggingOption.MERGED && previousMessage != null && skipCount > 0) {
                    msg.add(this.getMergedResult(skipCount, previousMessage));
                }
                msg.add(message.toText());
                previousMessage = message;
                skipCount = 0;
            } else {
                ++skipCount;
            }
            if (iterator.hasNext() || option != LoggingOption.MERGED || skipCount <= 0) continue;
            msg.add(this.getMergedResult(skipCount, previousMessage));
        }
        return msg.toArray(new class_2554[0]);
    }

    public void flushMessages() {
        List<IndentedMessage> flushedMessages;
        if (!this.messageList.isEmpty() && !(flushedMessages = this.messageList.flush()).isEmpty()) {
            EnumMap<LoggingOption, class_2554[]> flushedTrimmedMessages = new EnumMap<LoggingOption, class_2554[]>(LoggingOption.class);
            for (LoggingOption option2 : LoggingOption.values()) {
                flushedTrimmedMessages.put(option2, this.getTrimmedMessages(flushedMessages, option2));
            }
            LoggerRegistry.getLogger((String)NAME).log(option -> (class_2554[])flushedTrimmedMessages.get((Object)LoggingOption.getOrDefault(option)));
        }
    }

    static {
        INTEREST_PROPERTIES.add((class_2769<?>)class_2741.field_12484);
        INTEREST_PROPERTIES.add((class_2769<?>)class_2741.field_12548);
        INTEREST_PROPERTIES.add((class_2769<?>)class_2741.field_12511);
        INTEREST_PROPERTIES.add((class_2769<?>)class_2741.field_12502);
    }

    public static enum LoggingOption {
        MERGED,
        ALL,
        UNIQUE;

        public static final LoggingOption DEFAULT;

        public static LoggingOption getOrDefault(String option) {
            LoggingOption loggingOption;
            try {
                loggingOption = LoggingOption.valueOf(option.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                loggingOption = DEFAULT;
            }
            return loggingOption;
        }

        static {
            DEFAULT = MERGED;
        }
    }
}

