/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.logging.ExtensionLoggerRegistry;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLogger;
import carpettisaddition.logging.loggers.microtiming.enums.BlockUpdateType;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.enums.TickStage;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.events.DetectBlockUpdateEvent;
import carpettisaddition.logging.loggers.microtiming.events.EmitBlockUpdateEvent;
import carpettisaddition.logging.loggers.microtiming.events.EmitBlockUpdateRedstoneDustEvent;
import carpettisaddition.logging.loggers.microtiming.events.ExecuteBlockEventEvent;
import carpettisaddition.logging.loggers.microtiming.events.ExecuteTileTickEvent;
import carpettisaddition.logging.loggers.microtiming.events.ScheduleBlockEventEvent;
import carpettisaddition.logging.loggers.microtiming.events.ScheduleTileTickEvent;
import carpettisaddition.logging.loggers.microtiming.interfaces.IServerWorld;
import carpettisaddition.logging.loggers.microtiming.tickstages.TickStageExtraBase;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.translations.Translator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1767;
import net.minecraft.class_1919;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_1954;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class MicroTimingLoggerManager {
    private static MicroTimingLoggerManager instance;
    private final Map<class_3218, MicroTimingLogger> loggers = new Reference2ObjectArrayMap();
    private static final Translator TRANSLATOR;
    private long lastFlushTime = -1L;

    public MicroTimingLoggerManager(MinecraftServer minecraftServer) {
        for (class_3218 world : minecraftServer.method_3738()) {
            this.loggers.put(world, ((IServerWorld)world).getMicroTimingLogger());
        }
    }

    public static MicroTimingLoggerManager getInstance() {
        return instance;
    }

    public Map<class_3218, MicroTimingLogger> getLoggers() {
        return this.loggers;
    }

    public static boolean isLoggerActivated() {
        return CarpetTISAdditionSettings.microTiming && ExtensionLoggerRegistry.__microTiming && instance != null;
    }

    public static void attachServer(MinecraftServer minecraftServer) {
        instance = new MicroTimingLoggerManager(minecraftServer);
        CarpetTISAdditionServer.LOGGER.debug("Attached MicroTick loggers to " + MicroTimingLoggerManager.instance.loggers.size() + " worlds");
    }

    public static void detachServer() {
        instance = null;
        CarpetTISAdditionServer.LOGGER.debug("Detached MicroTick loggers");
    }

    private static Optional<MicroTimingLogger> getWorldLogger(class_1937 world) {
        if (instance != null && world instanceof class_3218) {
            return Optional.of(((IServerWorld)world).getMicroTimingLogger());
        }
        return Optional.empty();
    }

    public static String tr(String key, String text, boolean autoFormat) {
        return TRANSLATOR.tr(key, text, autoFormat);
    }

    public static String tr(String key, String text) {
        return TRANSLATOR.tr(key, text);
    }

    public static String tr(String key) {
        return TRANSLATOR.tr(key);
    }

    public static void onEvent(class_1937 world, class_2338 pos, Supplier<BaseEvent> supplier, BiFunction<class_1937, class_2338, Optional<class_1767>> woolGetter) {
        if (MicroTimingLoggerManager.isLoggerActivated()) {
            MicroTimingLoggerManager.getWorldLogger(world).ifPresent(logger -> logger.addMessage(world, pos, (BaseEvent)supplier.get(), woolGetter));
        }
    }

    public static void onEvent(class_1937 world, class_2338 pos, Supplier<BaseEvent> supplier) {
        if (MicroTimingLoggerManager.isLoggerActivated()) {
            MicroTimingLoggerManager.getWorldLogger(world).ifPresent(logger -> logger.addMessage(world, pos, (BaseEvent)supplier.get()));
        }
    }

    public static void onBlockUpdate(class_1937 world, class_2338 pos, class_2248 fromBlock, BlockUpdateType updateType, class_2350 exceptSide, EventType eventType) {
        MicroTimingLoggerManager.onEvent(world, pos, () -> new DetectBlockUpdateEvent(eventType, fromBlock, updateType, () -> updateType.getUpdateOrderList(exceptSide)), MicroTimingUtil::getEndRodWoolColor);
    }

    public static void onSetBlockState(class_1937 world, class_2338 pos, class_2680 oldState, class_2680 newState, Boolean returnValue, int flags, EventType eventType) {
        if (MicroTimingLoggerManager.isLoggerActivated() && oldState.method_26204() == newState.method_26204()) {
            MicroTimingLoggerManager.getWorldLogger(world).ifPresent(logger -> logger.onSetBlockState(world, pos, oldState, newState, returnValue, flags, eventType));
        }
    }

    public static void onExecuteTileTickEvent(class_1937 world, class_1954<class_2248> event, EventType eventType) {
        MicroTimingLoggerManager.onEvent(world, event.field_9322, () -> new ExecuteTileTickEvent(eventType, event));
    }

    public static void onScheduleTileTickEvent(class_1937 world, class_2248 block, class_2338 pos, int delay, class_1953 priority, Boolean success) {
        MicroTimingLoggerManager.onEvent(world, pos, () -> new ScheduleTileTickEvent(block, pos, delay, priority, success));
    }

    public static void onScheduleTileTickEvent(class_1937 world, class_2248 block, class_2338 pos, int delay, class_1953 priority) {
        MicroTimingLoggerManager.onScheduleTileTickEvent(world, block, pos, delay, priority, null);
    }

    public static void onScheduleTileTickEvent(class_1937 world, class_2248 block, class_2338 pos, int delay) {
        MicroTimingLoggerManager.onScheduleTileTickEvent(world, block, pos, delay, class_1953.field_9314);
    }

    public static void onExecuteBlockEvent(class_1937 world, class_1919 blockAction, Boolean returnValue, ExecuteBlockEventEvent.FailInfo failInfo, EventType eventType) {
        MicroTimingLoggerManager.onEvent(world, blockAction.method_8306(), () -> new ExecuteBlockEventEvent(eventType, blockAction, returnValue, failInfo));
    }

    public static void onScheduleBlockEvent(class_1937 world, class_1919 blockAction, boolean success) {
        MicroTimingLoggerManager.onEvent(world, blockAction.method_8306(), () -> new ScheduleBlockEventEvent(blockAction, success));
    }

    public static void onEmitBlockUpdate(class_1937 world, class_2248 block, class_2338 pos, EventType eventType, String methodName) {
        MicroTimingLoggerManager.onEvent(world, pos, () -> new EmitBlockUpdateEvent(eventType, block, methodName));
    }

    public static void onEmitBlockUpdateRedstoneDust(class_1937 world, class_2248 block, class_2338 pos, EventType eventType, String methodName, Collection<class_2338> updateOrder) {
        MicroTimingLoggerManager.onEvent(world, pos, () -> new EmitBlockUpdateRedstoneDustEvent(eventType, block, methodName, pos, updateOrder));
    }

    public static void setTickStage(class_1937 world, TickStage stage) {
        MicroTimingLoggerManager.getWorldLogger(world).ifPresent(logger -> logger.setTickStage(stage));
    }

    public static void setTickStage(TickStage stage) {
        if (instance != null) {
            for (MicroTimingLogger logger : MicroTimingLoggerManager.instance.loggers.values()) {
                logger.setTickStage(stage);
            }
        }
    }

    public static void setTickStageDetail(class_1937 world, String detail) {
        MicroTimingLoggerManager.getWorldLogger(world).ifPresent(logger -> logger.setTickStageDetail(detail));
    }

    public static void setTickStageExtra(class_1937 world, TickStageExtraBase stage) {
        MicroTimingLoggerManager.getWorldLogger(world).ifPresent(logger -> logger.setTickStageExtra(stage));
    }

    public static void setTickStageExtra(TickStageExtraBase stage) {
        if (instance != null) {
            for (MicroTimingLogger logger : MicroTimingLoggerManager.instance.loggers.values()) {
                logger.setTickStageExtra(stage);
            }
        }
    }

    private void flush(long gameTime) {
        if (gameTime != this.lastFlushTime) {
            this.lastFlushTime = gameTime;
            for (MicroTimingLogger logger : this.loggers.values()) {
                logger.flushMessages();
            }
        }
    }

    public static void flushMessages(long gameTime) {
        if (instance != null && MicroTimingLoggerManager.isLoggerActivated()) {
            instance.flush(gameTime);
        }
    }

    public static Optional<TickStage> getTickStage(class_1937 world) {
        return MicroTimingLoggerManager.getWorldLogger(world).map(MicroTimingLogger::getTickStage);
    }

    public static Optional<TickStage> getTickStage() {
        Iterator<class_3218> iterator = MicroTimingLoggerManager.getInstance().getLoggers().keySet().iterator();
        return iterator.hasNext() ? MicroTimingLoggerManager.getTickStage((class_1937)iterator.next()) : Optional.empty();
    }

    static {
        TRANSLATOR = new MicroTimingLogger(null).getTranslator();
    }
}

