/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.enums;

import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.utils.TextUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Iterator;
import net.minecraft.class_2350;

public enum BlockUpdateType {
    BLOCK_UPDATE("BlockUpdates", new String[]{"Neighbor Changed", "Neighbor Update"}, Constants.access$000()),
    BLOCK_UPDATE_EXCEPT("BlockUpdates Except", new String[]{"Neighbor Changed Except", "Neighbor Update Except"}, Constants.access$000()),
    STATE_UPDATE("StateUpdates", new String[]{"Post Placement", "Update Shape"}, Constants.access$100()),
    COMPARATOR_UPDATE("ComparatorUpdates", new String[]{"Block update only to comparators"}, Constants.access$200());

    private final String name;
    private final String[] aka;
    private final class_2350[] updateOrder;

    private BlockUpdateType(String name, String[] aka, class_2350[] updateOrder) {
        this.name = name;
        this.aka = aka;
        this.updateOrder = updateOrder;
    }

    private String tr(String text) {
        return MicroTimingLoggerManager.tr("block_update_type." + text, text, true);
    }

    public String toString() {
        return this.tr(this.name);
    }

    public String getUpdateOrderList(class_2350 skipSide) {
        int counter = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.tr("aka"));
        stringBuilder.append(TextUtil.getSpace());
        stringBuilder.append(Joiner.on((String)", ").join((Object[])this.aka));
        stringBuilder.append('\n');
        for (class_2350 direction : this.updateOrder) {
            if (skipSide == direction) continue;
            if (counter > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(String.format("%d. %s", ++counter, MicroTimingUtil.getFormattedDirectionString(direction)));
        }
        if (skipSide != null) {
            stringBuilder.append(String.format("\n%s: %s", this.tr("Except"), skipSide));
        }
        return stringBuilder.toString();
    }

    private static class Constants {
        private static final class_2350[] BLOCK_UPDATE_ORDER = new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035};
        private static final class_2350[] STATE_UPDATE_ORDER = new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11043, class_2350.field_11035, class_2350.field_11033, class_2350.field_11036};
        private static final class_2350[] COMPARATOR_UPDATE_ORDER = Lists.newArrayList((Iterator)class_2350.class_2353.field_11062.iterator()).toArray(new class_2350[0]);

        private Constants() {
        }

        static /* synthetic */ class_2350[] access$000() {
            return BLOCK_UPDATE_ORDER;
        }

        static /* synthetic */ class_2350[] access$100() {
            return STATE_UPDATE_ORDER;
        }

        static /* synthetic */ class_2350[] access$200() {
            return COMPARATOR_UPDATE_ORDER;
        }
    }
}

