/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpet.utils.Messenger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.BlockUpdateType;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2554;

public class DetectBlockUpdateEvent
extends BaseEvent {
    private final BlockUpdateType updateType;
    private final Supplier<String> updateTypeExtraMessage;
    private String updateTypeExtraMessageCache;
    private final class_2248 fromBlock;

    public DetectBlockUpdateEvent(EventType eventType, class_2248 fromBlock, BlockUpdateType blockUpdateType, Supplier<String> updateTypeExtraMessage) {
        super(eventType, "detect_block_update");
        this.fromBlock = fromBlock;
        this.updateType = blockUpdateType;
        this.updateTypeExtraMessage = updateTypeExtraMessage;
        this.updateTypeExtraMessageCache = null;
    }

    private String getUpdateTypeExtraMessage() {
        if (this.updateTypeExtraMessageCache == null) {
            this.updateTypeExtraMessageCache = this.updateTypeExtraMessage.get();
        }
        return this.updateTypeExtraMessageCache;
    }

    @Override
    public class_2554 toText() {
        ArrayList list = Lists.newArrayList();
        list.add(this.getEnclosedTranslatedBlockNameHeaderText(this.fromBlock));
        list.add("c " + MicroTimingLoggerManager.tr("Emit"));
        list.add(TextUtil.getSpaceText());
        list.add("c " + (Object)((Object)this.updateType));
        list.add("^w " + this.getUpdateTypeExtraMessage());
        list.add(TextUtil.getSpaceText());
        switch (this.getEventType()) {
            case ACTION_START: {
                list.add("q " + MicroTimingLoggerManager.tr("started"));
                break;
            }
            case ACTION_END: {
                list.add("q " + MicroTimingLoggerManager.tr("ended"));
                break;
            }
            default: {
                list.add("q " + this.tr("detected"));
            }
        }
        return Messenger.c((Object[])list.toArray(new Object[0]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetectBlockUpdateEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DetectBlockUpdateEvent that = (DetectBlockUpdateEvent)o;
        return this.updateType == that.updateType && Objects.equals(this.getUpdateTypeExtraMessage(), that.getUpdateTypeExtraMessage()) && Objects.equals(this.fromBlock, that.fromBlock);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.updateType, this.getUpdateTypeExtraMessage(), this.fromBlock});
    }
}

