/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpet.utils.Messenger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2248;
import net.minecraft.class_2554;

public class EmitBlockUpdateEvent
extends BaseEvent {
    private final class_2248 block;
    private final String methodName;

    public EmitBlockUpdateEvent(EventType eventType, class_2248 block, String methodName) {
        super(eventType, "emit_block_update");
        this.block = block;
        this.methodName = methodName;
    }

    @Override
    public boolean isImportant() {
        return false;
    }

    protected class_2554 getUpdatesTextHoverText() {
        return Messenger.s((String)String.format("%s: %s", this.tr("method_name", "Method name (yarn)"), this.methodName));
    }

    @Override
    public class_2554 toText() {
        ArrayList list = Lists.newArrayList();
        list.add(this.getEnclosedTranslatedBlockNameHeaderText(this.block));
        class_2554 updatesText = Messenger.c((Object[])new Object[]{"c " + this.tr("Emit"), TextUtil.getSpaceText(), "c " + this.tr("Updates")});
        if (this.methodName != null) {
            TextUtil.attachHoverText(updatesText, this.getUpdatesTextHoverText());
        }
        list.add(updatesText);
        switch (this.getEventType()) {
            case ACTION_START: {
                list.add(TextUtil.getSpaceText());
                list.add("q " + MicroTimingLoggerManager.tr("started"));
                break;
            }
            case ACTION_END: {
                list.add(TextUtil.getSpaceText());
                list.add("q " + MicroTimingLoggerManager.tr("ended"));
                break;
            }
        }
        return Messenger.c((Object[])list.toArray(new Object[0]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmitBlockUpdateEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EmitBlockUpdateEvent that = (EmitBlockUpdateEvent)o;
        return Objects.equals(this.block, that.block) && Objects.equals(this.methodName, that.methodName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.block, this.methodName);
    }
}

