/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpet.utils.Messenger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.enums.PistonBlockEventType;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.logging.loggers.microtiming.utils.ToTextAble;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1919;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2554;
import net.minecraft.class_2665;

public class ExecuteBlockEventEvent
extends BaseEvent {
    private final class_1919 blockAction;
    private Boolean returnValue;
    private FailInfo failInfo;

    public ExecuteBlockEventEvent(EventType eventType, class_1919 blockAction, Boolean returnValue, FailInfo failInfo) {
        super(eventType, "execute_block_event");
        this.blockAction = blockAction;
        this.returnValue = returnValue;
        this.failInfo = failInfo;
        if (this.failInfo != null) {
            this.failInfo.setEvent(this);
        }
    }

    public static String getMessageExtraMessengerHoverText(class_1919 blockAction) {
        int eventID = blockAction.method_8307();
        int eventParam = blockAction.method_8308();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("^w eventID: %d", eventID));
        if (blockAction.method_8309() instanceof class_2665) {
            builder.append(String.format(" (%s)", new Object[]{PistonBlockEventType.byId(eventID)}));
        }
        builder.append(String.format("\neventParam: %d", eventParam));
        if (blockAction.method_8309() instanceof class_2665) {
            builder.append(String.format(" (%s)", MicroTimingUtil.getFormattedDirectionString(class_2350.method_10143((int)eventParam))));
        }
        return builder.toString();
    }

    @Override
    public class_2554 toText() {
        ArrayList list = Lists.newArrayList();
        list.add(this.getEnclosedTranslatedBlockNameHeaderText(this.blockAction.method_8309()));
        list.add("c " + this.tr("Execute"));
        if (this.blockAction.method_8309() instanceof class_2665) {
            list.add(TextUtil.getSpaceText());
            list.add("c " + (Object)((Object)PistonBlockEventType.byId(this.blockAction.method_8307())));
        } else {
            list.add(TextUtil.getSpaceText());
            list.add("c " + this.tr("BlockEvent"));
        }
        list.add(ExecuteBlockEventEvent.getMessageExtraMessengerHoverText(this.blockAction));
        if (this.getEventType() == EventType.ACTION_END) {
            list.add(TextUtil.getSpaceText());
            list.add("q " + MicroTimingLoggerManager.tr("ended"));
        }
        if (this.returnValue != null) {
            list.add("w  ");
            list.add(MicroTimingUtil.getSuccessText(this.returnValue, true, this.failInfo != null && this.returnValue == false ? this.failInfo.toText() : null));
        }
        return Messenger.c((Object[])list.toArray(new Object[0]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecuteBlockEventEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecuteBlockEventEvent that = (ExecuteBlockEventEvent)o;
        return Objects.equals(this.blockAction, that.blockAction) && Objects.equals(this.returnValue, that.returnValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.blockAction, this.returnValue);
    }

    @Override
    public void mergeQuitEvent(BaseEvent quitEvent) {
        super.mergeQuitEvent(quitEvent);
        if (quitEvent instanceof ExecuteBlockEventEvent) {
            this.returnValue = ((ExecuteBlockEventEvent)quitEvent).returnValue;
            this.failInfo = ((ExecuteBlockEventEvent)quitEvent).failInfo;
        }
    }

    public static enum FailReason {
        BLOCK_CHANGED,
        EVENT_FAIL;

    }

    public static class FailInfo
    implements ToTextAble {
        private final FailReason reason;
        private final class_2248 actualBlock;
        private ExecuteBlockEventEvent event;

        public FailInfo(FailReason reason, class_2248 block) {
            this.reason = reason;
            this.actualBlock = block;
        }

        public void setEvent(ExecuteBlockEventEvent event) {
            this.event = event;
        }

        @Override
        public class_2554 toText() {
            switch (this.reason) {
                case BLOCK_CHANGED: {
                    return Messenger.c((Object[])new Object[]{"w " + this.event.tr("fail_info.block_changed", "Block has changed"), "w : ", TextUtil.getBlockName(this.event.blockAction.method_8309()), "g  -> ", TextUtil.getBlockName(this.actualBlock)});
                }
            }
            return Messenger.c((Object[])new Object[]{"w " + this.event.tr("fail_info.event_fail", "Event Failed")});
        }
    }
}

